@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.vpclattice.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property enabled Indicates whether health checking is enabled. Defaults to `true`.
 * @property healthCheckIntervalSeconds The approximate amount of time, in seconds, between health checks of an individual target. The range is 5–300 seconds. The default is 30 seconds.
 * @property healthCheckTimeoutSeconds The amount of time, in seconds, to wait before reporting a target as unhealthy. The range is 1–120 seconds. The default is 5 seconds.
 * * `healthy_threshold_count ` - (Optional) The number of consecutive successful health checks required before considering an unhealthy target healthy. The range is 2–10. The default is 5.
 * @property healthyThresholdCount
 * @property matcher The codes to use when checking for a successful response from a target. These are called _Success codes_ in the console.
 * @property path The destination for health checks on the targets. If the protocol version is HTTP/1.1 or HTTP/2, specify a valid URI (for example, /path?query). The default path is `/`. Health checks are not supported if the protocol version is gRPC, however, you can choose HTTP/1.1 or HTTP/2 and specify a valid URI.
 * @property port The port used when performing health checks on targets. The default setting is the port that a target receives traffic on.
 * @property protocol The protocol used when performing health checks on targets. The possible protocols are `HTTP` and `HTTPS`.
 * @property protocolVersion The protocol version used when performing health checks on targets. The possible protocol versions are `HTTP1` and `HTTP2`. The default is `HTTP1`.
 * @property unhealthyThresholdCount The number of consecutive failed health checks required before considering a target unhealthy. The range is 2–10. The default is 2.
 */
public data class TargetGroupConfigHealthCheck(
    public val enabled: Boolean? = null,
    public val healthCheckIntervalSeconds: Int? = null,
    public val healthCheckTimeoutSeconds: Int? = null,
    public val healthyThresholdCount: Int? = null,
    public val matcher: TargetGroupConfigHealthCheckMatcher? = null,
    public val path: String? = null,
    public val port: Int? = null,
    public val protocol: String? = null,
    public val protocolVersion: String? = null,
    public val unhealthyThresholdCount: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.vpclattice.outputs.TargetGroupConfigHealthCheck): TargetGroupConfigHealthCheck = TargetGroupConfigHealthCheck(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            healthCheckIntervalSeconds = javaType.healthCheckIntervalSeconds().map({ args0 ->
                args0
            }).orElse(null),
            healthCheckTimeoutSeconds = javaType.healthCheckTimeoutSeconds().map({ args0 ->
                args0
            }).orElse(null),
            healthyThresholdCount = javaType.healthyThresholdCount().map({ args0 -> args0 }).orElse(null),
            matcher = javaType.matcher().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.vpclattice.kotlin.outputs.TargetGroupConfigHealthCheckMatcher.Companion.toKotlin(args0)
                })
            }).orElse(null),
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
            protocolVersion = javaType.protocolVersion().map({ args0 -> args0 }).orElse(null),
            unhealthyThresholdCount = javaType.unhealthyThresholdCount().map({ args0 -> args0 }).orElse(null),
        )
    }
}
