@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin

import com.pulumi.aws.waf.kotlin.outputs.GeoMatchSetGeoMatchConstraint
import com.pulumi.aws.waf.kotlin.outputs.GeoMatchSetGeoMatchConstraint.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [GeoMatchSet].
 */
@PulumiTagMarker
public class GeoMatchSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GeoMatchSetArgs = GeoMatchSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GeoMatchSetArgsBuilder.() -> Unit) {
        val builder = GeoMatchSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GeoMatchSet {
        val builtJavaResource = com.pulumi.aws.waf.GeoMatchSet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GeoMatchSet(builtJavaResource)
    }
}

/**
 * Provides a WAF Geo Match Set Resource
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const geoMatchSet = new aws.waf.GeoMatchSet("geo_match_set", {
 *     name: "geo_match_set",
 *     geoMatchConstraints: [
 *         {
 *             type: "Country",
 *             value: "US",
 *         },
 *         {
 *             type: "Country",
 *             value: "CA",
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * geo_match_set = aws.waf.GeoMatchSet("geo_match_set",
 *     name="geo_match_set",
 *     geo_match_constraints=[
 *         {
 *             "type": "Country",
 *             "value": "US",
 *         },
 *         {
 *             "type": "Country",
 *             "value": "CA",
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var geoMatchSet = new Aws.Waf.GeoMatchSet("geo_match_set", new()
 *     {
 *         Name = "geo_match_set",
 *         GeoMatchConstraints = new[]
 *         {
 *             new Aws.Waf.Inputs.GeoMatchSetGeoMatchConstraintArgs
 *             {
 *                 Type = "Country",
 *                 Value = "US",
 *             },
 *             new Aws.Waf.Inputs.GeoMatchSetGeoMatchConstraintArgs
 *             {
 *                 Type = "Country",
 *                 Value = "CA",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/waf"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := waf.NewGeoMatchSet(ctx, "geo_match_set", &waf.GeoMatchSetArgs{
 * 			Name: pulumi.String("geo_match_set"),
 * 			GeoMatchConstraints: waf.GeoMatchSetGeoMatchConstraintArray{
 * 				&waf.GeoMatchSetGeoMatchConstraintArgs{
 * 					Type:  pulumi.String("Country"),
 * 					Value: pulumi.String("US"),
 * 				},
 * 				&waf.GeoMatchSetGeoMatchConstraintArgs{
 * 					Type:  pulumi.String("Country"),
 * 					Value: pulumi.String("CA"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.waf.GeoMatchSet;
 * import com.pulumi.aws.waf.GeoMatchSetArgs;
 * import com.pulumi.aws.waf.inputs.GeoMatchSetGeoMatchConstraintArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var geoMatchSet = new GeoMatchSet("geoMatchSet", GeoMatchSetArgs.builder()
 *             .name("geo_match_set")
 *             .geoMatchConstraints(
 *                 GeoMatchSetGeoMatchConstraintArgs.builder()
 *                     .type("Country")
 *                     .value("US")
 *                     .build(),
 *                 GeoMatchSetGeoMatchConstraintArgs.builder()
 *                     .type("Country")
 *                     .value("CA")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   geoMatchSet:
 *     type: aws:waf:GeoMatchSet
 *     name: geo_match_set
 *     properties:
 *       name: geo_match_set
 *       geoMatchConstraints:
 *         - type: Country
 *           value: US
 *         - type: Country
 *           value: CA
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import WAF Geo Match Set using their ID. For example:
 * ```sh
 * $ pulumi import aws:waf/geoMatchSet:GeoMatchSet example a1b2c3d4-d5f6-7777-8888-9999aaaabbbbcccc
 * ```
 */
public class GeoMatchSet internal constructor(
    override val javaResource: com.pulumi.aws.waf.GeoMatchSet,
) : KotlinCustomResource(javaResource, GeoMatchSetMapper) {
    /**
     * Amazon Resource Name (ARN)
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The GeoMatchConstraint objects which contain the country that you want AWS WAF to search for.
     */
    public val geoMatchConstraints: Output<List<GeoMatchSetGeoMatchConstraint>>?
        get() = javaResource.geoMatchConstraints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * The name or description of the GeoMatchSet.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })
}

public object GeoMatchSetMapper : ResourceMapper<GeoMatchSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.waf.GeoMatchSet::class == javaResource::class

    override fun map(javaResource: Resource): GeoMatchSet = GeoMatchSet(
        javaResource as
            com.pulumi.aws.waf.GeoMatchSet,
    )
}

/**
 * @see [GeoMatchSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GeoMatchSet].
 */
public suspend fun geoMatchSet(name: String, block: suspend GeoMatchSetResourceBuilder.() -> Unit): GeoMatchSet {
    val builder = GeoMatchSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GeoMatchSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun geoMatchSet(name: String): GeoMatchSet {
    val builder = GeoMatchSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
