@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin

import com.pulumi.aws.waf.GeoMatchSetArgs.builder
import com.pulumi.aws.waf.kotlin.inputs.GeoMatchSetGeoMatchConstraintArgs
import com.pulumi.aws.waf.kotlin.inputs.GeoMatchSetGeoMatchConstraintArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a WAF Geo Match Set Resource
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const geoMatchSet = new aws.waf.GeoMatchSet("geo_match_set", {
 *     name: "geo_match_set",
 *     geoMatchConstraints: [
 *         {
 *             type: "Country",
 *             value: "US",
 *         },
 *         {
 *             type: "Country",
 *             value: "CA",
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * geo_match_set = aws.waf.GeoMatchSet("geo_match_set",
 *     name="geo_match_set",
 *     geo_match_constraints=[
 *         {
 *             "type": "Country",
 *             "value": "US",
 *         },
 *         {
 *             "type": "Country",
 *             "value": "CA",
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var geoMatchSet = new Aws.Waf.GeoMatchSet("geo_match_set", new()
 *     {
 *         Name = "geo_match_set",
 *         GeoMatchConstraints = new[]
 *         {
 *             new Aws.Waf.Inputs.GeoMatchSetGeoMatchConstraintArgs
 *             {
 *                 Type = "Country",
 *                 Value = "US",
 *             },
 *             new Aws.Waf.Inputs.GeoMatchSetGeoMatchConstraintArgs
 *             {
 *                 Type = "Country",
 *                 Value = "CA",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/waf"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := waf.NewGeoMatchSet(ctx, "geo_match_set", &waf.GeoMatchSetArgs{
 * 			Name: pulumi.String("geo_match_set"),
 * 			GeoMatchConstraints: waf.GeoMatchSetGeoMatchConstraintArray{
 * 				&waf.GeoMatchSetGeoMatchConstraintArgs{
 * 					Type:  pulumi.String("Country"),
 * 					Value: pulumi.String("US"),
 * 				},
 * 				&waf.GeoMatchSetGeoMatchConstraintArgs{
 * 					Type:  pulumi.String("Country"),
 * 					Value: pulumi.String("CA"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.waf.GeoMatchSet;
 * import com.pulumi.aws.waf.GeoMatchSetArgs;
 * import com.pulumi.aws.waf.inputs.GeoMatchSetGeoMatchConstraintArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var geoMatchSet = new GeoMatchSet("geoMatchSet", GeoMatchSetArgs.builder()
 *             .name("geo_match_set")
 *             .geoMatchConstraints(
 *                 GeoMatchSetGeoMatchConstraintArgs.builder()
 *                     .type("Country")
 *                     .value("US")
 *                     .build(),
 *                 GeoMatchSetGeoMatchConstraintArgs.builder()
 *                     .type("Country")
 *                     .value("CA")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   geoMatchSet:
 *     type: aws:waf:GeoMatchSet
 *     name: geo_match_set
 *     properties:
 *       name: geo_match_set
 *       geoMatchConstraints:
 *         - type: Country
 *           value: US
 *         - type: Country
 *           value: CA
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import WAF Geo Match Set using their ID. For example:
 * ```sh
 * $ pulumi import aws:waf/geoMatchSet:GeoMatchSet example a1b2c3d4-d5f6-7777-8888-9999aaaabbbbcccc
 * ```
 * @property geoMatchConstraints The GeoMatchConstraint objects which contain the country that you want AWS WAF to search for.
 * @property name The name or description of the GeoMatchSet.
 */
public data class GeoMatchSetArgs(
    public val geoMatchConstraints: Output<List<GeoMatchSetGeoMatchConstraintArgs>>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.waf.GeoMatchSetArgs> {
    override fun toJava(): com.pulumi.aws.waf.GeoMatchSetArgs =
        com.pulumi.aws.waf.GeoMatchSetArgs.builder()
            .geoMatchConstraints(
                geoMatchConstraints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GeoMatchSetArgs].
 */
@PulumiTagMarker
public class GeoMatchSetArgsBuilder internal constructor() {
    private var geoMatchConstraints: Output<List<GeoMatchSetGeoMatchConstraintArgs>>? = null

    private var name: Output<String>? = null

    /**
     * @param value The GeoMatchConstraint objects which contain the country that you want AWS WAF to search for.
     */
    @JvmName("vecvtyuaaiiianvh")
    public suspend fun geoMatchConstraints(`value`: Output<List<GeoMatchSetGeoMatchConstraintArgs>>) {
        this.geoMatchConstraints = value
    }

    @JvmName("weqnonhrarjgacjq")
    public suspend fun geoMatchConstraints(vararg values: Output<GeoMatchSetGeoMatchConstraintArgs>) {
        this.geoMatchConstraints = Output.all(values.asList())
    }

    /**
     * @param values The GeoMatchConstraint objects which contain the country that you want AWS WAF to search for.
     */
    @JvmName("mkpmbbshffdhfxae")
    public suspend fun geoMatchConstraints(values: List<Output<GeoMatchSetGeoMatchConstraintArgs>>) {
        this.geoMatchConstraints = Output.all(values)
    }

    /**
     * @param value The name or description of the GeoMatchSet.
     */
    @JvmName("rvjkbdaoxwkkdnay")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The GeoMatchConstraint objects which contain the country that you want AWS WAF to search for.
     */
    @JvmName("myoyioldkcqqufhj")
    public suspend fun geoMatchConstraints(`value`: List<GeoMatchSetGeoMatchConstraintArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.geoMatchConstraints = mapped
    }

    /**
     * @param argument The GeoMatchConstraint objects which contain the country that you want AWS WAF to search for.
     */
    @JvmName("hsfbhtwcfsvnbkgf")
    public suspend fun geoMatchConstraints(argument: List<suspend GeoMatchSetGeoMatchConstraintArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GeoMatchSetGeoMatchConstraintArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.geoMatchConstraints = mapped
    }

    /**
     * @param argument The GeoMatchConstraint objects which contain the country that you want AWS WAF to search for.
     */
    @JvmName("oknbdanafmigffca")
    public suspend fun geoMatchConstraints(vararg argument: suspend GeoMatchSetGeoMatchConstraintArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GeoMatchSetGeoMatchConstraintArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.geoMatchConstraints = mapped
    }

    /**
     * @param argument The GeoMatchConstraint objects which contain the country that you want AWS WAF to search for.
     */
    @JvmName("kslhlnfynejvfgjl")
    public suspend fun geoMatchConstraints(argument: suspend GeoMatchSetGeoMatchConstraintArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GeoMatchSetGeoMatchConstraintArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.geoMatchConstraints = mapped
    }

    /**
     * @param values The GeoMatchConstraint objects which contain the country that you want AWS WAF to search for.
     */
    @JvmName("wntoyfisgsojhwkb")
    public suspend fun geoMatchConstraints(vararg values: GeoMatchSetGeoMatchConstraintArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.geoMatchConstraints = mapped
    }

    /**
     * @param value The name or description of the GeoMatchSet.
     */
    @JvmName("oodyolexvqpallbb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): GeoMatchSetArgs = GeoMatchSetArgs(
        geoMatchConstraints = geoMatchConstraints,
        name = name,
    )
}
