@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin

import com.pulumi.aws.waf.kotlin.outputs.IpSetIpSetDescriptor
import com.pulumi.aws.waf.kotlin.outputs.IpSetIpSetDescriptor.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [IpSet].
 */
@PulumiTagMarker
public class IpSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IpSetArgs = IpSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IpSetArgsBuilder.() -> Unit) {
        val builder = IpSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IpSet {
        val builtJavaResource = com.pulumi.aws.waf.IpSet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return IpSet(builtJavaResource)
    }
}

/**
 * Provides a WAF IPSet Resource
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const ipset = new aws.waf.IpSet("ipset", {
 *     name: "tfIPSet",
 *     ipSetDescriptors: [
 *         {
 *             type: "IPV4",
 *             value: "192.0.7.0/24",
 *         },
 *         {
 *             type: "IPV4",
 *             value: "10.16.16.0/16",
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * ipset = aws.waf.IpSet("ipset",
 *     name="tfIPSet",
 *     ip_set_descriptors=[
 *         {
 *             "type": "IPV4",
 *             "value": "192.0.7.0/24",
 *         },
 *         {
 *             "type": "IPV4",
 *             "value": "10.16.16.0/16",
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ipset = new Aws.Waf.IpSet("ipset", new()
 *     {
 *         Name = "tfIPSet",
 *         IpSetDescriptors = new[]
 *         {
 *             new Aws.Waf.Inputs.IpSetIpSetDescriptorArgs
 *             {
 *                 Type = "IPV4",
 *                 Value = "192.0.7.0/24",
 *             },
 *             new Aws.Waf.Inputs.IpSetIpSetDescriptorArgs
 *             {
 *                 Type = "IPV4",
 *                 Value = "10.16.16.0/16",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/waf"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := waf.NewIpSet(ctx, "ipset", &waf.IpSetArgs{
 * 			Name: pulumi.String("tfIPSet"),
 * 			IpSetDescriptors: waf.IpSetIpSetDescriptorArray{
 * 				&waf.IpSetIpSetDescriptorArgs{
 * 					Type:  pulumi.String("IPV4"),
 * 					Value: pulumi.String("192.0.7.0/24"),
 * 				},
 * 				&waf.IpSetIpSetDescriptorArgs{
 * 					Type:  pulumi.String("IPV4"),
 * 					Value: pulumi.String("10.16.16.0/16"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.waf.IpSet;
 * import com.pulumi.aws.waf.IpSetArgs;
 * import com.pulumi.aws.waf.inputs.IpSetIpSetDescriptorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ipset = new IpSet("ipset", IpSetArgs.builder()
 *             .name("tfIPSet")
 *             .ipSetDescriptors(
 *                 IpSetIpSetDescriptorArgs.builder()
 *                     .type("IPV4")
 *                     .value("192.0.7.0/24")
 *                     .build(),
 *                 IpSetIpSetDescriptorArgs.builder()
 *                     .type("IPV4")
 *                     .value("10.16.16.0/16")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   ipset:
 *     type: aws:waf:IpSet
 *     properties:
 *       name: tfIPSet
 *       ipSetDescriptors:
 *         - type: IPV4
 *           value: 192.0.7.0/24
 *         - type: IPV4
 *           value: 10.16.16.0/16
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import WAF IPSets using their ID. For example:
 * ```sh
 * $ pulumi import aws:waf/ipSet:IpSet example a1b2c3d4-d5f6-7777-8888-9999aaaabbbbcccc
 * ```
 */
public class IpSet internal constructor(
    override val javaResource: com.pulumi.aws.waf.IpSet,
) : KotlinCustomResource(javaResource, IpSetMapper) {
    /**
     * The ARN of the WAF IPSet.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * One or more pairs specifying the IP address type (IPV4 or IPV6) and the IP address range (in CIDR format) from which web requests originate.
     */
    public val ipSetDescriptors: Output<List<IpSetIpSetDescriptor>>?
        get() = javaResource.ipSetDescriptors().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * The name or description of the IPSet.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })
}

public object IpSetMapper : ResourceMapper<IpSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.waf.IpSet::class == javaResource::class

    override fun map(javaResource: Resource): IpSet = IpSet(javaResource as com.pulumi.aws.waf.IpSet)
}

/**
 * @see [IpSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IpSet].
 */
public suspend fun ipSet(name: String, block: suspend IpSetResourceBuilder.() -> Unit): IpSet {
    val builder = IpSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IpSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ipSet(name: String): IpSet {
    val builder = IpSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
