@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin

import com.pulumi.aws.waf.RateBasedRuleArgs.builder
import com.pulumi.aws.waf.kotlin.inputs.RateBasedRulePredicateArgs
import com.pulumi.aws.waf.kotlin.inputs.RateBasedRulePredicateArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a WAF Rate Based Rule Resource
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const ipset = new aws.waf.IpSet("ipset", {
 *     name: "tfIPSet",
 *     ipSetDescriptors: [{
 *         type: "IPV4",
 *         value: "192.0.7.0/24",
 *     }],
 * });
 * const wafrule = new aws.waf.RateBasedRule("wafrule", {
 *     name: "tfWAFRule",
 *     metricName: "tfWAFRule",
 *     rateKey: "IP",
 *     rateLimit: 100,
 *     predicates: [{
 *         dataId: ipset.id,
 *         negated: false,
 *         type: "IPMatch",
 *     }],
 * }, {
 *     dependsOn: [ipset],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * ipset = aws.waf.IpSet("ipset",
 *     name="tfIPSet",
 *     ip_set_descriptors=[{
 *         "type": "IPV4",
 *         "value": "192.0.7.0/24",
 *     }])
 * wafrule = aws.waf.RateBasedRule("wafrule",
 *     name="tfWAFRule",
 *     metric_name="tfWAFRule",
 *     rate_key="IP",
 *     rate_limit=100,
 *     predicates=[{
 *         "data_id": ipset.id,
 *         "negated": False,
 *         "type": "IPMatch",
 *     }],
 *     opts = pulumi.ResourceOptions(depends_on=[ipset]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ipset = new Aws.Waf.IpSet("ipset", new()
 *     {
 *         Name = "tfIPSet",
 *         IpSetDescriptors = new[]
 *         {
 *             new Aws.Waf.Inputs.IpSetIpSetDescriptorArgs
 *             {
 *                 Type = "IPV4",
 *                 Value = "192.0.7.0/24",
 *             },
 *         },
 *     });
 *     var wafrule = new Aws.Waf.RateBasedRule("wafrule", new()
 *     {
 *         Name = "tfWAFRule",
 *         MetricName = "tfWAFRule",
 *         RateKey = "IP",
 *         RateLimit = 100,
 *         Predicates = new[]
 *         {
 *             new Aws.Waf.Inputs.RateBasedRulePredicateArgs
 *             {
 *                 DataId = ipset.Id,
 *                 Negated = false,
 *                 Type = "IPMatch",
 *             },
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             ipset,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/waf"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		ipset, err := waf.NewIpSet(ctx, "ipset", &waf.IpSetArgs{
 * 			Name: pulumi.String("tfIPSet"),
 * 			IpSetDescriptors: waf.IpSetIpSetDescriptorArray{
 * 				&waf.IpSetIpSetDescriptorArgs{
 * 					Type:  pulumi.String("IPV4"),
 * 					Value: pulumi.String("192.0.7.0/24"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = waf.NewRateBasedRule(ctx, "wafrule", &waf.RateBasedRuleArgs{
 * 			Name:       pulumi.String("tfWAFRule"),
 * 			MetricName: pulumi.String("tfWAFRule"),
 * 			RateKey:    pulumi.String("IP"),
 * 			RateLimit:  pulumi.Int(100),
 * 			Predicates: waf.RateBasedRulePredicateArray{
 * 				&waf.RateBasedRulePredicateArgs{
 * 					DataId:  ipset.ID(),
 * 					Negated: pulumi.Bool(false),
 * 					Type:    pulumi.String("IPMatch"),
 * 				},
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			ipset,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.waf.IpSet;
 * import com.pulumi.aws.waf.IpSetArgs;
 * import com.pulumi.aws.waf.inputs.IpSetIpSetDescriptorArgs;
 * import com.pulumi.aws.waf.RateBasedRule;
 * import com.pulumi.aws.waf.RateBasedRuleArgs;
 * import com.pulumi.aws.waf.inputs.RateBasedRulePredicateArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ipset = new IpSet("ipset", IpSetArgs.builder()
 *             .name("tfIPSet")
 *             .ipSetDescriptors(IpSetIpSetDescriptorArgs.builder()
 *                 .type("IPV4")
 *                 .value("192.0.7.0/24")
 *                 .build())
 *             .build());
 *         var wafrule = new RateBasedRule("wafrule", RateBasedRuleArgs.builder()
 *             .name("tfWAFRule")
 *             .metricName("tfWAFRule")
 *             .rateKey("IP")
 *             .rateLimit(100)
 *             .predicates(RateBasedRulePredicateArgs.builder()
 *                 .dataId(ipset.id())
 *                 .negated(false)
 *                 .type("IPMatch")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(ipset)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   ipset:
 *     type: aws:waf:IpSet
 *     properties:
 *       name: tfIPSet
 *       ipSetDescriptors:
 *         - type: IPV4
 *           value: 192.0.7.0/24
 *   wafrule:
 *     type: aws:waf:RateBasedRule
 *     properties:
 *       name: tfWAFRule
 *       metricName: tfWAFRule
 *       rateKey: IP
 *       rateLimit: 100
 *       predicates:
 *         - dataId: ${ipset.id}
 *           negated: false
 *           type: IPMatch
 *     options:
 *       dependson:
 *         - ${ipset}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import WAF Rated Based Rule using the id. For example:
 * ```sh
 * $ pulumi import aws:waf/rateBasedRule:RateBasedRule wafrule a1b2c3d4-d5f6-7777-8888-9999aaaabbbbcccc
 * ```
 * @property metricName The name or description for the Amazon CloudWatch metric of this rule.
 * @property name The name or description of the rule.
 * @property predicates The objects to include in a rule (documented below).
 * @property rateKey Valid value is IP.
 * @property rateLimit The maximum number of requests, which have an identical value in the field specified by the RateKey, allowed in a five-minute period. Minimum value is 100.
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class RateBasedRuleArgs(
    public val metricName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val predicates: Output<List<RateBasedRulePredicateArgs>>? = null,
    public val rateKey: Output<String>? = null,
    public val rateLimit: Output<Int>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.waf.RateBasedRuleArgs> {
    override fun toJava(): com.pulumi.aws.waf.RateBasedRuleArgs =
        com.pulumi.aws.waf.RateBasedRuleArgs.builder()
            .metricName(metricName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .predicates(
                predicates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .rateKey(rateKey?.applyValue({ args0 -> args0 }))
            .rateLimit(rateLimit?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [RateBasedRuleArgs].
 */
@PulumiTagMarker
public class RateBasedRuleArgsBuilder internal constructor() {
    private var metricName: Output<String>? = null

    private var name: Output<String>? = null

    private var predicates: Output<List<RateBasedRulePredicateArgs>>? = null

    private var rateKey: Output<String>? = null

    private var rateLimit: Output<Int>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name or description for the Amazon CloudWatch metric of this rule.
     */
    @JvmName("dkxisgvoqnqsuwti")
    public suspend fun metricName(`value`: Output<String>) {
        this.metricName = value
    }

    /**
     * @param value The name or description of the rule.
     */
    @JvmName("ylqnkgbddslakjqn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The objects to include in a rule (documented below).
     */
    @JvmName("ekqexrfmoyrvgkcs")
    public suspend fun predicates(`value`: Output<List<RateBasedRulePredicateArgs>>) {
        this.predicates = value
    }

    @JvmName("liatqksswvqgddsp")
    public suspend fun predicates(vararg values: Output<RateBasedRulePredicateArgs>) {
        this.predicates = Output.all(values.asList())
    }

    /**
     * @param values The objects to include in a rule (documented below).
     */
    @JvmName("ivklhdvtidtmvbkk")
    public suspend fun predicates(values: List<Output<RateBasedRulePredicateArgs>>) {
        this.predicates = Output.all(values)
    }

    /**
     * @param value Valid value is IP.
     */
    @JvmName("utbjubahkrwdrtxg")
    public suspend fun rateKey(`value`: Output<String>) {
        this.rateKey = value
    }

    /**
     * @param value The maximum number of requests, which have an identical value in the field specified by the RateKey, allowed in a five-minute period. Minimum value is 100.
     */
    @JvmName("oswxhyweivmffivc")
    public suspend fun rateLimit(`value`: Output<Int>) {
        this.rateLimit = value
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vuokwftcsqwgfnnb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name or description for the Amazon CloudWatch metric of this rule.
     */
    @JvmName("ravgrtvlswbbljsj")
    public suspend fun metricName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricName = mapped
    }

    /**
     * @param value The name or description of the rule.
     */
    @JvmName("vjyowigyyracggss")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The objects to include in a rule (documented below).
     */
    @JvmName("sjsgmeoyenotlass")
    public suspend fun predicates(`value`: List<RateBasedRulePredicateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.predicates = mapped
    }

    /**
     * @param argument The objects to include in a rule (documented below).
     */
    @JvmName("rjolwswexhpvpola")
    public suspend fun predicates(argument: List<suspend RateBasedRulePredicateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RateBasedRulePredicateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.predicates = mapped
    }

    /**
     * @param argument The objects to include in a rule (documented below).
     */
    @JvmName("bofppbqnlicfwevr")
    public suspend fun predicates(vararg argument: suspend RateBasedRulePredicateArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RateBasedRulePredicateArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.predicates = mapped
    }

    /**
     * @param argument The objects to include in a rule (documented below).
     */
    @JvmName("gadmjbxmxtclmlwd")
    public suspend fun predicates(argument: suspend RateBasedRulePredicateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RateBasedRulePredicateArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.predicates = mapped
    }

    /**
     * @param values The objects to include in a rule (documented below).
     */
    @JvmName("hveeqgonjjofnncf")
    public suspend fun predicates(vararg values: RateBasedRulePredicateArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.predicates = mapped
    }

    /**
     * @param value Valid value is IP.
     */
    @JvmName("adakqugnkpdwmsct")
    public suspend fun rateKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rateKey = mapped
    }

    /**
     * @param value The maximum number of requests, which have an identical value in the field specified by the RateKey, allowed in a five-minute period. Minimum value is 100.
     */
    @JvmName("oxyjfmflquwqxsoe")
    public suspend fun rateLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rateLimit = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ofyuiinxtmfagobi")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ghuxbectijrrdhuy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): RateBasedRuleArgs = RateBasedRuleArgs(
        metricName = metricName,
        name = name,
        predicates = predicates,
        rateKey = rateKey,
        rateLimit = rateLimit,
        tags = tags,
    )
}
