@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin

import com.pulumi.aws.waf.kotlin.outputs.RegexMatchSetRegexMatchTuple
import com.pulumi.aws.waf.kotlin.outputs.RegexMatchSetRegexMatchTuple.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [RegexMatchSet].
 */
@PulumiTagMarker
public class RegexMatchSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RegexMatchSetArgs = RegexMatchSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RegexMatchSetArgsBuilder.() -> Unit) {
        val builder = RegexMatchSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RegexMatchSet {
        val builtJavaResource = com.pulumi.aws.waf.RegexMatchSet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RegexMatchSet(builtJavaResource)
    }
}

/**
 * Provides a WAF Regex Match Set Resource
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleRegexPatternSet = new aws.waf.RegexPatternSet("example", {
 *     name: "example",
 *     regexPatternStrings: [
 *         "one",
 *         "two",
 *     ],
 * });
 * const example = new aws.waf.RegexMatchSet("example", {
 *     name: "example",
 *     regexMatchTuples: [{
 *         fieldToMatch: {
 *             data: "User-Agent",
 *             type: "HEADER",
 *         },
 *         regexPatternSetId: exampleRegexPatternSet.id,
 *         textTransformation: "NONE",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_regex_pattern_set = aws.waf.RegexPatternSet("example",
 *     name="example",
 *     regex_pattern_strings=[
 *         "one",
 *         "two",
 *     ])
 * example = aws.waf.RegexMatchSet("example",
 *     name="example",
 *     regex_match_tuples=[{
 *         "field_to_match": {
 *             "data": "User-Agent",
 *             "type": "HEADER",
 *         },
 *         "regex_pattern_set_id": example_regex_pattern_set.id,
 *         "text_transformation": "NONE",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleRegexPatternSet = new Aws.Waf.RegexPatternSet("example", new()
 *     {
 *         Name = "example",
 *         RegexPatternStrings = new[]
 *         {
 *             "one",
 *             "two",
 *         },
 *     });
 *     var example = new Aws.Waf.RegexMatchSet("example", new()
 *     {
 *         Name = "example",
 *         RegexMatchTuples = new[]
 *         {
 *             new Aws.Waf.Inputs.RegexMatchSetRegexMatchTupleArgs
 *             {
 *                 FieldToMatch = new Aws.Waf.Inputs.RegexMatchSetRegexMatchTupleFieldToMatchArgs
 *                 {
 *                     Data = "User-Agent",
 *                     Type = "HEADER",
 *                 },
 *                 RegexPatternSetId = exampleRegexPatternSet.Id,
 *                 TextTransformation = "NONE",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/waf"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		exampleRegexPatternSet, err := waf.NewRegexPatternSet(ctx, "example", &waf.RegexPatternSetArgs{
 * 			Name: pulumi.String("example"),
 * 			RegexPatternStrings: pulumi.StringArray{
 * 				pulumi.String("one"),
 * 				pulumi.String("two"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = waf.NewRegexMatchSet(ctx, "example", &waf.RegexMatchSetArgs{
 * 			Name: pulumi.String("example"),
 * 			RegexMatchTuples: waf.RegexMatchSetRegexMatchTupleArray{
 * 				&waf.RegexMatchSetRegexMatchTupleArgs{
 * 					FieldToMatch: &waf.RegexMatchSetRegexMatchTupleFieldToMatchArgs{
 * 						Data: pulumi.String("User-Agent"),
 * 						Type: pulumi.String("HEADER"),
 * 					},
 * 					RegexPatternSetId:  exampleRegexPatternSet.ID(),
 * 					TextTransformation: pulumi.String("NONE"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.waf.RegexPatternSet;
 * import com.pulumi.aws.waf.RegexPatternSetArgs;
 * import com.pulumi.aws.waf.RegexMatchSet;
 * import com.pulumi.aws.waf.RegexMatchSetArgs;
 * import com.pulumi.aws.waf.inputs.RegexMatchSetRegexMatchTupleArgs;
 * import com.pulumi.aws.waf.inputs.RegexMatchSetRegexMatchTupleFieldToMatchArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleRegexPatternSet = new RegexPatternSet("exampleRegexPatternSet", RegexPatternSetArgs.builder()
 *             .name("example")
 *             .regexPatternStrings(
 *                 "one",
 *                 "two")
 *             .build());
 *         var example = new RegexMatchSet("example", RegexMatchSetArgs.builder()
 *             .name("example")
 *             .regexMatchTuples(RegexMatchSetRegexMatchTupleArgs.builder()
 *                 .fieldToMatch(RegexMatchSetRegexMatchTupleFieldToMatchArgs.builder()
 *                     .data("User-Agent")
 *                     .type("HEADER")
 *                     .build())
 *                 .regexPatternSetId(exampleRegexPatternSet.id())
 *                 .textTransformation("NONE")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:waf:RegexMatchSet
 *     properties:
 *       name: example
 *       regexMatchTuples:
 *         - fieldToMatch:
 *             data: User-Agent
 *             type: HEADER
 *           regexPatternSetId: ${exampleRegexPatternSet.id}
 *           textTransformation: NONE
 *   exampleRegexPatternSet:
 *     type: aws:waf:RegexPatternSet
 *     name: example
 *     properties:
 *       name: example
 *       regexPatternStrings:
 *         - one
 *         - two
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import WAF Regex Match Set using their ID. For example:
 * ```sh
 * $ pulumi import aws:waf/regexMatchSet:RegexMatchSet example a1b2c3d4-d5f6-7777-8888-9999aaaabbbbcccc
 * ```
 */
public class RegexMatchSet internal constructor(
    override val javaResource: com.pulumi.aws.waf.RegexMatchSet,
) : KotlinCustomResource(javaResource, RegexMatchSetMapper) {
    /**
     * Amazon Resource Name (ARN)
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The name or description of the Regex Match Set.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The regular expression pattern that you want AWS WAF to search for in web requests, the location in requests that you want AWS WAF to search, and other settings. See below.
     */
    public val regexMatchTuples: Output<List<RegexMatchSetRegexMatchTuple>>?
        get() = javaResource.regexMatchTuples().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })
}

public object RegexMatchSetMapper : ResourceMapper<RegexMatchSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.waf.RegexMatchSet::class == javaResource::class

    override fun map(javaResource: Resource): RegexMatchSet = RegexMatchSet(
        javaResource as
            com.pulumi.aws.waf.RegexMatchSet,
    )
}

/**
 * @see [RegexMatchSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RegexMatchSet].
 */
public suspend fun regexMatchSet(
    name: String,
    block: suspend RegexMatchSetResourceBuilder.() -> Unit,
): RegexMatchSet {
    val builder = RegexMatchSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RegexMatchSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun regexMatchSet(name: String): RegexMatchSet {
    val builder = RegexMatchSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
