@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin

import com.pulumi.aws.waf.RuleArgs.builder
import com.pulumi.aws.waf.kotlin.inputs.RulePredicateArgs
import com.pulumi.aws.waf.kotlin.inputs.RulePredicateArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a WAF Rule Resource
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const ipset = new aws.waf.IpSet("ipset", {
 *     name: "tfIPSet",
 *     ipSetDescriptors: [{
 *         type: "IPV4",
 *         value: "192.0.7.0/24",
 *     }],
 * });
 * const wafrule = new aws.waf.Rule("wafrule", {
 *     name: "tfWAFRule",
 *     metricName: "tfWAFRule",
 *     predicates: [{
 *         dataId: ipset.id,
 *         negated: false,
 *         type: "IPMatch",
 *     }],
 * }, {
 *     dependsOn: [ipset],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * ipset = aws.waf.IpSet("ipset",
 *     name="tfIPSet",
 *     ip_set_descriptors=[{
 *         "type": "IPV4",
 *         "value": "192.0.7.0/24",
 *     }])
 * wafrule = aws.waf.Rule("wafrule",
 *     name="tfWAFRule",
 *     metric_name="tfWAFRule",
 *     predicates=[{
 *         "data_id": ipset.id,
 *         "negated": False,
 *         "type": "IPMatch",
 *     }],
 *     opts = pulumi.ResourceOptions(depends_on=[ipset]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ipset = new Aws.Waf.IpSet("ipset", new()
 *     {
 *         Name = "tfIPSet",
 *         IpSetDescriptors = new[]
 *         {
 *             new Aws.Waf.Inputs.IpSetIpSetDescriptorArgs
 *             {
 *                 Type = "IPV4",
 *                 Value = "192.0.7.0/24",
 *             },
 *         },
 *     });
 *     var wafrule = new Aws.Waf.Rule("wafrule", new()
 *     {
 *         Name = "tfWAFRule",
 *         MetricName = "tfWAFRule",
 *         Predicates = new[]
 *         {
 *             new Aws.Waf.Inputs.RulePredicateArgs
 *             {
 *                 DataId = ipset.Id,
 *                 Negated = false,
 *                 Type = "IPMatch",
 *             },
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             ipset,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/waf"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		ipset, err := waf.NewIpSet(ctx, "ipset", &waf.IpSetArgs{
 * 			Name: pulumi.String("tfIPSet"),
 * 			IpSetDescriptors: waf.IpSetIpSetDescriptorArray{
 * 				&waf.IpSetIpSetDescriptorArgs{
 * 					Type:  pulumi.String("IPV4"),
 * 					Value: pulumi.String("192.0.7.0/24"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = waf.NewRule(ctx, "wafrule", &waf.RuleArgs{
 * 			Name:       pulumi.String("tfWAFRule"),
 * 			MetricName: pulumi.String("tfWAFRule"),
 * 			Predicates: waf.RulePredicateArray{
 * 				&waf.RulePredicateArgs{
 * 					DataId:  ipset.ID(),
 * 					Negated: pulumi.Bool(false),
 * 					Type:    pulumi.String("IPMatch"),
 * 				},
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			ipset,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.waf.IpSet;
 * import com.pulumi.aws.waf.IpSetArgs;
 * import com.pulumi.aws.waf.inputs.IpSetIpSetDescriptorArgs;
 * import com.pulumi.aws.waf.Rule;
 * import com.pulumi.aws.waf.RuleArgs;
 * import com.pulumi.aws.waf.inputs.RulePredicateArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ipset = new IpSet("ipset", IpSetArgs.builder()
 *             .name("tfIPSet")
 *             .ipSetDescriptors(IpSetIpSetDescriptorArgs.builder()
 *                 .type("IPV4")
 *                 .value("192.0.7.0/24")
 *                 .build())
 *             .build());
 *         var wafrule = new Rule("wafrule", RuleArgs.builder()
 *             .name("tfWAFRule")
 *             .metricName("tfWAFRule")
 *             .predicates(RulePredicateArgs.builder()
 *                 .dataId(ipset.id())
 *                 .negated(false)
 *                 .type("IPMatch")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(ipset)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   ipset:
 *     type: aws:waf:IpSet
 *     properties:
 *       name: tfIPSet
 *       ipSetDescriptors:
 *         - type: IPV4
 *           value: 192.0.7.0/24
 *   wafrule:
 *     type: aws:waf:Rule
 *     properties:
 *       name: tfWAFRule
 *       metricName: tfWAFRule
 *       predicates:
 *         - dataId: ${ipset.id}
 *           negated: false
 *           type: IPMatch
 *     options:
 *       dependson:
 *         - ${ipset}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import WAF rules using the id. For example:
 * ```sh
 * $ pulumi import aws:waf/rule:Rule example a1b2c3d4-d5f6-7777-8888-9999aaaabbbbcccc
 * ```
 * @property metricName The name or description for the Amazon CloudWatch metric of this rule. The name can contain only alphanumeric characters (A-Z, a-z, 0-9); the name can't contain whitespace.
 * @property name The name or description of the rule.
 * @property predicates The objects to include in a rule (documented below).
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class RuleArgs(
    public val metricName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val predicates: Output<List<RulePredicateArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.waf.RuleArgs> {
    override fun toJava(): com.pulumi.aws.waf.RuleArgs = com.pulumi.aws.waf.RuleArgs.builder()
        .metricName(metricName?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .predicates(
            predicates?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [RuleArgs].
 */
@PulumiTagMarker
public class RuleArgsBuilder internal constructor() {
    private var metricName: Output<String>? = null

    private var name: Output<String>? = null

    private var predicates: Output<List<RulePredicateArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name or description for the Amazon CloudWatch metric of this rule. The name can contain only alphanumeric characters (A-Z, a-z, 0-9); the name can't contain whitespace.
     */
    @JvmName("dwmnmiibtwndtvox")
    public suspend fun metricName(`value`: Output<String>) {
        this.metricName = value
    }

    /**
     * @param value The name or description of the rule.
     */
    @JvmName("sslkvfyeemawimpy")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The objects to include in a rule (documented below).
     */
    @JvmName("mdqnhyiesdmkkepp")
    public suspend fun predicates(`value`: Output<List<RulePredicateArgs>>) {
        this.predicates = value
    }

    @JvmName("sigarukteabpfnqy")
    public suspend fun predicates(vararg values: Output<RulePredicateArgs>) {
        this.predicates = Output.all(values.asList())
    }

    /**
     * @param values The objects to include in a rule (documented below).
     */
    @JvmName("fmwaiynewfqukkfs")
    public suspend fun predicates(values: List<Output<RulePredicateArgs>>) {
        this.predicates = Output.all(values)
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dvjvrqdeequpkrtm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name or description for the Amazon CloudWatch metric of this rule. The name can contain only alphanumeric characters (A-Z, a-z, 0-9); the name can't contain whitespace.
     */
    @JvmName("ymbowcqdfduxrbpb")
    public suspend fun metricName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricName = mapped
    }

    /**
     * @param value The name or description of the rule.
     */
    @JvmName("vqruqecwehjgtoku")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The objects to include in a rule (documented below).
     */
    @JvmName("tvawfjvxgblxcrbg")
    public suspend fun predicates(`value`: List<RulePredicateArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.predicates = mapped
    }

    /**
     * @param argument The objects to include in a rule (documented below).
     */
    @JvmName("gghdjyisrwkequtq")
    public suspend fun predicates(argument: List<suspend RulePredicateArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RulePredicateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.predicates = mapped
    }

    /**
     * @param argument The objects to include in a rule (documented below).
     */
    @JvmName("ilkqscupibxcrjgk")
    public suspend fun predicates(vararg argument: suspend RulePredicateArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RulePredicateArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.predicates = mapped
    }

    /**
     * @param argument The objects to include in a rule (documented below).
     */
    @JvmName("rosasihotbvclmuw")
    public suspend fun predicates(argument: suspend RulePredicateArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RulePredicateArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.predicates = mapped
    }

    /**
     * @param values The objects to include in a rule (documented below).
     */
    @JvmName("dnsuspofkytsrfgo")
    public suspend fun predicates(vararg values: RulePredicateArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.predicates = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wvmipfcwaruaajit")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tttmfmkcnmgoekus")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): RuleArgs = RuleArgs(
        metricName = metricName,
        name = name,
        predicates = predicates,
        tags = tags,
    )
}
