@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin

import com.pulumi.aws.waf.kotlin.outputs.RuleGroupActivatedRule
import com.pulumi.aws.waf.kotlin.outputs.RuleGroupActivatedRule.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [RuleGroup].
 */
@PulumiTagMarker
public class RuleGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RuleGroupArgs = RuleGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RuleGroupArgsBuilder.() -> Unit) {
        val builder = RuleGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RuleGroup {
        val builtJavaResource = com.pulumi.aws.waf.RuleGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RuleGroup(builtJavaResource)
    }
}

/**
 * Provides a WAF Rule Group Resource
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.waf.Rule("example", {
 *     name: "example",
 *     metricName: "example",
 * });
 * const exampleRuleGroup = new aws.waf.RuleGroup("example", {
 *     name: "example",
 *     metricName: "example",
 *     activatedRules: [{
 *         action: {
 *             type: "COUNT",
 *         },
 *         priority: 50,
 *         ruleId: example.id,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.waf.Rule("example",
 *     name="example",
 *     metric_name="example")
 * example_rule_group = aws.waf.RuleGroup("example",
 *     name="example",
 *     metric_name="example",
 *     activated_rules=[{
 *         "action": {
 *             "type": "COUNT",
 *         },
 *         "priority": 50,
 *         "rule_id": example.id,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Waf.Rule("example", new()
 *     {
 *         Name = "example",
 *         MetricName = "example",
 *     });
 *     var exampleRuleGroup = new Aws.Waf.RuleGroup("example", new()
 *     {
 *         Name = "example",
 *         MetricName = "example",
 *         ActivatedRules = new[]
 *         {
 *             new Aws.Waf.Inputs.RuleGroupActivatedRuleArgs
 *             {
 *                 Action = new Aws.Waf.Inputs.RuleGroupActivatedRuleActionArgs
 *                 {
 *                     Type = "COUNT",
 *                 },
 *                 Priority = 50,
 *                 RuleId = example.Id,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/waf"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := waf.NewRule(ctx, "example", &waf.RuleArgs{
 * 			Name:       pulumi.String("example"),
 * 			MetricName: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = waf.NewRuleGroup(ctx, "example", &waf.RuleGroupArgs{
 * 			Name:       pulumi.String("example"),
 * 			MetricName: pulumi.String("example"),
 * 			ActivatedRules: waf.RuleGroupActivatedRuleArray{
 * 				&waf.RuleGroupActivatedRuleArgs{
 * 					Action: &waf.RuleGroupActivatedRuleActionArgs{
 * 						Type: pulumi.String("COUNT"),
 * 					},
 * 					Priority: pulumi.Int(50),
 * 					RuleId:   example.ID(),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.waf.Rule;
 * import com.pulumi.aws.waf.RuleArgs;
 * import com.pulumi.aws.waf.RuleGroup;
 * import com.pulumi.aws.waf.RuleGroupArgs;
 * import com.pulumi.aws.waf.inputs.RuleGroupActivatedRuleArgs;
 * import com.pulumi.aws.waf.inputs.RuleGroupActivatedRuleActionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Rule("example", RuleArgs.builder()
 *             .name("example")
 *             .metricName("example")
 *             .build());
 *         var exampleRuleGroup = new RuleGroup("exampleRuleGroup", RuleGroupArgs.builder()
 *             .name("example")
 *             .metricName("example")
 *             .activatedRules(RuleGroupActivatedRuleArgs.builder()
 *                 .action(RuleGroupActivatedRuleActionArgs.builder()
 *                     .type("COUNT")
 *                     .build())
 *                 .priority(50)
 *                 .ruleId(example.id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:waf:Rule
 *     properties:
 *       name: example
 *       metricName: example
 *   exampleRuleGroup:
 *     type: aws:waf:RuleGroup
 *     name: example
 *     properties:
 *       name: example
 *       metricName: example
 *       activatedRules:
 *         - action:
 *             type: COUNT
 *           priority: 50
 *           ruleId: ${example.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import WAF Rule Group using the id. For example:
 * ```sh
 * $ pulumi import aws:waf/ruleGroup:RuleGroup example a1b2c3d4-d5f6-7777-8888-9999aaaabbbbcccc
 * ```
 */
public class RuleGroup internal constructor(
    override val javaResource: com.pulumi.aws.waf.RuleGroup,
) : KotlinCustomResource(javaResource, RuleGroupMapper) {
    /**
     * A list of activated rules, see below
     */
    public val activatedRules: Output<List<RuleGroupActivatedRule>>?
        get() = javaResource.activatedRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * The ARN of the WAF rule group.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A friendly name for the metrics from the rule group
     */
    public val metricName: Output<String>
        get() = javaResource.metricName().applyValue({ args0 -> args0 })

    /**
     * Name of the rule group. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object RuleGroupMapper : ResourceMapper<RuleGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.waf.RuleGroup::class == javaResource::class

    override fun map(javaResource: Resource): RuleGroup = RuleGroup(
        javaResource as
            com.pulumi.aws.waf.RuleGroup,
    )
}

/**
 * @see [RuleGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RuleGroup].
 */
public suspend fun ruleGroup(name: String, block: suspend RuleGroupResourceBuilder.() -> Unit): RuleGroup {
    val builder = RuleGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RuleGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ruleGroup(name: String): RuleGroup {
    val builder = RuleGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
