@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin

import com.pulumi.aws.waf.RuleGroupArgs.builder
import com.pulumi.aws.waf.kotlin.inputs.RuleGroupActivatedRuleArgs
import com.pulumi.aws.waf.kotlin.inputs.RuleGroupActivatedRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a WAF Rule Group Resource
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.waf.Rule("example", {
 *     name: "example",
 *     metricName: "example",
 * });
 * const exampleRuleGroup = new aws.waf.RuleGroup("example", {
 *     name: "example",
 *     metricName: "example",
 *     activatedRules: [{
 *         action: {
 *             type: "COUNT",
 *         },
 *         priority: 50,
 *         ruleId: example.id,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.waf.Rule("example",
 *     name="example",
 *     metric_name="example")
 * example_rule_group = aws.waf.RuleGroup("example",
 *     name="example",
 *     metric_name="example",
 *     activated_rules=[{
 *         "action": {
 *             "type": "COUNT",
 *         },
 *         "priority": 50,
 *         "rule_id": example.id,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Waf.Rule("example", new()
 *     {
 *         Name = "example",
 *         MetricName = "example",
 *     });
 *     var exampleRuleGroup = new Aws.Waf.RuleGroup("example", new()
 *     {
 *         Name = "example",
 *         MetricName = "example",
 *         ActivatedRules = new[]
 *         {
 *             new Aws.Waf.Inputs.RuleGroupActivatedRuleArgs
 *             {
 *                 Action = new Aws.Waf.Inputs.RuleGroupActivatedRuleActionArgs
 *                 {
 *                     Type = "COUNT",
 *                 },
 *                 Priority = 50,
 *                 RuleId = example.Id,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/waf"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := waf.NewRule(ctx, "example", &waf.RuleArgs{
 * 			Name:       pulumi.String("example"),
 * 			MetricName: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = waf.NewRuleGroup(ctx, "example", &waf.RuleGroupArgs{
 * 			Name:       pulumi.String("example"),
 * 			MetricName: pulumi.String("example"),
 * 			ActivatedRules: waf.RuleGroupActivatedRuleArray{
 * 				&waf.RuleGroupActivatedRuleArgs{
 * 					Action: &waf.RuleGroupActivatedRuleActionArgs{
 * 						Type: pulumi.String("COUNT"),
 * 					},
 * 					Priority: pulumi.Int(50),
 * 					RuleId:   example.ID(),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.waf.Rule;
 * import com.pulumi.aws.waf.RuleArgs;
 * import com.pulumi.aws.waf.RuleGroup;
 * import com.pulumi.aws.waf.RuleGroupArgs;
 * import com.pulumi.aws.waf.inputs.RuleGroupActivatedRuleArgs;
 * import com.pulumi.aws.waf.inputs.RuleGroupActivatedRuleActionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Rule("example", RuleArgs.builder()
 *             .name("example")
 *             .metricName("example")
 *             .build());
 *         var exampleRuleGroup = new RuleGroup("exampleRuleGroup", RuleGroupArgs.builder()
 *             .name("example")
 *             .metricName("example")
 *             .activatedRules(RuleGroupActivatedRuleArgs.builder()
 *                 .action(RuleGroupActivatedRuleActionArgs.builder()
 *                     .type("COUNT")
 *                     .build())
 *                 .priority(50)
 *                 .ruleId(example.id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:waf:Rule
 *     properties:
 *       name: example
 *       metricName: example
 *   exampleRuleGroup:
 *     type: aws:waf:RuleGroup
 *     name: example
 *     properties:
 *       name: example
 *       metricName: example
 *       activatedRules:
 *         - action:
 *             type: COUNT
 *           priority: 50
 *           ruleId: ${example.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import WAF Rule Group using the id. For example:
 * ```sh
 * $ pulumi import aws:waf/ruleGroup:RuleGroup example a1b2c3d4-d5f6-7777-8888-9999aaaabbbbcccc
 * ```
 * @property activatedRules A list of activated rules, see below
 * @property metricName A friendly name for the metrics from the rule group
 * @property name Name of the rule group. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class RuleGroupArgs(
    public val activatedRules: Output<List<RuleGroupActivatedRuleArgs>>? = null,
    public val metricName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.waf.RuleGroupArgs> {
    override fun toJava(): com.pulumi.aws.waf.RuleGroupArgs =
        com.pulumi.aws.waf.RuleGroupArgs.builder()
            .activatedRules(
                activatedRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .metricName(metricName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [RuleGroupArgs].
 */
@PulumiTagMarker
public class RuleGroupArgsBuilder internal constructor() {
    private var activatedRules: Output<List<RuleGroupActivatedRuleArgs>>? = null

    private var metricName: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A list of activated rules, see below
     */
    @JvmName("bnutasrinfbuscom")
    public suspend fun activatedRules(`value`: Output<List<RuleGroupActivatedRuleArgs>>) {
        this.activatedRules = value
    }

    @JvmName("cartrjwnxowfvjrp")
    public suspend fun activatedRules(vararg values: Output<RuleGroupActivatedRuleArgs>) {
        this.activatedRules = Output.all(values.asList())
    }

    /**
     * @param values A list of activated rules, see below
     */
    @JvmName("wmgxrqvlpnnbpdva")
    public suspend fun activatedRules(values: List<Output<RuleGroupActivatedRuleArgs>>) {
        this.activatedRules = Output.all(values)
    }

    /**
     * @param value A friendly name for the metrics from the rule group
     */
    @JvmName("siwoybvulphnhift")
    public suspend fun metricName(`value`: Output<String>) {
        this.metricName = value
    }

    /**
     * @param value Name of the rule group. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("wyjfsiojwkjrbmuu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ossbeddsdxwtnuiw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A list of activated rules, see below
     */
    @JvmName("ofiuibsopeymhebn")
    public suspend fun activatedRules(`value`: List<RuleGroupActivatedRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.activatedRules = mapped
    }

    /**
     * @param argument A list of activated rules, see below
     */
    @JvmName("sljxapwngkmnxwlr")
    public suspend fun activatedRules(argument: List<suspend RuleGroupActivatedRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuleGroupActivatedRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.activatedRules = mapped
    }

    /**
     * @param argument A list of activated rules, see below
     */
    @JvmName("btoqfufgjlyoenxe")
    public suspend fun activatedRules(vararg argument: suspend RuleGroupActivatedRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RuleGroupActivatedRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.activatedRules = mapped
    }

    /**
     * @param argument A list of activated rules, see below
     */
    @JvmName("fubioidleoyoxyql")
    public suspend fun activatedRules(argument: suspend RuleGroupActivatedRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RuleGroupActivatedRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.activatedRules = mapped
    }

    /**
     * @param values A list of activated rules, see below
     */
    @JvmName("ukembnyushjaoumu")
    public suspend fun activatedRules(vararg values: RuleGroupActivatedRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.activatedRules = mapped
    }

    /**
     * @param value A friendly name for the metrics from the rule group
     */
    @JvmName("dkdiateluxqqckfo")
    public suspend fun metricName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricName = mapped
    }

    /**
     * @param value Name of the rule group. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("suoyrlhhtuluonng")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("blmvqnupamfpwhmp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("btrirfqmswnvwpeg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): RuleGroupArgs = RuleGroupArgs(
        activatedRules = activatedRules,
        metricName = metricName,
        name = name,
        tags = tags,
    )
}
