@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin

import com.pulumi.aws.waf.kotlin.outputs.SizeConstraintSetSizeConstraint
import com.pulumi.aws.waf.kotlin.outputs.SizeConstraintSetSizeConstraint.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [SizeConstraintSet].
 */
@PulumiTagMarker
public class SizeConstraintSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SizeConstraintSetArgs = SizeConstraintSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SizeConstraintSetArgsBuilder.() -> Unit) {
        val builder = SizeConstraintSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SizeConstraintSet {
        val builtJavaResource = com.pulumi.aws.waf.SizeConstraintSet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SizeConstraintSet(builtJavaResource)
    }
}

/**
 * Use the `aws.waf.SizeConstraintSet` resource to manage WAF size constraint sets.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const sizeConstraintSet = new aws.waf.SizeConstraintSet("size_constraint_set", {
 *     name: "tfsize_constraints",
 *     sizeConstraints: [{
 *         textTransformation: "NONE",
 *         comparisonOperator: "EQ",
 *         size: 4096,
 *         fieldToMatch: {
 *             type: "BODY",
 *         },
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * size_constraint_set = aws.waf.SizeConstraintSet("size_constraint_set",
 *     name="tfsize_constraints",
 *     size_constraints=[{
 *         "text_transformation": "NONE",
 *         "comparison_operator": "EQ",
 *         "size": 4096,
 *         "field_to_match": {
 *             "type": "BODY",
 *         },
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sizeConstraintSet = new Aws.Waf.SizeConstraintSet("size_constraint_set", new()
 *     {
 *         Name = "tfsize_constraints",
 *         SizeConstraints = new[]
 *         {
 *             new Aws.Waf.Inputs.SizeConstraintSetSizeConstraintArgs
 *             {
 *                 TextTransformation = "NONE",
 *                 ComparisonOperator = "EQ",
 *                 Size = 4096,
 *                 FieldToMatch = new Aws.Waf.Inputs.SizeConstraintSetSizeConstraintFieldToMatchArgs
 *                 {
 *                     Type = "BODY",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/waf"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := waf.NewSizeConstraintSet(ctx, "size_constraint_set", &waf.SizeConstraintSetArgs{
 * 			Name: pulumi.String("tfsize_constraints"),
 * 			SizeConstraints: waf.SizeConstraintSetSizeConstraintArray{
 * 				&waf.SizeConstraintSetSizeConstraintArgs{
 * 					TextTransformation: pulumi.String("NONE"),
 * 					ComparisonOperator: pulumi.String("EQ"),
 * 					Size:               pulumi.Int(4096),
 * 					FieldToMatch: &waf.SizeConstraintSetSizeConstraintFieldToMatchArgs{
 * 						Type: pulumi.String("BODY"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.waf.SizeConstraintSet;
 * import com.pulumi.aws.waf.SizeConstraintSetArgs;
 * import com.pulumi.aws.waf.inputs.SizeConstraintSetSizeConstraintArgs;
 * import com.pulumi.aws.waf.inputs.SizeConstraintSetSizeConstraintFieldToMatchArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sizeConstraintSet = new SizeConstraintSet("sizeConstraintSet", SizeConstraintSetArgs.builder()
 *             .name("tfsize_constraints")
 *             .sizeConstraints(SizeConstraintSetSizeConstraintArgs.builder()
 *                 .textTransformation("NONE")
 *                 .comparisonOperator("EQ")
 *                 .size("4096")
 *                 .fieldToMatch(SizeConstraintSetSizeConstraintFieldToMatchArgs.builder()
 *                     .type("BODY")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   sizeConstraintSet:
 *     type: aws:waf:SizeConstraintSet
 *     name: size_constraint_set
 *     properties:
 *       name: tfsize_constraints
 *       sizeConstraints:
 *         - textTransformation: NONE
 *           comparisonOperator: EQ
 *           size: '4096'
 *           fieldToMatch:
 *             type: BODY
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AWS WAF Size Constraint Set using their ID. For example:
 * ```sh
 * $ pulumi import aws:waf/sizeConstraintSet:SizeConstraintSet example a1b2c3d4-d5f6-7777-8888-9999aaaabbbbcccc
 * ```
 */
public class SizeConstraintSet internal constructor(
    override val javaResource: com.pulumi.aws.waf.SizeConstraintSet,
) : KotlinCustomResource(javaResource, SizeConstraintSetMapper) {
    /**
     * Amazon Resource Name (ARN).
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Name or description of the Size Constraint Set.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Parts of web requests that you want to inspect the size of.
     */
    public val sizeConstraints: Output<List<SizeConstraintSetSizeConstraint>>?
        get() = javaResource.sizeConstraints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })
}

public object SizeConstraintSetMapper : ResourceMapper<SizeConstraintSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.waf.SizeConstraintSet::class == javaResource::class

    override fun map(javaResource: Resource): SizeConstraintSet = SizeConstraintSet(
        javaResource as
            com.pulumi.aws.waf.SizeConstraintSet,
    )
}

/**
 * @see [SizeConstraintSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SizeConstraintSet].
 */
public suspend fun sizeConstraintSet(
    name: String,
    block: suspend SizeConstraintSetResourceBuilder.() -> Unit,
): SizeConstraintSet {
    val builder = SizeConstraintSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SizeConstraintSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sizeConstraintSet(name: String): SizeConstraintSet {
    val builder = SizeConstraintSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
