@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin

import com.pulumi.aws.waf.SizeConstraintSetArgs.builder
import com.pulumi.aws.waf.kotlin.inputs.SizeConstraintSetSizeConstraintArgs
import com.pulumi.aws.waf.kotlin.inputs.SizeConstraintSetSizeConstraintArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Use the `aws.waf.SizeConstraintSet` resource to manage WAF size constraint sets.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const sizeConstraintSet = new aws.waf.SizeConstraintSet("size_constraint_set", {
 *     name: "tfsize_constraints",
 *     sizeConstraints: [{
 *         textTransformation: "NONE",
 *         comparisonOperator: "EQ",
 *         size: 4096,
 *         fieldToMatch: {
 *             type: "BODY",
 *         },
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * size_constraint_set = aws.waf.SizeConstraintSet("size_constraint_set",
 *     name="tfsize_constraints",
 *     size_constraints=[{
 *         "text_transformation": "NONE",
 *         "comparison_operator": "EQ",
 *         "size": 4096,
 *         "field_to_match": {
 *             "type": "BODY",
 *         },
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sizeConstraintSet = new Aws.Waf.SizeConstraintSet("size_constraint_set", new()
 *     {
 *         Name = "tfsize_constraints",
 *         SizeConstraints = new[]
 *         {
 *             new Aws.Waf.Inputs.SizeConstraintSetSizeConstraintArgs
 *             {
 *                 TextTransformation = "NONE",
 *                 ComparisonOperator = "EQ",
 *                 Size = 4096,
 *                 FieldToMatch = new Aws.Waf.Inputs.SizeConstraintSetSizeConstraintFieldToMatchArgs
 *                 {
 *                     Type = "BODY",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/waf"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := waf.NewSizeConstraintSet(ctx, "size_constraint_set", &waf.SizeConstraintSetArgs{
 * 			Name: pulumi.String("tfsize_constraints"),
 * 			SizeConstraints: waf.SizeConstraintSetSizeConstraintArray{
 * 				&waf.SizeConstraintSetSizeConstraintArgs{
 * 					TextTransformation: pulumi.String("NONE"),
 * 					ComparisonOperator: pulumi.String("EQ"),
 * 					Size:               pulumi.Int(4096),
 * 					FieldToMatch: &waf.SizeConstraintSetSizeConstraintFieldToMatchArgs{
 * 						Type: pulumi.String("BODY"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.waf.SizeConstraintSet;
 * import com.pulumi.aws.waf.SizeConstraintSetArgs;
 * import com.pulumi.aws.waf.inputs.SizeConstraintSetSizeConstraintArgs;
 * import com.pulumi.aws.waf.inputs.SizeConstraintSetSizeConstraintFieldToMatchArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sizeConstraintSet = new SizeConstraintSet("sizeConstraintSet", SizeConstraintSetArgs.builder()
 *             .name("tfsize_constraints")
 *             .sizeConstraints(SizeConstraintSetSizeConstraintArgs.builder()
 *                 .textTransformation("NONE")
 *                 .comparisonOperator("EQ")
 *                 .size("4096")
 *                 .fieldToMatch(SizeConstraintSetSizeConstraintFieldToMatchArgs.builder()
 *                     .type("BODY")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   sizeConstraintSet:
 *     type: aws:waf:SizeConstraintSet
 *     name: size_constraint_set
 *     properties:
 *       name: tfsize_constraints
 *       sizeConstraints:
 *         - textTransformation: NONE
 *           comparisonOperator: EQ
 *           size: '4096'
 *           fieldToMatch:
 *             type: BODY
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AWS WAF Size Constraint Set using their ID. For example:
 * ```sh
 * $ pulumi import aws:waf/sizeConstraintSet:SizeConstraintSet example a1b2c3d4-d5f6-7777-8888-9999aaaabbbbcccc
 * ```
 * @property name Name or description of the Size Constraint Set.
 * @property sizeConstraints Parts of web requests that you want to inspect the size of.
 */
public data class SizeConstraintSetArgs(
    public val name: Output<String>? = null,
    public val sizeConstraints: Output<List<SizeConstraintSetSizeConstraintArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.waf.SizeConstraintSetArgs> {
    override fun toJava(): com.pulumi.aws.waf.SizeConstraintSetArgs =
        com.pulumi.aws.waf.SizeConstraintSetArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .sizeConstraints(
                sizeConstraints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SizeConstraintSetArgs].
 */
@PulumiTagMarker
public class SizeConstraintSetArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var sizeConstraints: Output<List<SizeConstraintSetSizeConstraintArgs>>? = null

    /**
     * @param value Name or description of the Size Constraint Set.
     */
    @JvmName("xteflixgvdubosfq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Parts of web requests that you want to inspect the size of.
     */
    @JvmName("jpmmcgtvsbyctrkj")
    public suspend fun sizeConstraints(`value`: Output<List<SizeConstraintSetSizeConstraintArgs>>) {
        this.sizeConstraints = value
    }

    @JvmName("utdhipbkucilaaem")
    public suspend fun sizeConstraints(vararg values: Output<SizeConstraintSetSizeConstraintArgs>) {
        this.sizeConstraints = Output.all(values.asList())
    }

    /**
     * @param values Parts of web requests that you want to inspect the size of.
     */
    @JvmName("cgjeqrhnimhvbbvs")
    public suspend fun sizeConstraints(values: List<Output<SizeConstraintSetSizeConstraintArgs>>) {
        this.sizeConstraints = Output.all(values)
    }

    /**
     * @param value Name or description of the Size Constraint Set.
     */
    @JvmName("bpqjmdqtwklmgwbf")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Parts of web requests that you want to inspect the size of.
     */
    @JvmName("voauxecjfeikygif")
    public suspend fun sizeConstraints(`value`: List<SizeConstraintSetSizeConstraintArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sizeConstraints = mapped
    }

    /**
     * @param argument Parts of web requests that you want to inspect the size of.
     */
    @JvmName("bdnaiqsyikeomjjg")
    public suspend fun sizeConstraints(argument: List<suspend SizeConstraintSetSizeConstraintArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SizeConstraintSetSizeConstraintArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sizeConstraints = mapped
    }

    /**
     * @param argument Parts of web requests that you want to inspect the size of.
     */
    @JvmName("ausmggngtttgbara")
    public suspend fun sizeConstraints(vararg argument: suspend SizeConstraintSetSizeConstraintArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SizeConstraintSetSizeConstraintArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sizeConstraints = mapped
    }

    /**
     * @param argument Parts of web requests that you want to inspect the size of.
     */
    @JvmName("wupcekdckousuvpp")
    public suspend fun sizeConstraints(argument: suspend SizeConstraintSetSizeConstraintArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SizeConstraintSetSizeConstraintArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.sizeConstraints = mapped
    }

    /**
     * @param values Parts of web requests that you want to inspect the size of.
     */
    @JvmName("gmdvpdelosyhktes")
    public suspend fun sizeConstraints(vararg values: SizeConstraintSetSizeConstraintArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sizeConstraints = mapped
    }

    internal fun build(): SizeConstraintSetArgs = SizeConstraintSetArgs(
        name = name,
        sizeConstraints = sizeConstraints,
    )
}
