@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin

import com.pulumi.aws.waf.kotlin.outputs.SqlInjectionMatchSetSqlInjectionMatchTuple
import com.pulumi.aws.waf.kotlin.outputs.SqlInjectionMatchSetSqlInjectionMatchTuple.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [SqlInjectionMatchSet].
 */
@PulumiTagMarker
public class SqlInjectionMatchSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SqlInjectionMatchSetArgs = SqlInjectionMatchSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SqlInjectionMatchSetArgsBuilder.() -> Unit) {
        val builder = SqlInjectionMatchSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SqlInjectionMatchSet {
        val builtJavaResource = com.pulumi.aws.waf.SqlInjectionMatchSet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SqlInjectionMatchSet(builtJavaResource)
    }
}

/**
 * Provides a WAF SQL Injection Match Set Resource
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const sqlInjectionMatchSet = new aws.waf.SqlInjectionMatchSet("sql_injection_match_set", {
 *     name: "tf-sql_injection_match_set",
 *     sqlInjectionMatchTuples: [{
 *         textTransformation: "URL_DECODE",
 *         fieldToMatch: {
 *             type: "QUERY_STRING",
 *         },
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * sql_injection_match_set = aws.waf.SqlInjectionMatchSet("sql_injection_match_set",
 *     name="tf-sql_injection_match_set",
 *     sql_injection_match_tuples=[{
 *         "text_transformation": "URL_DECODE",
 *         "field_to_match": {
 *             "type": "QUERY_STRING",
 *         },
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlInjectionMatchSet = new Aws.Waf.SqlInjectionMatchSet("sql_injection_match_set", new()
 *     {
 *         Name = "tf-sql_injection_match_set",
 *         SqlInjectionMatchTuples = new[]
 *         {
 *             new Aws.Waf.Inputs.SqlInjectionMatchSetSqlInjectionMatchTupleArgs
 *             {
 *                 TextTransformation = "URL_DECODE",
 *                 FieldToMatch = new Aws.Waf.Inputs.SqlInjectionMatchSetSqlInjectionMatchTupleFieldToMatchArgs
 *                 {
 *                     Type = "QUERY_STRING",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/waf"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := waf.NewSqlInjectionMatchSet(ctx, "sql_injection_match_set", &waf.SqlInjectionMatchSetArgs{
 * 			Name: pulumi.String("tf-sql_injection_match_set"),
 * 			SqlInjectionMatchTuples: waf.SqlInjectionMatchSetSqlInjectionMatchTupleArray{
 * 				&waf.SqlInjectionMatchSetSqlInjectionMatchTupleArgs{
 * 					TextTransformation: pulumi.String("URL_DECODE"),
 * 					FieldToMatch: &waf.SqlInjectionMatchSetSqlInjectionMatchTupleFieldToMatchArgs{
 * 						Type: pulumi.String("QUERY_STRING"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.waf.SqlInjectionMatchSet;
 * import com.pulumi.aws.waf.SqlInjectionMatchSetArgs;
 * import com.pulumi.aws.waf.inputs.SqlInjectionMatchSetSqlInjectionMatchTupleArgs;
 * import com.pulumi.aws.waf.inputs.SqlInjectionMatchSetSqlInjectionMatchTupleFieldToMatchArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlInjectionMatchSet = new SqlInjectionMatchSet("sqlInjectionMatchSet", SqlInjectionMatchSetArgs.builder()
 *             .name("tf-sql_injection_match_set")
 *             .sqlInjectionMatchTuples(SqlInjectionMatchSetSqlInjectionMatchTupleArgs.builder()
 *                 .textTransformation("URL_DECODE")
 *                 .fieldToMatch(SqlInjectionMatchSetSqlInjectionMatchTupleFieldToMatchArgs.builder()
 *                     .type("QUERY_STRING")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   sqlInjectionMatchSet:
 *     type: aws:waf:SqlInjectionMatchSet
 *     name: sql_injection_match_set
 *     properties:
 *       name: tf-sql_injection_match_set
 *       sqlInjectionMatchTuples:
 *         - textTransformation: URL_DECODE
 *           fieldToMatch:
 *             type: QUERY_STRING
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AWS WAF SQL Injection Match Set using their ID. For example:
 * ```sh
 * $ pulumi import aws:waf/sqlInjectionMatchSet:SqlInjectionMatchSet example a1b2c3d4-d5f6-7777-8888-9999aaaabbbbcccc
 * ```
 */
public class SqlInjectionMatchSet internal constructor(
    override val javaResource: com.pulumi.aws.waf.SqlInjectionMatchSet,
) : KotlinCustomResource(javaResource, SqlInjectionMatchSetMapper) {
    /**
     * The name or description of the SQL Injection Match Set.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The parts of web requests that you want AWS WAF to inspect for malicious SQL code and, if you want AWS WAF to inspect a header, the name of the header.
     */
    public val sqlInjectionMatchTuples: Output<List<SqlInjectionMatchSetSqlInjectionMatchTuple>>?
        get() = javaResource.sqlInjectionMatchTuples().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })
}

public object SqlInjectionMatchSetMapper : ResourceMapper<SqlInjectionMatchSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.waf.SqlInjectionMatchSet::class == javaResource::class

    override fun map(javaResource: Resource): SqlInjectionMatchSet = SqlInjectionMatchSet(
        javaResource
            as com.pulumi.aws.waf.SqlInjectionMatchSet,
    )
}

/**
 * @see [SqlInjectionMatchSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SqlInjectionMatchSet].
 */
public suspend fun sqlInjectionMatchSet(
    name: String,
    block: suspend SqlInjectionMatchSetResourceBuilder.() -> Unit,
): SqlInjectionMatchSet {
    val builder = SqlInjectionMatchSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SqlInjectionMatchSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sqlInjectionMatchSet(name: String): SqlInjectionMatchSet {
    val builder = SqlInjectionMatchSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
