@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin

import com.pulumi.aws.waf.WebAclArgs.builder
import com.pulumi.aws.waf.kotlin.inputs.WebAclDefaultActionArgs
import com.pulumi.aws.waf.kotlin.inputs.WebAclDefaultActionArgsBuilder
import com.pulumi.aws.waf.kotlin.inputs.WebAclLoggingConfigurationArgs
import com.pulumi.aws.waf.kotlin.inputs.WebAclLoggingConfigurationArgsBuilder
import com.pulumi.aws.waf.kotlin.inputs.WebAclRuleArgs
import com.pulumi.aws.waf.kotlin.inputs.WebAclRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a WAF Web ACL Resource
 * ## Example Usage
 * This example blocks requests coming from `192.0.7.0/24` and allows everything else.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const ipset = new aws.waf.IpSet("ipset", {
 *     name: "tfIPSet",
 *     ipSetDescriptors: [{
 *         type: "IPV4",
 *         value: "192.0.7.0/24",
 *     }],
 * });
 * const wafrule = new aws.waf.Rule("wafrule", {
 *     name: "tfWAFRule",
 *     metricName: "tfWAFRule",
 *     predicates: [{
 *         dataId: ipset.id,
 *         negated: false,
 *         type: "IPMatch",
 *     }],
 * }, {
 *     dependsOn: [ipset],
 * });
 * const wafAcl = new aws.waf.WebAcl("waf_acl", {
 *     name: "tfWebACL",
 *     metricName: "tfWebACL",
 *     defaultAction: {
 *         type: "ALLOW",
 *     },
 *     rules: [{
 *         action: {
 *             type: "BLOCK",
 *         },
 *         priority: 1,
 *         ruleId: wafrule.id,
 *         type: "REGULAR",
 *     }],
 * }, {
 *     dependsOn: [
 *         ipset,
 *         wafrule,
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * ipset = aws.waf.IpSet("ipset",
 *     name="tfIPSet",
 *     ip_set_descriptors=[{
 *         "type": "IPV4",
 *         "value": "192.0.7.0/24",
 *     }])
 * wafrule = aws.waf.Rule("wafrule",
 *     name="tfWAFRule",
 *     metric_name="tfWAFRule",
 *     predicates=[{
 *         "data_id": ipset.id,
 *         "negated": False,
 *         "type": "IPMatch",
 *     }],
 *     opts = pulumi.ResourceOptions(depends_on=[ipset]))
 * waf_acl = aws.waf.WebAcl("waf_acl",
 *     name="tfWebACL",
 *     metric_name="tfWebACL",
 *     default_action={
 *         "type": "ALLOW",
 *     },
 *     rules=[{
 *         "action": {
 *             "type": "BLOCK",
 *         },
 *         "priority": 1,
 *         "rule_id": wafrule.id,
 *         "type": "REGULAR",
 *     }],
 *     opts = pulumi.ResourceOptions(depends_on=[
 *             ipset,
 *             wafrule,
 *         ]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ipset = new Aws.Waf.IpSet("ipset", new()
 *     {
 *         Name = "tfIPSet",
 *         IpSetDescriptors = new[]
 *         {
 *             new Aws.Waf.Inputs.IpSetIpSetDescriptorArgs
 *             {
 *                 Type = "IPV4",
 *                 Value = "192.0.7.0/24",
 *             },
 *         },
 *     });
 *     var wafrule = new Aws.Waf.Rule("wafrule", new()
 *     {
 *         Name = "tfWAFRule",
 *         MetricName = "tfWAFRule",
 *         Predicates = new[]
 *         {
 *             new Aws.Waf.Inputs.RulePredicateArgs
 *             {
 *                 DataId = ipset.Id,
 *                 Negated = false,
 *                 Type = "IPMatch",
 *             },
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             ipset,
 *         },
 *     });
 *     var wafAcl = new Aws.Waf.WebAcl("waf_acl", new()
 *     {
 *         Name = "tfWebACL",
 *         MetricName = "tfWebACL",
 *         DefaultAction = new Aws.Waf.Inputs.WebAclDefaultActionArgs
 *         {
 *             Type = "ALLOW",
 *         },
 *         Rules = new[]
 *         {
 *             new Aws.Waf.Inputs.WebAclRuleArgs
 *             {
 *                 Action = new Aws.Waf.Inputs.WebAclRuleActionArgs
 *                 {
 *                     Type = "BLOCK",
 *                 },
 *                 Priority = 1,
 *                 RuleId = wafrule.Id,
 *                 Type = "REGULAR",
 *             },
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             ipset,
 *             wafrule,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/waf"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		ipset, err := waf.NewIpSet(ctx, "ipset", &waf.IpSetArgs{
 * 			Name: pulumi.String("tfIPSet"),
 * 			IpSetDescriptors: waf.IpSetIpSetDescriptorArray{
 * 				&waf.IpSetIpSetDescriptorArgs{
 * 					Type:  pulumi.String("IPV4"),
 * 					Value: pulumi.String("192.0.7.0/24"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		wafrule, err := waf.NewRule(ctx, "wafrule", &waf.RuleArgs{
 * 			Name:       pulumi.String("tfWAFRule"),
 * 			MetricName: pulumi.String("tfWAFRule"),
 * 			Predicates: waf.RulePredicateArray{
 * 				&waf.RulePredicateArgs{
 * 					DataId:  ipset.ID(),
 * 					Negated: pulumi.Bool(false),
 * 					Type:    pulumi.String("IPMatch"),
 * 				},
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			ipset,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = waf.NewWebAcl(ctx, "waf_acl", &waf.WebAclArgs{
 * 			Name:       pulumi.String("tfWebACL"),
 * 			MetricName: pulumi.String("tfWebACL"),
 * 			DefaultAction: &waf.WebAclDefaultActionArgs{
 * 				Type: pulumi.String("ALLOW"),
 * 			},
 * 			Rules: waf.WebAclRuleArray{
 * 				&waf.WebAclRuleArgs{
 * 					Action: &waf.WebAclRuleActionArgs{
 * 						Type: pulumi.String("BLOCK"),
 * 					},
 * 					Priority: pulumi.Int(1),
 * 					RuleId:   wafrule.ID(),
 * 					Type:     pulumi.String("REGULAR"),
 * 				},
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			ipset,
 * 			wafrule,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.waf.IpSet;
 * import com.pulumi.aws.waf.IpSetArgs;
 * import com.pulumi.aws.waf.inputs.IpSetIpSetDescriptorArgs;
 * import com.pulumi.aws.waf.Rule;
 * import com.pulumi.aws.waf.RuleArgs;
 * import com.pulumi.aws.waf.inputs.RulePredicateArgs;
 * import com.pulumi.aws.waf.WebAcl;
 * import com.pulumi.aws.waf.WebAclArgs;
 * import com.pulumi.aws.waf.inputs.WebAclDefaultActionArgs;
 * import com.pulumi.aws.waf.inputs.WebAclRuleArgs;
 * import com.pulumi.aws.waf.inputs.WebAclRuleActionArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ipset = new IpSet("ipset", IpSetArgs.builder()
 *             .name("tfIPSet")
 *             .ipSetDescriptors(IpSetIpSetDescriptorArgs.builder()
 *                 .type("IPV4")
 *                 .value("192.0.7.0/24")
 *                 .build())
 *             .build());
 *         var wafrule = new Rule("wafrule", RuleArgs.builder()
 *             .name("tfWAFRule")
 *             .metricName("tfWAFRule")
 *             .predicates(RulePredicateArgs.builder()
 *                 .dataId(ipset.id())
 *                 .negated(false)
 *                 .type("IPMatch")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(ipset)
 *                 .build());
 *         var wafAcl = new WebAcl("wafAcl", WebAclArgs.builder()
 *             .name("tfWebACL")
 *             .metricName("tfWebACL")
 *             .defaultAction(WebAclDefaultActionArgs.builder()
 *                 .type("ALLOW")
 *                 .build())
 *             .rules(WebAclRuleArgs.builder()
 *                 .action(WebAclRuleActionArgs.builder()
 *                     .type("BLOCK")
 *                     .build())
 *                 .priority(1)
 *                 .ruleId(wafrule.id())
 *                 .type("REGULAR")
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(
 *                     ipset,
 *                     wafrule)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   ipset:
 *     type: aws:waf:IpSet
 *     properties:
 *       name: tfIPSet
 *       ipSetDescriptors:
 *         - type: IPV4
 *           value: 192.0.7.0/24
 *   wafrule:
 *     type: aws:waf:Rule
 *     properties:
 *       name: tfWAFRule
 *       metricName: tfWAFRule
 *       predicates:
 *         - dataId: ${ipset.id}
 *           negated: false
 *           type: IPMatch
 *     options:
 *       dependson:
 *         - ${ipset}
 *   wafAcl:
 *     type: aws:waf:WebAcl
 *     name: waf_acl
 *     properties:
 *       name: tfWebACL
 *       metricName: tfWebACL
 *       defaultAction:
 *         type: ALLOW
 *       rules:
 *         - action:
 *             type: BLOCK
 *           priority: 1
 *           ruleId: ${wafrule.id}
 *           type: REGULAR
 *     options:
 *       dependson:
 *         - ${ipset}
 *         - ${wafrule}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Logging
 * > *NOTE:* The Kinesis Firehose Delivery Stream name must begin with `aws-waf-logs-` and be located in `us-east-1` region. See the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/logging.html) for more information about enabling WAF logging.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.waf.WebAcl("example", {loggingConfiguration: {
 *     logDestination: exampleAwsKinesisFirehoseDeliveryStream.arn,
 *     redactedFields: {
 *         fieldToMatches: [
 *             {
 *                 type: "URI",
 *             },
 *             {
 *                 data: "referer",
 *                 type: "HEADER",
 *             },
 *         ],
 *     },
 * }});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.waf.WebAcl("example", logging_configuration={
 *     "log_destination": example_aws_kinesis_firehose_delivery_stream["arn"],
 *     "redacted_fields": {
 *         "field_to_matches": [
 *             {
 *                 "type": "URI",
 *             },
 *             {
 *                 "data": "referer",
 *                 "type": "HEADER",
 *             },
 *         ],
 *     },
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Waf.WebAcl("example", new()
 *     {
 *         LoggingConfiguration = new Aws.Waf.Inputs.WebAclLoggingConfigurationArgs
 *         {
 *             LogDestination = exampleAwsKinesisFirehoseDeliveryStream.Arn,
 *             RedactedFields = new Aws.Waf.Inputs.WebAclLoggingConfigurationRedactedFieldsArgs
 *             {
 *                 FieldToMatches = new[]
 *                 {
 *                     new Aws.Waf.Inputs.WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgs
 *                     {
 *                         Type = "URI",
 *                     },
 *                     new Aws.Waf.Inputs.WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgs
 *                     {
 *                         Data = "referer",
 *                         Type = "HEADER",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/waf"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := waf.NewWebAcl(ctx, "example", &waf.WebAclArgs{
 * 			LoggingConfiguration: &waf.WebAclLoggingConfigurationArgs{
 * 				LogDestination: pulumi.Any(exampleAwsKinesisFirehoseDeliveryStream.Arn),
 * 				RedactedFields: &waf.WebAclLoggingConfigurationRedactedFieldsArgs{
 * 					FieldToMatches: waf.WebAclLoggingConfigurationRedactedFieldsFieldToMatchArray{
 * 						&waf.WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgs{
 * 							Type: pulumi.String("URI"),
 * 						},
 * 						&waf.WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgs{
 * 							Data: pulumi.String("referer"),
 * 							Type: pulumi.String("HEADER"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.waf.WebAcl;
 * import com.pulumi.aws.waf.WebAclArgs;
 * import com.pulumi.aws.waf.inputs.WebAclLoggingConfigurationArgs;
 * import com.pulumi.aws.waf.inputs.WebAclLoggingConfigurationRedactedFieldsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new WebAcl("example", WebAclArgs.builder()
 *             .loggingConfiguration(WebAclLoggingConfigurationArgs.builder()
 *                 .logDestination(exampleAwsKinesisFirehoseDeliveryStream.arn())
 *                 .redactedFields(WebAclLoggingConfigurationRedactedFieldsArgs.builder()
 *                     .fieldToMatches(
 *                         WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgs.builder()
 *                             .type("URI")
 *                             .build(),
 *                         WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgs.builder()
 *                             .data("referer")
 *                             .type("HEADER")
 *                             .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:waf:WebAcl
 *     properties:
 *       loggingConfiguration:
 *         logDestination: ${exampleAwsKinesisFirehoseDeliveryStream.arn}
 *         redactedFields:
 *           fieldToMatches:
 *             - type: URI
 *             - data: referer
 *               type: HEADER
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import WAF Web ACL using the `id`. For example:
 * ```sh
 * $ pulumi import aws:waf/webAcl:WebAcl main 0c8e583e-18f3-4c13-9e2a-67c4805d2f94
 * ```
 * @property defaultAction Configuration block with action that you want AWS WAF to take when a request doesn't match the criteria in any of the rules that are associated with the web ACL. Detailed below.
 * @property loggingConfiguration Configuration block to enable WAF logging. Detailed below.
 * @property metricName The name or description for the Amazon CloudWatch metric of this web ACL.
 * @property name The name or description of the web ACL.
 * @property rules Configuration blocks containing rules to associate with the web ACL and the settings for each rule. Detailed below.
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class WebAclArgs(
    public val defaultAction: Output<WebAclDefaultActionArgs>? = null,
    public val loggingConfiguration: Output<WebAclLoggingConfigurationArgs>? = null,
    public val metricName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val rules: Output<List<WebAclRuleArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.waf.WebAclArgs> {
    override fun toJava(): com.pulumi.aws.waf.WebAclArgs = com.pulumi.aws.waf.WebAclArgs.builder()
        .defaultAction(defaultAction?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .loggingConfiguration(
            loggingConfiguration?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .metricName(metricName?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .rules(rules?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [WebAclArgs].
 */
@PulumiTagMarker
public class WebAclArgsBuilder internal constructor() {
    private var defaultAction: Output<WebAclDefaultActionArgs>? = null

    private var loggingConfiguration: Output<WebAclLoggingConfigurationArgs>? = null

    private var metricName: Output<String>? = null

    private var name: Output<String>? = null

    private var rules: Output<List<WebAclRuleArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Configuration block with action that you want AWS WAF to take when a request doesn't match the criteria in any of the rules that are associated with the web ACL. Detailed below.
     */
    @JvmName("usjfyjtogadmqsav")
    public suspend fun defaultAction(`value`: Output<WebAclDefaultActionArgs>) {
        this.defaultAction = value
    }

    /**
     * @param value Configuration block to enable WAF logging. Detailed below.
     */
    @JvmName("ifyalhcpjweeqyks")
    public suspend fun loggingConfiguration(`value`: Output<WebAclLoggingConfigurationArgs>) {
        this.loggingConfiguration = value
    }

    /**
     * @param value The name or description for the Amazon CloudWatch metric of this web ACL.
     */
    @JvmName("ferhvvifamwsunnq")
    public suspend fun metricName(`value`: Output<String>) {
        this.metricName = value
    }

    /**
     * @param value The name or description of the web ACL.
     */
    @JvmName("prxlumjbqpuuphpv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Configuration blocks containing rules to associate with the web ACL and the settings for each rule. Detailed below.
     */
    @JvmName("ekvsqwcgvtqmflbp")
    public suspend fun rules(`value`: Output<List<WebAclRuleArgs>>) {
        this.rules = value
    }

    @JvmName("rtyxfwjphjmjlnmk")
    public suspend fun rules(vararg values: Output<WebAclRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values Configuration blocks containing rules to associate with the web ACL and the settings for each rule. Detailed below.
     */
    @JvmName("akmuodjjvnjyqwbw")
    public suspend fun rules(values: List<Output<WebAclRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ybpajtuksnlscbxm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Configuration block with action that you want AWS WAF to take when a request doesn't match the criteria in any of the rules that are associated with the web ACL. Detailed below.
     */
    @JvmName("sjqrtrfhclqlnjqk")
    public suspend fun defaultAction(`value`: WebAclDefaultActionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultAction = mapped
    }

    /**
     * @param argument Configuration block with action that you want AWS WAF to take when a request doesn't match the criteria in any of the rules that are associated with the web ACL. Detailed below.
     */
    @JvmName("umtnahnfrsumhgyr")
    public suspend fun defaultAction(argument: suspend WebAclDefaultActionArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclDefaultActionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.defaultAction = mapped
    }

    /**
     * @param value Configuration block to enable WAF logging. Detailed below.
     */
    @JvmName("hfbwntbgjjrwxbak")
    public suspend fun loggingConfiguration(`value`: WebAclLoggingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loggingConfiguration = mapped
    }

    /**
     * @param argument Configuration block to enable WAF logging. Detailed below.
     */
    @JvmName("sqaubwgcumfwpuks")
    public suspend fun loggingConfiguration(argument: suspend WebAclLoggingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclLoggingConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.loggingConfiguration = mapped
    }

    /**
     * @param value The name or description for the Amazon CloudWatch metric of this web ACL.
     */
    @JvmName("puucfbrewjdqbobq")
    public suspend fun metricName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricName = mapped
    }

    /**
     * @param value The name or description of the web ACL.
     */
    @JvmName("ywbirttloipscwgs")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Configuration blocks containing rules to associate with the web ACL and the settings for each rule. Detailed below.
     */
    @JvmName("hmxoulckuvfdafat")
    public suspend fun rules(`value`: List<WebAclRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument Configuration blocks containing rules to associate with the web ACL and the settings for each rule. Detailed below.
     */
    @JvmName("uhapbcnpajiyalhs")
    public suspend fun rules(argument: List<suspend WebAclRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { WebAclRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument Configuration blocks containing rules to associate with the web ACL and the settings for each rule. Detailed below.
     */
    @JvmName("fnknlskeloxhyxks")
    public suspend fun rules(vararg argument: suspend WebAclRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { WebAclRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument Configuration blocks containing rules to associate with the web ACL and the settings for each rule. Detailed below.
     */
    @JvmName("qdsrypchjepycuax")
    public suspend fun rules(argument: suspend WebAclRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(WebAclRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values Configuration blocks containing rules to associate with the web ACL and the settings for each rule. Detailed below.
     */
    @JvmName("nwaekwcpprcwubxv")
    public suspend fun rules(vararg values: WebAclRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wsnndqikumhtwggo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gkixlbtlechwsqle")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): WebAclArgs = WebAclArgs(
        defaultAction = defaultAction,
        loggingConfiguration = loggingConfiguration,
        metricName = metricName,
        name = name,
        rules = rules,
        tags = tags,
    )
}
