@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin

import com.pulumi.aws.waf.kotlin.outputs.XssMatchSetXssMatchTuple
import com.pulumi.aws.waf.kotlin.outputs.XssMatchSetXssMatchTuple.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [XssMatchSet].
 */
@PulumiTagMarker
public class XssMatchSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: XssMatchSetArgs = XssMatchSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend XssMatchSetArgsBuilder.() -> Unit) {
        val builder = XssMatchSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): XssMatchSet {
        val builtJavaResource = com.pulumi.aws.waf.XssMatchSet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return XssMatchSet(builtJavaResource)
    }
}

/**
 * Provides a WAF XSS Match Set Resource
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const xssMatchSet = new aws.waf.XssMatchSet("xss_match_set", {
 *     name: "xss_match_set",
 *     xssMatchTuples: [
 *         {
 *             textTransformation: "NONE",
 *             fieldToMatch: {
 *                 type: "URI",
 *             },
 *         },
 *         {
 *             textTransformation: "NONE",
 *             fieldToMatch: {
 *                 type: "QUERY_STRING",
 *             },
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * xss_match_set = aws.waf.XssMatchSet("xss_match_set",
 *     name="xss_match_set",
 *     xss_match_tuples=[
 *         {
 *             "text_transformation": "NONE",
 *             "field_to_match": {
 *                 "type": "URI",
 *             },
 *         },
 *         {
 *             "text_transformation": "NONE",
 *             "field_to_match": {
 *                 "type": "QUERY_STRING",
 *             },
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var xssMatchSet = new Aws.Waf.XssMatchSet("xss_match_set", new()
 *     {
 *         Name = "xss_match_set",
 *         XssMatchTuples = new[]
 *         {
 *             new Aws.Waf.Inputs.XssMatchSetXssMatchTupleArgs
 *             {
 *                 TextTransformation = "NONE",
 *                 FieldToMatch = new Aws.Waf.Inputs.XssMatchSetXssMatchTupleFieldToMatchArgs
 *                 {
 *                     Type = "URI",
 *                 },
 *             },
 *             new Aws.Waf.Inputs.XssMatchSetXssMatchTupleArgs
 *             {
 *                 TextTransformation = "NONE",
 *                 FieldToMatch = new Aws.Waf.Inputs.XssMatchSetXssMatchTupleFieldToMatchArgs
 *                 {
 *                     Type = "QUERY_STRING",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/waf"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := waf.NewXssMatchSet(ctx, "xss_match_set", &waf.XssMatchSetArgs{
 * 			Name: pulumi.String("xss_match_set"),
 * 			XssMatchTuples: waf.XssMatchSetXssMatchTupleArray{
 * 				&waf.XssMatchSetXssMatchTupleArgs{
 * 					TextTransformation: pulumi.String("NONE"),
 * 					FieldToMatch: &waf.XssMatchSetXssMatchTupleFieldToMatchArgs{
 * 						Type: pulumi.String("URI"),
 * 					},
 * 				},
 * 				&waf.XssMatchSetXssMatchTupleArgs{
 * 					TextTransformation: pulumi.String("NONE"),
 * 					FieldToMatch: &waf.XssMatchSetXssMatchTupleFieldToMatchArgs{
 * 						Type: pulumi.String("QUERY_STRING"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.waf.XssMatchSet;
 * import com.pulumi.aws.waf.XssMatchSetArgs;
 * import com.pulumi.aws.waf.inputs.XssMatchSetXssMatchTupleArgs;
 * import com.pulumi.aws.waf.inputs.XssMatchSetXssMatchTupleFieldToMatchArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var xssMatchSet = new XssMatchSet("xssMatchSet", XssMatchSetArgs.builder()
 *             .name("xss_match_set")
 *             .xssMatchTuples(
 *                 XssMatchSetXssMatchTupleArgs.builder()
 *                     .textTransformation("NONE")
 *                     .fieldToMatch(XssMatchSetXssMatchTupleFieldToMatchArgs.builder()
 *                         .type("URI")
 *                         .build())
 *                     .build(),
 *                 XssMatchSetXssMatchTupleArgs.builder()
 *                     .textTransformation("NONE")
 *                     .fieldToMatch(XssMatchSetXssMatchTupleFieldToMatchArgs.builder()
 *                         .type("QUERY_STRING")
 *                         .build())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   xssMatchSet:
 *     type: aws:waf:XssMatchSet
 *     name: xss_match_set
 *     properties:
 *       name: xss_match_set
 *       xssMatchTuples:
 *         - textTransformation: NONE
 *           fieldToMatch:
 *             type: URI
 *         - textTransformation: NONE
 *           fieldToMatch:
 *             type: QUERY_STRING
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import WAF XSS Match Set using their ID. For example:
 * ```sh
 * $ pulumi import aws:waf/xssMatchSet:XssMatchSet example a1b2c3d4-d5f6-7777-8888-9999aaaabbbbcccc
 * ```
 */
public class XssMatchSet internal constructor(
    override val javaResource: com.pulumi.aws.waf.XssMatchSet,
) : KotlinCustomResource(javaResource, XssMatchSetMapper) {
    /**
     * Amazon Resource Name (ARN)
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The name or description of the SizeConstraintSet.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The parts of web requests that you want to inspect for cross-site scripting attacks.
     */
    public val xssMatchTuples: Output<List<XssMatchSetXssMatchTuple>>?
        get() = javaResource.xssMatchTuples().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })
}

public object XssMatchSetMapper : ResourceMapper<XssMatchSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.waf.XssMatchSet::class == javaResource::class

    override fun map(javaResource: Resource): XssMatchSet = XssMatchSet(
        javaResource as
            com.pulumi.aws.waf.XssMatchSet,
    )
}

/**
 * @see [XssMatchSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [XssMatchSet].
 */
public suspend fun xssMatchSet(name: String, block: suspend XssMatchSetResourceBuilder.() -> Unit): XssMatchSet {
    val builder = XssMatchSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [XssMatchSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun xssMatchSet(name: String): XssMatchSet {
    val builder = XssMatchSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
