@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin.inputs

import com.pulumi.aws.waf.inputs.GetIpsetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getIpset.
 * @property name Name of the WAF IP set.
 */
public data class GetIpsetPlainArgs(
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.waf.inputs.GetIpsetPlainArgs> {
    override fun toJava(): com.pulumi.aws.waf.inputs.GetIpsetPlainArgs =
        com.pulumi.aws.waf.inputs.GetIpsetPlainArgs.builder()
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIpsetPlainArgs].
 */
@PulumiTagMarker
public class GetIpsetPlainArgsBuilder internal constructor() {
    private var name: String? = null

    /**
     * @param value Name of the WAF IP set.
     */
    @JvmName("ojybnrvtcppjymuy")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetIpsetPlainArgs = GetIpsetPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
