@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin.inputs

import com.pulumi.aws.waf.inputs.GetWebAclPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getWebAcl.
 * @property name Name of the WAF Web ACL.
 */
public data class GetWebAclPlainArgs(
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.waf.inputs.GetWebAclPlainArgs> {
    override fun toJava(): com.pulumi.aws.waf.inputs.GetWebAclPlainArgs =
        com.pulumi.aws.waf.inputs.GetWebAclPlainArgs.builder()
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWebAclPlainArgs].
 */
@PulumiTagMarker
public class GetWebAclPlainArgsBuilder internal constructor() {
    private var name: String? = null

    /**
     * @param value Name of the WAF Web ACL.
     */
    @JvmName("bqxgdrbjeoxvrmbu")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetWebAclPlainArgs = GetWebAclPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
