@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin.inputs

import com.pulumi.aws.waf.inputs.RateBasedRulePredicateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dataId A unique identifier for a predicate in the rule, such as Byte Match Set ID or IPSet ID.
 * @property negated Set this to `false` if you want to allow, block, or count requests
 * based on the settings in the specified `ByteMatchSet`, `IPSet`, `SqlInjectionMatchSet`, `XssMatchSet`, or `SizeConstraintSet`.
 * For example, if an IPSet includes the IP address `192.0.2.44`, AWS WAF will allow or block requests based on that IP address.
 * If set to `true`, AWS WAF will allow, block, or count requests based on all IP addresses _except_ `192.0.2.44`.
 * @property type The type of predicate in a rule. Valid values: `ByteMatch`, `GeoMatch`, `IPMatch`, `RegexMatch`, `SizeConstraint`, `SqlInjectionMatch`, or `XssMatch`.
 */
public data class RateBasedRulePredicateArgs(
    public val dataId: Output<String>,
    public val negated: Output<Boolean>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.waf.inputs.RateBasedRulePredicateArgs> {
    override fun toJava(): com.pulumi.aws.waf.inputs.RateBasedRulePredicateArgs =
        com.pulumi.aws.waf.inputs.RateBasedRulePredicateArgs.builder()
            .dataId(dataId.applyValue({ args0 -> args0 }))
            .negated(negated.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RateBasedRulePredicateArgs].
 */
@PulumiTagMarker
public class RateBasedRulePredicateArgsBuilder internal constructor() {
    private var dataId: Output<String>? = null

    private var negated: Output<Boolean>? = null

    private var type: Output<String>? = null

    /**
     * @param value A unique identifier for a predicate in the rule, such as Byte Match Set ID or IPSet ID.
     */
    @JvmName("qgvirbpwwnysngro")
    public suspend fun dataId(`value`: Output<String>) {
        this.dataId = value
    }

    /**
     * @param value Set this to `false` if you want to allow, block, or count requests
     * based on the settings in the specified `ByteMatchSet`, `IPSet`, `SqlInjectionMatchSet`, `XssMatchSet`, or `SizeConstraintSet`.
     * For example, if an IPSet includes the IP address `192.0.2.44`, AWS WAF will allow or block requests based on that IP address.
     * If set to `true`, AWS WAF will allow, block, or count requests based on all IP addresses _except_ `192.0.2.44`.
     */
    @JvmName("dpuacuxutiavuuoc")
    public suspend fun negated(`value`: Output<Boolean>) {
        this.negated = value
    }

    /**
     * @param value The type of predicate in a rule. Valid values: `ByteMatch`, `GeoMatch`, `IPMatch`, `RegexMatch`, `SizeConstraint`, `SqlInjectionMatch`, or `XssMatch`.
     */
    @JvmName("pxgiepkjufavbotf")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value A unique identifier for a predicate in the rule, such as Byte Match Set ID or IPSet ID.
     */
    @JvmName("rpwlnptyugrdhgug")
    public suspend fun dataId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataId = mapped
    }

    /**
     * @param value Set this to `false` if you want to allow, block, or count requests
     * based on the settings in the specified `ByteMatchSet`, `IPSet`, `SqlInjectionMatchSet`, `XssMatchSet`, or `SizeConstraintSet`.
     * For example, if an IPSet includes the IP address `192.0.2.44`, AWS WAF will allow or block requests based on that IP address.
     * If set to `true`, AWS WAF will allow, block, or count requests based on all IP addresses _except_ `192.0.2.44`.
     */
    @JvmName("vhmpgdupmkhkrvcv")
    public suspend fun negated(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.negated = mapped
    }

    /**
     * @param value The type of predicate in a rule. Valid values: `ByteMatch`, `GeoMatch`, `IPMatch`, `RegexMatch`, `SizeConstraint`, `SqlInjectionMatch`, or `XssMatch`.
     */
    @JvmName("tlcvtatanqbmrkyt")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): RateBasedRulePredicateArgs = RateBasedRulePredicateArgs(
        dataId = dataId ?: throw PulumiNullFieldException("dataId"),
        negated = negated ?: throw PulumiNullFieldException("negated"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
