@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin.inputs

import com.pulumi.aws.waf.inputs.SizeConstraintSetSizeConstraintArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property comparisonOperator Type of comparison you want to perform, such as `EQ`, `NE`, `LT`, or `GT`. Please refer to the [documentation](https://docs.aws.amazon.com/waf/latest/APIReference/API_wafRegional_SizeConstraint.html) for a complete list of supported values.
 * @property fieldToMatch Parameter that specifies where in a web request to look for the size constraint.
 * @property size Size in bytes that you want to compare against the size of the specified `field_to_match`. Valid values for `size` are between 0 and 21474836480 bytes (0 and 20 GB).
 * @property textTransformation Parameter is used to eliminate unusual formatting that attackers may use in web requests to bypass AWS WAF. When a transformation is specified, AWS WAF performs the transformation on the `field_to_match` before inspecting the request for a match. Some examples of supported transformations are `CMD_LINE`, `HTML_ENTITY_DECODE`, and `NONE`. You can find a complete list of supported values in the [AWS WAF API Reference](http://docs.aws.amazon.com/waf/latest/APIReference/API_SizeConstraint.html#WAF-Type-SizeConstraint-TextTransformation).
 * **Note:** If you choose `BODY` as the `type`, you must also choose `NONE` because CloudFront only forwards the first 8192 bytes for inspection.
 */
public data class SizeConstraintSetSizeConstraintArgs(
    public val comparisonOperator: Output<String>,
    public val fieldToMatch: Output<SizeConstraintSetSizeConstraintFieldToMatchArgs>,
    public val size: Output<Int>,
    public val textTransformation: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.waf.inputs.SizeConstraintSetSizeConstraintArgs> {
    override fun toJava(): com.pulumi.aws.waf.inputs.SizeConstraintSetSizeConstraintArgs =
        com.pulumi.aws.waf.inputs.SizeConstraintSetSizeConstraintArgs.builder()
            .comparisonOperator(comparisonOperator.applyValue({ args0 -> args0 }))
            .fieldToMatch(fieldToMatch.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .size(size.applyValue({ args0 -> args0 }))
            .textTransformation(textTransformation.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SizeConstraintSetSizeConstraintArgs].
 */
@PulumiTagMarker
public class SizeConstraintSetSizeConstraintArgsBuilder internal constructor() {
    private var comparisonOperator: Output<String>? = null

    private var fieldToMatch: Output<SizeConstraintSetSizeConstraintFieldToMatchArgs>? = null

    private var size: Output<Int>? = null

    private var textTransformation: Output<String>? = null

    /**
     * @param value Type of comparison you want to perform, such as `EQ`, `NE`, `LT`, or `GT`. Please refer to the [documentation](https://docs.aws.amazon.com/waf/latest/APIReference/API_wafRegional_SizeConstraint.html) for a complete list of supported values.
     */
    @JvmName("ybiwipfqwpsgehge")
    public suspend fun comparisonOperator(`value`: Output<String>) {
        this.comparisonOperator = value
    }

    /**
     * @param value Parameter that specifies where in a web request to look for the size constraint.
     */
    @JvmName("hmdvrfgnlhqmtiwh")
    public suspend fun fieldToMatch(`value`: Output<SizeConstraintSetSizeConstraintFieldToMatchArgs>) {
        this.fieldToMatch = value
    }

    /**
     * @param value Size in bytes that you want to compare against the size of the specified `field_to_match`. Valid values for `size` are between 0 and 21474836480 bytes (0 and 20 GB).
     */
    @JvmName("tfandpvqxbinraug")
    public suspend fun size(`value`: Output<Int>) {
        this.size = value
    }

    /**
     * @param value Parameter is used to eliminate unusual formatting that attackers may use in web requests to bypass AWS WAF. When a transformation is specified, AWS WAF performs the transformation on the `field_to_match` before inspecting the request for a match. Some examples of supported transformations are `CMD_LINE`, `HTML_ENTITY_DECODE`, and `NONE`. You can find a complete list of supported values in the [AWS WAF API Reference](http://docs.aws.amazon.com/waf/latest/APIReference/API_SizeConstraint.html#WAF-Type-SizeConstraint-TextTransformation).
     * **Note:** If you choose `BODY` as the `type`, you must also choose `NONE` because CloudFront only forwards the first 8192 bytes for inspection.
     */
    @JvmName("vrggnrfnfigmdqtt")
    public suspend fun textTransformation(`value`: Output<String>) {
        this.textTransformation = value
    }

    /**
     * @param value Type of comparison you want to perform, such as `EQ`, `NE`, `LT`, or `GT`. Please refer to the [documentation](https://docs.aws.amazon.com/waf/latest/APIReference/API_wafRegional_SizeConstraint.html) for a complete list of supported values.
     */
    @JvmName("rfbofxpapnkhiyeb")
    public suspend fun comparisonOperator(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.comparisonOperator = mapped
    }

    /**
     * @param value Parameter that specifies where in a web request to look for the size constraint.
     */
    @JvmName("svoeaotcemlapvjx")
    public suspend fun fieldToMatch(`value`: SizeConstraintSetSizeConstraintFieldToMatchArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fieldToMatch = mapped
    }

    /**
     * @param argument Parameter that specifies where in a web request to look for the size constraint.
     */
    @JvmName("loefkrppthohtduh")
    public suspend fun fieldToMatch(argument: suspend SizeConstraintSetSizeConstraintFieldToMatchArgsBuilder.() -> Unit) {
        val toBeMapped = SizeConstraintSetSizeConstraintFieldToMatchArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.fieldToMatch = mapped
    }

    /**
     * @param value Size in bytes that you want to compare against the size of the specified `field_to_match`. Valid values for `size` are between 0 and 21474836480 bytes (0 and 20 GB).
     */
    @JvmName("ogfjvtfjskqevpfl")
    public suspend fun size(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value Parameter is used to eliminate unusual formatting that attackers may use in web requests to bypass AWS WAF. When a transformation is specified, AWS WAF performs the transformation on the `field_to_match` before inspecting the request for a match. Some examples of supported transformations are `CMD_LINE`, `HTML_ENTITY_DECODE`, and `NONE`. You can find a complete list of supported values in the [AWS WAF API Reference](http://docs.aws.amazon.com/waf/latest/APIReference/API_SizeConstraint.html#WAF-Type-SizeConstraint-TextTransformation).
     * **Note:** If you choose `BODY` as the `type`, you must also choose `NONE` because CloudFront only forwards the first 8192 bytes for inspection.
     */
    @JvmName("rrcyeinnsomevwnk")
    public suspend fun textTransformation(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformation = mapped
    }

    internal fun build(): SizeConstraintSetSizeConstraintArgs = SizeConstraintSetSizeConstraintArgs(
        comparisonOperator = comparisonOperator ?: throw PulumiNullFieldException("comparisonOperator"),
        fieldToMatch = fieldToMatch ?: throw PulumiNullFieldException("fieldToMatch"),
        size = size ?: throw PulumiNullFieldException("size"),
        textTransformation = textTransformation ?: throw PulumiNullFieldException("textTransformation"),
    )
}
