@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin.inputs

import com.pulumi.aws.waf.inputs.SqlInjectionMatchSetSqlInjectionMatchTupleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property fieldToMatch Specifies where in a web request to look for snippets of malicious SQL code.
 * @property textTransformation Text transformations used to eliminate unusual formatting that attackers use in web requests in an effort to bypass AWS WAF.
 * If you specify a transformation, AWS WAF performs the transformation on `field_to_match` before inspecting a request for a match.
 * e.g., `CMD_LINE`, `HTML_ENTITY_DECODE` or `NONE`.
 * See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_SqlInjectionMatchTuple.html#WAF-Type-SqlInjectionMatchTuple-TextTransformation)
 * for all supported values.
 */
public data class SqlInjectionMatchSetSqlInjectionMatchTupleArgs(
    public val fieldToMatch: Output<SqlInjectionMatchSetSqlInjectionMatchTupleFieldToMatchArgs>,
    public val textTransformation: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.waf.inputs.SqlInjectionMatchSetSqlInjectionMatchTupleArgs> {
    override fun toJava(): com.pulumi.aws.waf.inputs.SqlInjectionMatchSetSqlInjectionMatchTupleArgs =
        com.pulumi.aws.waf.inputs.SqlInjectionMatchSetSqlInjectionMatchTupleArgs.builder()
            .fieldToMatch(fieldToMatch.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .textTransformation(textTransformation.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SqlInjectionMatchSetSqlInjectionMatchTupleArgs].
 */
@PulumiTagMarker
public class SqlInjectionMatchSetSqlInjectionMatchTupleArgsBuilder internal constructor() {
    private var fieldToMatch: Output<SqlInjectionMatchSetSqlInjectionMatchTupleFieldToMatchArgs>? =
        null

    private var textTransformation: Output<String>? = null

    /**
     * @param value Specifies where in a web request to look for snippets of malicious SQL code.
     */
    @JvmName("goiaqbvlrvruqdhr")
    public suspend fun fieldToMatch(`value`: Output<SqlInjectionMatchSetSqlInjectionMatchTupleFieldToMatchArgs>) {
        this.fieldToMatch = value
    }

    /**
     * @param value Text transformations used to eliminate unusual formatting that attackers use in web requests in an effort to bypass AWS WAF.
     * If you specify a transformation, AWS WAF performs the transformation on `field_to_match` before inspecting a request for a match.
     * e.g., `CMD_LINE`, `HTML_ENTITY_DECODE` or `NONE`.
     * See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_SqlInjectionMatchTuple.html#WAF-Type-SqlInjectionMatchTuple-TextTransformation)
     * for all supported values.
     */
    @JvmName("tvkrkraafwmdwvvx")
    public suspend fun textTransformation(`value`: Output<String>) {
        this.textTransformation = value
    }

    /**
     * @param value Specifies where in a web request to look for snippets of malicious SQL code.
     */
    @JvmName("smuqjsvhhnibnhgi")
    public suspend fun fieldToMatch(`value`: SqlInjectionMatchSetSqlInjectionMatchTupleFieldToMatchArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fieldToMatch = mapped
    }

    /**
     * @param argument Specifies where in a web request to look for snippets of malicious SQL code.
     */
    @JvmName("nomyjfcvbqeqxrxc")
    public suspend fun fieldToMatch(argument: suspend SqlInjectionMatchSetSqlInjectionMatchTupleFieldToMatchArgsBuilder.() -> Unit) {
        val toBeMapped =
            SqlInjectionMatchSetSqlInjectionMatchTupleFieldToMatchArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.fieldToMatch = mapped
    }

    /**
     * @param value Text transformations used to eliminate unusual formatting that attackers use in web requests in an effort to bypass AWS WAF.
     * If you specify a transformation, AWS WAF performs the transformation on `field_to_match` before inspecting a request for a match.
     * e.g., `CMD_LINE`, `HTML_ENTITY_DECODE` or `NONE`.
     * See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_SqlInjectionMatchTuple.html#WAF-Type-SqlInjectionMatchTuple-TextTransformation)
     * for all supported values.
     */
    @JvmName("vvvhtkanhsuwvhau")
    public suspend fun textTransformation(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformation = mapped
    }

    internal fun build(): SqlInjectionMatchSetSqlInjectionMatchTupleArgs =
        SqlInjectionMatchSetSqlInjectionMatchTupleArgs(
            fieldToMatch = fieldToMatch ?: throw PulumiNullFieldException("fieldToMatch"),
            textTransformation = textTransformation ?: throw PulumiNullFieldException("textTransformation"),
        )
}
