@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin.inputs

import com.pulumi.aws.waf.inputs.WebAclRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property action The action that CloudFront or AWS WAF takes when a web request matches the conditions in the rule. Not used if `type` is `GROUP`.
 * @property overrideAction Override the action that a group requests CloudFront or AWS WAF takes when a web request matches the conditions in the rule. Only used if `type` is `GROUP`.
 * @property priority Specifies the order in which the rules in a WebACL are evaluated.
 * Rules with a lower value are evaluated before rules with a higher value.
 * @property ruleId ID of the associated WAF (Global) rule (e.g., `aws.waf.Rule`). WAF (Regional) rules cannot be used.
 * @property type The rule type, either `REGULAR`, as defined by [Rule](http://docs&#46;aws&#46;amazon&#46;com/waf/latest/APIReference/API_Rule&#46;html), `RATE_BASED`, as defined by [RateBasedRule](http://docs&#46;aws&#46;amazon&#46;com/waf/latest/APIReference/API_RateBasedRule&#46;html), or `GROUP`, as defined by [RuleGroup](https://docs.aws.amazon.com/waf/latest/APIReference/API_RuleGroup.html). The default is REGULAR. If you add a RATE_BASED rule, you need to set `type` as `RATE_BASED`. If you add a GROUP rule, you need to set `type` as `GROUP`.
 */
public data class WebAclRuleArgs(
    public val action: Output<WebAclRuleActionArgs>? = null,
    public val overrideAction: Output<WebAclRuleOverrideActionArgs>? = null,
    public val priority: Output<Int>,
    public val ruleId: Output<String>,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.waf.inputs.WebAclRuleArgs> {
    override fun toJava(): com.pulumi.aws.waf.inputs.WebAclRuleArgs =
        com.pulumi.aws.waf.inputs.WebAclRuleArgs.builder()
            .action(action?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .overrideAction(overrideAction?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .priority(priority.applyValue({ args0 -> args0 }))
            .ruleId(ruleId.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAclRuleArgs].
 */
@PulumiTagMarker
public class WebAclRuleArgsBuilder internal constructor() {
    private var action: Output<WebAclRuleActionArgs>? = null

    private var overrideAction: Output<WebAclRuleOverrideActionArgs>? = null

    private var priority: Output<Int>? = null

    private var ruleId: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The action that CloudFront or AWS WAF takes when a web request matches the conditions in the rule. Not used if `type` is `GROUP`.
     */
    @JvmName("dvoukspcdnseyhlu")
    public suspend fun action(`value`: Output<WebAclRuleActionArgs>) {
        this.action = value
    }

    /**
     * @param value Override the action that a group requests CloudFront or AWS WAF takes when a web request matches the conditions in the rule. Only used if `type` is `GROUP`.
     */
    @JvmName("fjqamymbarudxahc")
    public suspend fun overrideAction(`value`: Output<WebAclRuleOverrideActionArgs>) {
        this.overrideAction = value
    }

    /**
     * @param value Specifies the order in which the rules in a WebACL are evaluated.
     * Rules with a lower value are evaluated before rules with a higher value.
     */
    @JvmName("jwefxtsbsaruymmw")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value ID of the associated WAF (Global) rule (e.g., `aws.waf.Rule`). WAF (Regional) rules cannot be used.
     */
    @JvmName("wspayoitwhhvimwn")
    public suspend fun ruleId(`value`: Output<String>) {
        this.ruleId = value
    }

    /**
     * @param value The rule type, either `REGULAR`, as defined by [Rule](http://docs&#46;aws&#46;amazon&#46;com/waf/latest/APIReference/API_Rule&#46;html), `RATE_BASED`, as defined by [RateBasedRule](http://docs&#46;aws&#46;amazon&#46;com/waf/latest/APIReference/API_RateBasedRule&#46;html), or `GROUP`, as defined by [RuleGroup](https://docs.aws.amazon.com/waf/latest/APIReference/API_RuleGroup.html). The default is REGULAR. If you add a RATE_BASED rule, you need to set `type` as `RATE_BASED`. If you add a GROUP rule, you need to set `type` as `GROUP`.
     */
    @JvmName("ycpeccyyyblydiky")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The action that CloudFront or AWS WAF takes when a web request matches the conditions in the rule. Not used if `type` is `GROUP`.
     */
    @JvmName("hmnjmnbjasjeuwwa")
    public suspend fun action(`value`: WebAclRuleActionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param argument The action that CloudFront or AWS WAF takes when a web request matches the conditions in the rule. Not used if `type` is `GROUP`.
     */
    @JvmName("fduqivfuomglkiyt")
    public suspend fun action(argument: suspend WebAclRuleActionArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleActionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.action = mapped
    }

    /**
     * @param value Override the action that a group requests CloudFront or AWS WAF takes when a web request matches the conditions in the rule. Only used if `type` is `GROUP`.
     */
    @JvmName("tlidwgiibyehexke")
    public suspend fun overrideAction(`value`: WebAclRuleOverrideActionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.overrideAction = mapped
    }

    /**
     * @param argument Override the action that a group requests CloudFront or AWS WAF takes when a web request matches the conditions in the rule. Only used if `type` is `GROUP`.
     */
    @JvmName("ridrdqkhyiggnurv")
    public suspend fun overrideAction(argument: suspend WebAclRuleOverrideActionArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleOverrideActionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.overrideAction = mapped
    }

    /**
     * @param value Specifies the order in which the rules in a WebACL are evaluated.
     * Rules with a lower value are evaluated before rules with a higher value.
     */
    @JvmName("ngppypvfciaxtvab")
    public suspend fun priority(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value ID of the associated WAF (Global) rule (e.g., `aws.waf.Rule`). WAF (Regional) rules cannot be used.
     */
    @JvmName("jutexbnpnojnuanc")
    public suspend fun ruleId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleId = mapped
    }

    /**
     * @param value The rule type, either `REGULAR`, as defined by [Rule](http://docs&#46;aws&#46;amazon&#46;com/waf/latest/APIReference/API_Rule&#46;html), `RATE_BASED`, as defined by [RateBasedRule](http://docs&#46;aws&#46;amazon&#46;com/waf/latest/APIReference/API_RateBasedRule&#46;html), or `GROUP`, as defined by [RuleGroup](https://docs.aws.amazon.com/waf/latest/APIReference/API_RuleGroup.html). The default is REGULAR. If you add a RATE_BASED rule, you need to set `type` as `RATE_BASED`. If you add a GROUP rule, you need to set `type` as `GROUP`.
     */
    @JvmName("kpaxrfyqbwgndygw")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): WebAclRuleArgs = WebAclRuleArgs(
        action = action,
        overrideAction = overrideAction,
        priority = priority ?: throw PulumiNullFieldException("priority"),
        ruleId = ruleId ?: throw PulumiNullFieldException("ruleId"),
        type = type,
    )
}
