@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin.inputs

import com.pulumi.aws.waf.inputs.XssMatchSetXssMatchTupleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property fieldToMatch Specifies where in a web request to look for cross-site scripting attacks.
 * @property textTransformation Text transformations used to eliminate unusual formatting that attackers use in web requests in an effort to bypass AWS WAF.
 * If you specify a transformation, AWS WAF performs the transformation on `target_string` before inspecting a request for a match.
 * e.g., `CMD_LINE`, `HTML_ENTITY_DECODE` or `NONE`.
 * See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_XssMatchTuple.html#WAF-Type-XssMatchTuple-TextTransformation)
 * for all supported values.
 */
public data class XssMatchSetXssMatchTupleArgs(
    public val fieldToMatch: Output<XssMatchSetXssMatchTupleFieldToMatchArgs>,
    public val textTransformation: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.waf.inputs.XssMatchSetXssMatchTupleArgs> {
    override fun toJava(): com.pulumi.aws.waf.inputs.XssMatchSetXssMatchTupleArgs =
        com.pulumi.aws.waf.inputs.XssMatchSetXssMatchTupleArgs.builder()
            .fieldToMatch(fieldToMatch.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .textTransformation(textTransformation.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [XssMatchSetXssMatchTupleArgs].
 */
@PulumiTagMarker
public class XssMatchSetXssMatchTupleArgsBuilder internal constructor() {
    private var fieldToMatch: Output<XssMatchSetXssMatchTupleFieldToMatchArgs>? = null

    private var textTransformation: Output<String>? = null

    /**
     * @param value Specifies where in a web request to look for cross-site scripting attacks.
     */
    @JvmName("gtklaabvcfrsnqgh")
    public suspend fun fieldToMatch(`value`: Output<XssMatchSetXssMatchTupleFieldToMatchArgs>) {
        this.fieldToMatch = value
    }

    /**
     * @param value Text transformations used to eliminate unusual formatting that attackers use in web requests in an effort to bypass AWS WAF.
     * If you specify a transformation, AWS WAF performs the transformation on `target_string` before inspecting a request for a match.
     * e.g., `CMD_LINE`, `HTML_ENTITY_DECODE` or `NONE`.
     * See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_XssMatchTuple.html#WAF-Type-XssMatchTuple-TextTransformation)
     * for all supported values.
     */
    @JvmName("oiphsburjgtlensn")
    public suspend fun textTransformation(`value`: Output<String>) {
        this.textTransformation = value
    }

    /**
     * @param value Specifies where in a web request to look for cross-site scripting attacks.
     */
    @JvmName("fiiprdptncydlrcu")
    public suspend fun fieldToMatch(`value`: XssMatchSetXssMatchTupleFieldToMatchArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fieldToMatch = mapped
    }

    /**
     * @param argument Specifies where in a web request to look for cross-site scripting attacks.
     */
    @JvmName("qffkhxrffaghccnw")
    public suspend fun fieldToMatch(argument: suspend XssMatchSetXssMatchTupleFieldToMatchArgsBuilder.() -> Unit) {
        val toBeMapped = XssMatchSetXssMatchTupleFieldToMatchArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.fieldToMatch = mapped
    }

    /**
     * @param value Text transformations used to eliminate unusual formatting that attackers use in web requests in an effort to bypass AWS WAF.
     * If you specify a transformation, AWS WAF performs the transformation on `target_string` before inspecting a request for a match.
     * e.g., `CMD_LINE`, `HTML_ENTITY_DECODE` or `NONE`.
     * See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_XssMatchTuple.html#WAF-Type-XssMatchTuple-TextTransformation)
     * for all supported values.
     */
    @JvmName("gvxrnvoskcgwcoiq")
    public suspend fun textTransformation(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformation = mapped
    }

    internal fun build(): XssMatchSetXssMatchTupleArgs = XssMatchSetXssMatchTupleArgs(
        fieldToMatch = fieldToMatch ?: throw PulumiNullFieldException("fieldToMatch"),
        textTransformation = textTransformation ?: throw PulumiNullFieldException("textTransformation"),
    )
}
