@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property fieldToMatch The part of a web request that you want to search, such as a specified header or a query string.
 * @property positionalConstraint Within the portion of a web request that you want to search
 * (for example, in the query string, if any), specify where you want to search.
 * e.g., `CONTAINS`, `CONTAINS_WORD` or `EXACTLY`.
 * See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_ByteMatchTuple.html#WAF-Type-ByteMatchTuple-PositionalConstraint)
 * for all supported values.
 * @property targetString The value that you want to search for within the field specified by `field_to_match`, e.g., `badrefer1`.
 * See [docs](https://docs.aws.amazon.com/waf/latest/APIReference/API_waf_ByteMatchTuple.html)
 * for all supported values.
 * @property textTransformation Text transformations used to eliminate unusual formatting that attackers use in web requests in an effort to bypass AWS WAF.
 * If you specify a transformation, AWS WAF performs the transformation on `target_string` before inspecting a request for a match.
 * e.g., `CMD_LINE`, `HTML_ENTITY_DECODE` or `NONE`.
 * See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_ByteMatchTuple.html#WAF-Type-ByteMatchTuple-TextTransformation)
 * for all supported values.
 */
public data class ByteMatchSetByteMatchTuple(
    public val fieldToMatch: ByteMatchSetByteMatchTupleFieldToMatch,
    public val positionalConstraint: String,
    public val targetString: String? = null,
    public val textTransformation: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.waf.outputs.ByteMatchSetByteMatchTuple): ByteMatchSetByteMatchTuple = ByteMatchSetByteMatchTuple(
            fieldToMatch = javaType.fieldToMatch().let({ args0 ->
                com.pulumi.aws.waf.kotlin.outputs.ByteMatchSetByteMatchTupleFieldToMatch.Companion.toKotlin(args0)
            }),
            positionalConstraint = javaType.positionalConstraint(),
            targetString = javaType.targetString().map({ args0 -> args0 }).orElse(null),
            textTransformation = javaType.textTransformation(),
        )
    }
}
