@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property type The type of geographical area you want AWS WAF to search for. Currently Country is the only valid value.
 * @property value The country that you want AWS WAF to search for.
 * This is the two-letter country code, e.g., `US`, `CA`, `RU`, `CN`, etc.
 * See [docs](https://docs.aws.amazon.com/waf/latest/APIReference/API_GeoMatchConstraint.html) for all supported values.
 */
public data class GeoMatchSetGeoMatchConstraint(
    public val type: String,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.waf.outputs.GeoMatchSetGeoMatchConstraint): GeoMatchSetGeoMatchConstraint = GeoMatchSetGeoMatchConstraint(
            type = javaType.type(),
            `value` = javaType.`value`(),
        )
    }
}
