@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getSubscribedRuleGroup.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property metricName
 * @property name
 */
public data class GetSubscribedRuleGroupResult(
    public val id: String,
    public val metricName: String? = null,
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.waf.outputs.GetSubscribedRuleGroupResult): GetSubscribedRuleGroupResult = GetSubscribedRuleGroupResult(
            id = javaType.id(),
            metricName = javaType.metricName().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
