@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property comparisonOperator Type of comparison you want to perform, such as `EQ`, `NE`, `LT`, or `GT`. Please refer to the [documentation](https://docs.aws.amazon.com/waf/latest/APIReference/API_wafRegional_SizeConstraint.html) for a complete list of supported values.
 * @property fieldToMatch Parameter that specifies where in a web request to look for the size constraint.
 * @property size Size in bytes that you want to compare against the size of the specified `field_to_match`. Valid values for `size` are between 0 and 21474836480 bytes (0 and 20 GB).
 * @property textTransformation Parameter is used to eliminate unusual formatting that attackers may use in web requests to bypass AWS WAF. When a transformation is specified, AWS WAF performs the transformation on the `field_to_match` before inspecting the request for a match. Some examples of supported transformations are `CMD_LINE`, `HTML_ENTITY_DECODE`, and `NONE`. You can find a complete list of supported values in the [AWS WAF API Reference](http://docs.aws.amazon.com/waf/latest/APIReference/API_SizeConstraint.html#WAF-Type-SizeConstraint-TextTransformation).
 * **Note:** If you choose `BODY` as the `type`, you must also choose `NONE` because CloudFront only forwards the first 8192 bytes for inspection.
 */
public data class SizeConstraintSetSizeConstraint(
    public val comparisonOperator: String,
    public val fieldToMatch: SizeConstraintSetSizeConstraintFieldToMatch,
    public val size: Int,
    public val textTransformation: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.waf.outputs.SizeConstraintSetSizeConstraint): SizeConstraintSetSizeConstraint = SizeConstraintSetSizeConstraint(
            comparisonOperator = javaType.comparisonOperator(),
            fieldToMatch = javaType.fieldToMatch().let({ args0 ->
                com.pulumi.aws.waf.kotlin.outputs.SizeConstraintSetSizeConstraintFieldToMatch.Companion.toKotlin(args0)
            }),
            size = javaType.size(),
            textTransformation = javaType.textTransformation(),
        )
    }
}
