@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property data When the `type` is `HEADER`, specify the name of the header that you want to search using the `data` field, for example, `User-Agent` or `Referer`. If the `type` is any other value, you can omit this field.
 * @property type Part of the web request that you want AWS WAF to search for a specified string. For example, `HEADER`, `METHOD`, or `BODY`. See the [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_FieldToMatch.html) for all supported values.
 */
public data class SizeConstraintSetSizeConstraintFieldToMatch(
    public val `data`: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.waf.outputs.SizeConstraintSetSizeConstraintFieldToMatch): SizeConstraintSetSizeConstraintFieldToMatch = SizeConstraintSetSizeConstraintFieldToMatch(
            `data` = javaType.`data`().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
