@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.waf.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property action The action that CloudFront or AWS WAF takes when a web request matches the conditions in the rule. Not used if `type` is `GROUP`.
 * @property overrideAction Override the action that a group requests CloudFront or AWS WAF takes when a web request matches the conditions in the rule. Only used if `type` is `GROUP`.
 * @property priority Specifies the order in which the rules in a WebACL are evaluated.
 * Rules with a lower value are evaluated before rules with a higher value.
 * @property ruleId ID of the associated WAF (Global) rule (e.g., `aws.waf.Rule`). WAF (Regional) rules cannot be used.
 * @property type The rule type, either `REGULAR`, as defined by [Rule](http://docs&#46;aws&#46;amazon&#46;com/waf/latest/APIReference/API_Rule&#46;html), `RATE_BASED`, as defined by [RateBasedRule](http://docs&#46;aws&#46;amazon&#46;com/waf/latest/APIReference/API_RateBasedRule&#46;html), or `GROUP`, as defined by [RuleGroup](https://docs.aws.amazon.com/waf/latest/APIReference/API_RuleGroup.html). The default is REGULAR. If you add a RATE_BASED rule, you need to set `type` as `RATE_BASED`. If you add a GROUP rule, you need to set `type` as `GROUP`.
 */
public data class WebAclRule(
    public val action: WebAclRuleAction? = null,
    public val overrideAction: WebAclRuleOverrideAction? = null,
    public val priority: Int,
    public val ruleId: String,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.waf.outputs.WebAclRule): WebAclRule = WebAclRule(
            action = javaType.action().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.waf.kotlin.outputs.WebAclRuleAction.Companion.toKotlin(args0)
                })
            }).orElse(null),
            overrideAction = javaType.overrideAction().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.waf.kotlin.outputs.WebAclRuleOverrideAction.Companion.toKotlin(args0)
                })
            }).orElse(null),
            priority = javaType.priority(),
            ruleId = javaType.ruleId(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
