@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafregional.kotlin

import com.pulumi.aws.wafregional.kotlin.outputs.ByteMatchSetByteMatchTuple
import com.pulumi.aws.wafregional.kotlin.outputs.ByteMatchSetByteMatchTuple.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ByteMatchSet].
 */
@PulumiTagMarker
public class ByteMatchSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ByteMatchSetArgs = ByteMatchSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ByteMatchSetArgsBuilder.() -> Unit) {
        val builder = ByteMatchSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ByteMatchSet {
        val builtJavaResource = com.pulumi.aws.wafregional.ByteMatchSet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ByteMatchSet(builtJavaResource)
    }
}

/**
 * Provides a WAF Regional Byte Match Set Resource for use with Application Load Balancer.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const byteSet = new aws.wafregional.ByteMatchSet("byte_set", {
 *     name: "my_waf_byte_match_set",
 *     byteMatchTuples: [{
 *         textTransformation: "NONE",
 *         targetString: "badrefer1",
 *         positionalConstraint: "CONTAINS",
 *         fieldToMatch: {
 *             type: "HEADER",
 *             data: "referer",
 *         },
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * byte_set = aws.wafregional.ByteMatchSet("byte_set",
 *     name="my_waf_byte_match_set",
 *     byte_match_tuples=[{
 *         "text_transformation": "NONE",
 *         "target_string": "badrefer1",
 *         "positional_constraint": "CONTAINS",
 *         "field_to_match": {
 *             "type": "HEADER",
 *             "data": "referer",
 *         },
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var byteSet = new Aws.WafRegional.ByteMatchSet("byte_set", new()
 *     {
 *         Name = "my_waf_byte_match_set",
 *         ByteMatchTuples = new[]
 *         {
 *             new Aws.WafRegional.Inputs.ByteMatchSetByteMatchTupleArgs
 *             {
 *                 TextTransformation = "NONE",
 *                 TargetString = "badrefer1",
 *                 PositionalConstraint = "CONTAINS",
 *                 FieldToMatch = new Aws.WafRegional.Inputs.ByteMatchSetByteMatchTupleFieldToMatchArgs
 *                 {
 *                     Type = "HEADER",
 *                     Data = "referer",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/wafregional"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := wafregional.NewByteMatchSet(ctx, "byte_set", &wafregional.ByteMatchSetArgs{
 * 			Name: pulumi.String("my_waf_byte_match_set"),
 * 			ByteMatchTuples: wafregional.ByteMatchSetByteMatchTupleArray{
 * 				&wafregional.ByteMatchSetByteMatchTupleArgs{
 * 					TextTransformation:   pulumi.String("NONE"),
 * 					TargetString:         pulumi.String("badrefer1"),
 * 					PositionalConstraint: pulumi.String("CONTAINS"),
 * 					FieldToMatch: &wafregional.ByteMatchSetByteMatchTupleFieldToMatchArgs{
 * 						Type: pulumi.String("HEADER"),
 * 						Data: pulumi.String("referer"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.wafregional.ByteMatchSet;
 * import com.pulumi.aws.wafregional.ByteMatchSetArgs;
 * import com.pulumi.aws.wafregional.inputs.ByteMatchSetByteMatchTupleArgs;
 * import com.pulumi.aws.wafregional.inputs.ByteMatchSetByteMatchTupleFieldToMatchArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var byteSet = new ByteMatchSet("byteSet", ByteMatchSetArgs.builder()
 *             .name("my_waf_byte_match_set")
 *             .byteMatchTuples(ByteMatchSetByteMatchTupleArgs.builder()
 *                 .textTransformation("NONE")
 *                 .targetString("badrefer1")
 *                 .positionalConstraint("CONTAINS")
 *                 .fieldToMatch(ByteMatchSetByteMatchTupleFieldToMatchArgs.builder()
 *                     .type("HEADER")
 *                     .data("referer")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   byteSet:
 *     type: aws:wafregional:ByteMatchSet
 *     name: byte_set
 *     properties:
 *       name: my_waf_byte_match_set
 *       byteMatchTuples:
 *         - textTransformation: NONE
 *           targetString: badrefer1
 *           positionalConstraint: CONTAINS
 *           fieldToMatch:
 *             type: HEADER
 *             data: referer
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import WAF Regional Byte Match Set using the id. For example:
 * ```sh
 * $ pulumi import aws:wafregional/byteMatchSet:ByteMatchSet byte_set a1b2c3d4-d5f6-7777-8888-9999aaaabbbbcccc
 * ```
 */
public class ByteMatchSet internal constructor(
    override val javaResource: com.pulumi.aws.wafregional.ByteMatchSet,
) : KotlinCustomResource(javaResource, ByteMatchSetMapper) {
    /**
     * Settings for the ByteMatchSet, such as the bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF to search for in web requests. ByteMatchTuple documented below.
     */
    public val byteMatchTuples: Output<List<ByteMatchSetByteMatchTuple>>?
        get() = javaResource.byteMatchTuples().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * The name or description of the ByteMatchSet.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })
}

public object ByteMatchSetMapper : ResourceMapper<ByteMatchSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.wafregional.ByteMatchSet::class == javaResource::class

    override fun map(javaResource: Resource): ByteMatchSet = ByteMatchSet(
        javaResource as
            com.pulumi.aws.wafregional.ByteMatchSet,
    )
}

/**
 * @see [ByteMatchSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ByteMatchSet].
 */
public suspend fun byteMatchSet(
    name: String,
    block: suspend ByteMatchSetResourceBuilder.() -> Unit,
): ByteMatchSet {
    val builder = ByteMatchSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ByteMatchSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun byteMatchSet(name: String): ByteMatchSet {
    val builder = ByteMatchSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
