@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafregional.kotlin

import com.pulumi.aws.wafregional.ByteMatchSetArgs.builder
import com.pulumi.aws.wafregional.kotlin.inputs.ByteMatchSetByteMatchTupleArgs
import com.pulumi.aws.wafregional.kotlin.inputs.ByteMatchSetByteMatchTupleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a WAF Regional Byte Match Set Resource for use with Application Load Balancer.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const byteSet = new aws.wafregional.ByteMatchSet("byte_set", {
 *     name: "my_waf_byte_match_set",
 *     byteMatchTuples: [{
 *         textTransformation: "NONE",
 *         targetString: "badrefer1",
 *         positionalConstraint: "CONTAINS",
 *         fieldToMatch: {
 *             type: "HEADER",
 *             data: "referer",
 *         },
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * byte_set = aws.wafregional.ByteMatchSet("byte_set",
 *     name="my_waf_byte_match_set",
 *     byte_match_tuples=[{
 *         "text_transformation": "NONE",
 *         "target_string": "badrefer1",
 *         "positional_constraint": "CONTAINS",
 *         "field_to_match": {
 *             "type": "HEADER",
 *             "data": "referer",
 *         },
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var byteSet = new Aws.WafRegional.ByteMatchSet("byte_set", new()
 *     {
 *         Name = "my_waf_byte_match_set",
 *         ByteMatchTuples = new[]
 *         {
 *             new Aws.WafRegional.Inputs.ByteMatchSetByteMatchTupleArgs
 *             {
 *                 TextTransformation = "NONE",
 *                 TargetString = "badrefer1",
 *                 PositionalConstraint = "CONTAINS",
 *                 FieldToMatch = new Aws.WafRegional.Inputs.ByteMatchSetByteMatchTupleFieldToMatchArgs
 *                 {
 *                     Type = "HEADER",
 *                     Data = "referer",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/wafregional"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := wafregional.NewByteMatchSet(ctx, "byte_set", &wafregional.ByteMatchSetArgs{
 * 			Name: pulumi.String("my_waf_byte_match_set"),
 * 			ByteMatchTuples: wafregional.ByteMatchSetByteMatchTupleArray{
 * 				&wafregional.ByteMatchSetByteMatchTupleArgs{
 * 					TextTransformation:   pulumi.String("NONE"),
 * 					TargetString:         pulumi.String("badrefer1"),
 * 					PositionalConstraint: pulumi.String("CONTAINS"),
 * 					FieldToMatch: &wafregional.ByteMatchSetByteMatchTupleFieldToMatchArgs{
 * 						Type: pulumi.String("HEADER"),
 * 						Data: pulumi.String("referer"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.wafregional.ByteMatchSet;
 * import com.pulumi.aws.wafregional.ByteMatchSetArgs;
 * import com.pulumi.aws.wafregional.inputs.ByteMatchSetByteMatchTupleArgs;
 * import com.pulumi.aws.wafregional.inputs.ByteMatchSetByteMatchTupleFieldToMatchArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var byteSet = new ByteMatchSet("byteSet", ByteMatchSetArgs.builder()
 *             .name("my_waf_byte_match_set")
 *             .byteMatchTuples(ByteMatchSetByteMatchTupleArgs.builder()
 *                 .textTransformation("NONE")
 *                 .targetString("badrefer1")
 *                 .positionalConstraint("CONTAINS")
 *                 .fieldToMatch(ByteMatchSetByteMatchTupleFieldToMatchArgs.builder()
 *                     .type("HEADER")
 *                     .data("referer")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   byteSet:
 *     type: aws:wafregional:ByteMatchSet
 *     name: byte_set
 *     properties:
 *       name: my_waf_byte_match_set
 *       byteMatchTuples:
 *         - textTransformation: NONE
 *           targetString: badrefer1
 *           positionalConstraint: CONTAINS
 *           fieldToMatch:
 *             type: HEADER
 *             data: referer
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import WAF Regional Byte Match Set using the id. For example:
 * ```sh
 * $ pulumi import aws:wafregional/byteMatchSet:ByteMatchSet byte_set a1b2c3d4-d5f6-7777-8888-9999aaaabbbbcccc
 * ```
 * @property byteMatchTuples Settings for the ByteMatchSet, such as the bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF to search for in web requests. ByteMatchTuple documented below.
 * @property name The name or description of the ByteMatchSet.
 */
public data class ByteMatchSetArgs(
    public val byteMatchTuples: Output<List<ByteMatchSetByteMatchTupleArgs>>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafregional.ByteMatchSetArgs> {
    override fun toJava(): com.pulumi.aws.wafregional.ByteMatchSetArgs =
        com.pulumi.aws.wafregional.ByteMatchSetArgs.builder()
            .byteMatchTuples(
                byteMatchTuples?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ByteMatchSetArgs].
 */
@PulumiTagMarker
public class ByteMatchSetArgsBuilder internal constructor() {
    private var byteMatchTuples: Output<List<ByteMatchSetByteMatchTupleArgs>>? = null

    private var name: Output<String>? = null

    /**
     * @param value Settings for the ByteMatchSet, such as the bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF to search for in web requests. ByteMatchTuple documented below.
     */
    @JvmName("pvegkvsbtrosimnw")
    public suspend fun byteMatchTuples(`value`: Output<List<ByteMatchSetByteMatchTupleArgs>>) {
        this.byteMatchTuples = value
    }

    @JvmName("oymsuojmmijjnkno")
    public suspend fun byteMatchTuples(vararg values: Output<ByteMatchSetByteMatchTupleArgs>) {
        this.byteMatchTuples = Output.all(values.asList())
    }

    /**
     * @param values Settings for the ByteMatchSet, such as the bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF to search for in web requests. ByteMatchTuple documented below.
     */
    @JvmName("wnhhikdhynxivunb")
    public suspend fun byteMatchTuples(values: List<Output<ByteMatchSetByteMatchTupleArgs>>) {
        this.byteMatchTuples = Output.all(values)
    }

    /**
     * @param value The name or description of the ByteMatchSet.
     */
    @JvmName("tdrulpxsewqcibve")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Settings for the ByteMatchSet, such as the bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF to search for in web requests. ByteMatchTuple documented below.
     */
    @JvmName("uneccairnqdvgpjb")
    public suspend fun byteMatchTuples(`value`: List<ByteMatchSetByteMatchTupleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.byteMatchTuples = mapped
    }

    /**
     * @param argument Settings for the ByteMatchSet, such as the bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF to search for in web requests. ByteMatchTuple documented below.
     */
    @JvmName("kdpwnyxapwimyhmm")
    public suspend fun byteMatchTuples(argument: List<suspend ByteMatchSetByteMatchTupleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ByteMatchSetByteMatchTupleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.byteMatchTuples = mapped
    }

    /**
     * @param argument Settings for the ByteMatchSet, such as the bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF to search for in web requests. ByteMatchTuple documented below.
     */
    @JvmName("sgvtxatcuauiybyi")
    public suspend fun byteMatchTuples(vararg argument: suspend ByteMatchSetByteMatchTupleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ByteMatchSetByteMatchTupleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.byteMatchTuples = mapped
    }

    /**
     * @param argument Settings for the ByteMatchSet, such as the bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF to search for in web requests. ByteMatchTuple documented below.
     */
    @JvmName("jlppetiqhodttfto")
    public suspend fun byteMatchTuples(argument: suspend ByteMatchSetByteMatchTupleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ByteMatchSetByteMatchTupleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.byteMatchTuples = mapped
    }

    /**
     * @param values Settings for the ByteMatchSet, such as the bytes (typically a string that corresponds with ASCII characters) that you want AWS WAF to search for in web requests. ByteMatchTuple documented below.
     */
    @JvmName("jfsmyauqmtgffwox")
    public suspend fun byteMatchTuples(vararg values: ByteMatchSetByteMatchTupleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.byteMatchTuples = mapped
    }

    /**
     * @param value The name or description of the ByteMatchSet.
     */
    @JvmName("peycevqcsxhpadpr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ByteMatchSetArgs = ByteMatchSetArgs(
        byteMatchTuples = byteMatchTuples,
        name = name,
    )
}
