@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafregional.kotlin

import com.pulumi.aws.wafregional.IpSetArgs.builder
import com.pulumi.aws.wafregional.kotlin.inputs.IpSetIpSetDescriptorArgs
import com.pulumi.aws.wafregional.kotlin.inputs.IpSetIpSetDescriptorArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a WAF Regional IPSet Resource for use with Application Load Balancer.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const ipset = new aws.wafregional.IpSet("ipset", {
 *     name: "tfIPSet",
 *     ipSetDescriptors: [
 *         {
 *             type: "IPV4",
 *             value: "192.0.7.0/24",
 *         },
 *         {
 *             type: "IPV4",
 *             value: "10.16.16.0/16",
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * ipset = aws.wafregional.IpSet("ipset",
 *     name="tfIPSet",
 *     ip_set_descriptors=[
 *         {
 *             "type": "IPV4",
 *             "value": "192.0.7.0/24",
 *         },
 *         {
 *             "type": "IPV4",
 *             "value": "10.16.16.0/16",
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ipset = new Aws.WafRegional.IpSet("ipset", new()
 *     {
 *         Name = "tfIPSet",
 *         IpSetDescriptors = new[]
 *         {
 *             new Aws.WafRegional.Inputs.IpSetIpSetDescriptorArgs
 *             {
 *                 Type = "IPV4",
 *                 Value = "192.0.7.0/24",
 *             },
 *             new Aws.WafRegional.Inputs.IpSetIpSetDescriptorArgs
 *             {
 *                 Type = "IPV4",
 *                 Value = "10.16.16.0/16",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/wafregional"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := wafregional.NewIpSet(ctx, "ipset", &wafregional.IpSetArgs{
 * 			Name: pulumi.String("tfIPSet"),
 * 			IpSetDescriptors: wafregional.IpSetIpSetDescriptorArray{
 * 				&wafregional.IpSetIpSetDescriptorArgs{
 * 					Type:  pulumi.String("IPV4"),
 * 					Value: pulumi.String("192.0.7.0/24"),
 * 				},
 * 				&wafregional.IpSetIpSetDescriptorArgs{
 * 					Type:  pulumi.String("IPV4"),
 * 					Value: pulumi.String("10.16.16.0/16"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.wafregional.IpSet;
 * import com.pulumi.aws.wafregional.IpSetArgs;
 * import com.pulumi.aws.wafregional.inputs.IpSetIpSetDescriptorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ipset = new IpSet("ipset", IpSetArgs.builder()
 *             .name("tfIPSet")
 *             .ipSetDescriptors(
 *                 IpSetIpSetDescriptorArgs.builder()
 *                     .type("IPV4")
 *                     .value("192.0.7.0/24")
 *                     .build(),
 *                 IpSetIpSetDescriptorArgs.builder()
 *                     .type("IPV4")
 *                     .value("10.16.16.0/16")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   ipset:
 *     type: aws:wafregional:IpSet
 *     properties:
 *       name: tfIPSet
 *       ipSetDescriptors:
 *         - type: IPV4
 *           value: 192.0.7.0/24
 *         - type: IPV4
 *           value: 10.16.16.0/16
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import WAF Regional IPSets using their ID. For example:
 * ```sh
 * $ pulumi import aws:wafregional/ipSet:IpSet example a1b2c3d4-d5f6-7777-8888-9999aaaabbbbcccc
 * ```
 * @property ipSetDescriptors One or more pairs specifying the IP address type (IPV4 or IPV6) and the IP address range (in CIDR notation) from which web requests originate.
 * @property name The name or description of the IPSet.
 */
public data class IpSetArgs(
    public val ipSetDescriptors: Output<List<IpSetIpSetDescriptorArgs>>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafregional.IpSetArgs> {
    override fun toJava(): com.pulumi.aws.wafregional.IpSetArgs =
        com.pulumi.aws.wafregional.IpSetArgs.builder()
            .ipSetDescriptors(
                ipSetDescriptors?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IpSetArgs].
 */
@PulumiTagMarker
public class IpSetArgsBuilder internal constructor() {
    private var ipSetDescriptors: Output<List<IpSetIpSetDescriptorArgs>>? = null

    private var name: Output<String>? = null

    /**
     * @param value One or more pairs specifying the IP address type (IPV4 or IPV6) and the IP address range (in CIDR notation) from which web requests originate.
     */
    @JvmName("iwyjsnveeysmxnoh")
    public suspend fun ipSetDescriptors(`value`: Output<List<IpSetIpSetDescriptorArgs>>) {
        this.ipSetDescriptors = value
    }

    @JvmName("xqccujxpdyvfhlnr")
    public suspend fun ipSetDescriptors(vararg values: Output<IpSetIpSetDescriptorArgs>) {
        this.ipSetDescriptors = Output.all(values.asList())
    }

    /**
     * @param values One or more pairs specifying the IP address type (IPV4 or IPV6) and the IP address range (in CIDR notation) from which web requests originate.
     */
    @JvmName("wthbrnskuvwojtup")
    public suspend fun ipSetDescriptors(values: List<Output<IpSetIpSetDescriptorArgs>>) {
        this.ipSetDescriptors = Output.all(values)
    }

    /**
     * @param value The name or description of the IPSet.
     */
    @JvmName("tbxqrncnrhdtobyh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value One or more pairs specifying the IP address type (IPV4 or IPV6) and the IP address range (in CIDR notation) from which web requests originate.
     */
    @JvmName("kierrcanjlovheue")
    public suspend fun ipSetDescriptors(`value`: List<IpSetIpSetDescriptorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipSetDescriptors = mapped
    }

    /**
     * @param argument One or more pairs specifying the IP address type (IPV4 or IPV6) and the IP address range (in CIDR notation) from which web requests originate.
     */
    @JvmName("gxvywhppytpyfwnb")
    public suspend fun ipSetDescriptors(argument: List<suspend IpSetIpSetDescriptorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IpSetIpSetDescriptorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipSetDescriptors = mapped
    }

    /**
     * @param argument One or more pairs specifying the IP address type (IPV4 or IPV6) and the IP address range (in CIDR notation) from which web requests originate.
     */
    @JvmName("fghydatgcghhtvwb")
    public suspend fun ipSetDescriptors(vararg argument: suspend IpSetIpSetDescriptorArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            IpSetIpSetDescriptorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipSetDescriptors = mapped
    }

    /**
     * @param argument One or more pairs specifying the IP address type (IPV4 or IPV6) and the IP address range (in CIDR notation) from which web requests originate.
     */
    @JvmName("bccvonwgdpodiqct")
    public suspend fun ipSetDescriptors(argument: suspend IpSetIpSetDescriptorArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IpSetIpSetDescriptorArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipSetDescriptors = mapped
    }

    /**
     * @param values One or more pairs specifying the IP address type (IPV4 or IPV6) and the IP address range (in CIDR notation) from which web requests originate.
     */
    @JvmName("vvenwqcmtsbduorn")
    public suspend fun ipSetDescriptors(vararg values: IpSetIpSetDescriptorArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipSetDescriptors = mapped
    }

    /**
     * @param value The name or description of the IPSet.
     */
    @JvmName("otsfsjfsgmwebhiu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): IpSetArgs = IpSetArgs(
        ipSetDescriptors = ipSetDescriptors,
        name = name,
    )
}
