@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafregional.kotlin

import com.pulumi.aws.wafregional.RegexMatchSetArgs.builder
import com.pulumi.aws.wafregional.kotlin.inputs.RegexMatchSetRegexMatchTupleArgs
import com.pulumi.aws.wafregional.kotlin.inputs.RegexMatchSetRegexMatchTupleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a WAF Regional Regex Match Set Resource
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleRegexPatternSet = new aws.wafregional.RegexPatternSet("example", {
 *     name: "example",
 *     regexPatternStrings: [
 *         "one",
 *         "two",
 *     ],
 * });
 * const example = new aws.wafregional.RegexMatchSet("example", {
 *     name: "example",
 *     regexMatchTuples: [{
 *         fieldToMatch: {
 *             data: "User-Agent",
 *             type: "HEADER",
 *         },
 *         regexPatternSetId: exampleRegexPatternSet.id,
 *         textTransformation: "NONE",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_regex_pattern_set = aws.wafregional.RegexPatternSet("example",
 *     name="example",
 *     regex_pattern_strings=[
 *         "one",
 *         "two",
 *     ])
 * example = aws.wafregional.RegexMatchSet("example",
 *     name="example",
 *     regex_match_tuples=[{
 *         "field_to_match": {
 *             "data": "User-Agent",
 *             "type": "HEADER",
 *         },
 *         "regex_pattern_set_id": example_regex_pattern_set.id,
 *         "text_transformation": "NONE",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleRegexPatternSet = new Aws.WafRegional.RegexPatternSet("example", new()
 *     {
 *         Name = "example",
 *         RegexPatternStrings = new[]
 *         {
 *             "one",
 *             "two",
 *         },
 *     });
 *     var example = new Aws.WafRegional.RegexMatchSet("example", new()
 *     {
 *         Name = "example",
 *         RegexMatchTuples = new[]
 *         {
 *             new Aws.WafRegional.Inputs.RegexMatchSetRegexMatchTupleArgs
 *             {
 *                 FieldToMatch = new Aws.WafRegional.Inputs.RegexMatchSetRegexMatchTupleFieldToMatchArgs
 *                 {
 *                     Data = "User-Agent",
 *                     Type = "HEADER",
 *                 },
 *                 RegexPatternSetId = exampleRegexPatternSet.Id,
 *                 TextTransformation = "NONE",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/wafregional"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		exampleRegexPatternSet, err := wafregional.NewRegexPatternSet(ctx, "example", &wafregional.RegexPatternSetArgs{
 * 			Name: pulumi.String("example"),
 * 			RegexPatternStrings: pulumi.StringArray{
 * 				pulumi.String("one"),
 * 				pulumi.String("two"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = wafregional.NewRegexMatchSet(ctx, "example", &wafregional.RegexMatchSetArgs{
 * 			Name: pulumi.String("example"),
 * 			RegexMatchTuples: wafregional.RegexMatchSetRegexMatchTupleArray{
 * 				&wafregional.RegexMatchSetRegexMatchTupleArgs{
 * 					FieldToMatch: &wafregional.RegexMatchSetRegexMatchTupleFieldToMatchArgs{
 * 						Data: pulumi.String("User-Agent"),
 * 						Type: pulumi.String("HEADER"),
 * 					},
 * 					RegexPatternSetId:  exampleRegexPatternSet.ID(),
 * 					TextTransformation: pulumi.String("NONE"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.wafregional.RegexPatternSet;
 * import com.pulumi.aws.wafregional.RegexPatternSetArgs;
 * import com.pulumi.aws.wafregional.RegexMatchSet;
 * import com.pulumi.aws.wafregional.RegexMatchSetArgs;
 * import com.pulumi.aws.wafregional.inputs.RegexMatchSetRegexMatchTupleArgs;
 * import com.pulumi.aws.wafregional.inputs.RegexMatchSetRegexMatchTupleFieldToMatchArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleRegexPatternSet = new RegexPatternSet("exampleRegexPatternSet", RegexPatternSetArgs.builder()
 *             .name("example")
 *             .regexPatternStrings(
 *                 "one",
 *                 "two")
 *             .build());
 *         var example = new RegexMatchSet("example", RegexMatchSetArgs.builder()
 *             .name("example")
 *             .regexMatchTuples(RegexMatchSetRegexMatchTupleArgs.builder()
 *                 .fieldToMatch(RegexMatchSetRegexMatchTupleFieldToMatchArgs.builder()
 *                     .data("User-Agent")
 *                     .type("HEADER")
 *                     .build())
 *                 .regexPatternSetId(exampleRegexPatternSet.id())
 *                 .textTransformation("NONE")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:wafregional:RegexMatchSet
 *     properties:
 *       name: example
 *       regexMatchTuples:
 *         - fieldToMatch:
 *             data: User-Agent
 *             type: HEADER
 *           regexPatternSetId: ${exampleRegexPatternSet.id}
 *           textTransformation: NONE
 *   exampleRegexPatternSet:
 *     type: aws:wafregional:RegexPatternSet
 *     name: example
 *     properties:
 *       name: example
 *       regexPatternStrings:
 *         - one
 *         - two
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import WAF Regional Regex Match Set using the id. For example:
 * ```sh
 * $ pulumi import aws:wafregional/regexMatchSet:RegexMatchSet example a1b2c3d4-d5f6-7777-8888-9999aaaabbbbcccc
 * ```
 * @property name The name or description of the Regex Match Set.
 * @property regexMatchTuples The regular expression pattern that you want AWS WAF to search for in web requests, the location in requests that you want AWS WAF to search, and other settings. See below.
 */
public data class RegexMatchSetArgs(
    public val name: Output<String>? = null,
    public val regexMatchTuples: Output<List<RegexMatchSetRegexMatchTupleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafregional.RegexMatchSetArgs> {
    override fun toJava(): com.pulumi.aws.wafregional.RegexMatchSetArgs =
        com.pulumi.aws.wafregional.RegexMatchSetArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .regexMatchTuples(
                regexMatchTuples?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RegexMatchSetArgs].
 */
@PulumiTagMarker
public class RegexMatchSetArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var regexMatchTuples: Output<List<RegexMatchSetRegexMatchTupleArgs>>? = null

    /**
     * @param value The name or description of the Regex Match Set.
     */
    @JvmName("wdjritbqdgbatdbx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The regular expression pattern that you want AWS WAF to search for in web requests, the location in requests that you want AWS WAF to search, and other settings. See below.
     */
    @JvmName("phgumlabdyxqewev")
    public suspend fun regexMatchTuples(`value`: Output<List<RegexMatchSetRegexMatchTupleArgs>>) {
        this.regexMatchTuples = value
    }

    @JvmName("teesegcebhxjeiyb")
    public suspend fun regexMatchTuples(vararg values: Output<RegexMatchSetRegexMatchTupleArgs>) {
        this.regexMatchTuples = Output.all(values.asList())
    }

    /**
     * @param values The regular expression pattern that you want AWS WAF to search for in web requests, the location in requests that you want AWS WAF to search, and other settings. See below.
     */
    @JvmName("lcnfmpxmevppfmgu")
    public suspend fun regexMatchTuples(values: List<Output<RegexMatchSetRegexMatchTupleArgs>>) {
        this.regexMatchTuples = Output.all(values)
    }

    /**
     * @param value The name or description of the Regex Match Set.
     */
    @JvmName("rmbgcygxkivdqfnu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The regular expression pattern that you want AWS WAF to search for in web requests, the location in requests that you want AWS WAF to search, and other settings. See below.
     */
    @JvmName("rsrcpkgruooqjjyn")
    public suspend fun regexMatchTuples(`value`: List<RegexMatchSetRegexMatchTupleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regexMatchTuples = mapped
    }

    /**
     * @param argument The regular expression pattern that you want AWS WAF to search for in web requests, the location in requests that you want AWS WAF to search, and other settings. See below.
     */
    @JvmName("emeohctfojekxnmg")
    public suspend fun regexMatchTuples(argument: List<suspend RegexMatchSetRegexMatchTupleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RegexMatchSetRegexMatchTupleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.regexMatchTuples = mapped
    }

    /**
     * @param argument The regular expression pattern that you want AWS WAF to search for in web requests, the location in requests that you want AWS WAF to search, and other settings. See below.
     */
    @JvmName("laqjwagcrjpuhidg")
    public suspend fun regexMatchTuples(vararg argument: suspend RegexMatchSetRegexMatchTupleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RegexMatchSetRegexMatchTupleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.regexMatchTuples = mapped
    }

    /**
     * @param argument The regular expression pattern that you want AWS WAF to search for in web requests, the location in requests that you want AWS WAF to search, and other settings. See below.
     */
    @JvmName("bcacliyiskqrmjwt")
    public suspend fun regexMatchTuples(argument: suspend RegexMatchSetRegexMatchTupleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RegexMatchSetRegexMatchTupleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.regexMatchTuples = mapped
    }

    /**
     * @param values The regular expression pattern that you want AWS WAF to search for in web requests, the location in requests that you want AWS WAF to search, and other settings. See below.
     */
    @JvmName("ilqoevfdvajwandn")
    public suspend fun regexMatchTuples(vararg values: RegexMatchSetRegexMatchTupleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regexMatchTuples = mapped
    }

    internal fun build(): RegexMatchSetArgs = RegexMatchSetArgs(
        name = name,
        regexMatchTuples = regexMatchTuples,
    )
}
