@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafregional.kotlin

import com.pulumi.aws.wafregional.RegexPatternSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a WAF Regional Regex Pattern Set Resource
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.wafregional.RegexPatternSet("example", {
 *     name: "example",
 *     regexPatternStrings: [
 *         "one",
 *         "two",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.wafregional.RegexPatternSet("example",
 *     name="example",
 *     regex_pattern_strings=[
 *         "one",
 *         "two",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.WafRegional.RegexPatternSet("example", new()
 *     {
 *         Name = "example",
 *         RegexPatternStrings = new[]
 *         {
 *             "one",
 *             "two",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/wafregional"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := wafregional.NewRegexPatternSet(ctx, "example", &wafregional.RegexPatternSetArgs{
 * 			Name: pulumi.String("example"),
 * 			RegexPatternStrings: pulumi.StringArray{
 * 				pulumi.String("one"),
 * 				pulumi.String("two"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.wafregional.RegexPatternSet;
 * import com.pulumi.aws.wafregional.RegexPatternSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RegexPatternSet("example", RegexPatternSetArgs.builder()
 *             .name("example")
 *             .regexPatternStrings(
 *                 "one",
 *                 "two")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:wafregional:RegexPatternSet
 *     properties:
 *       name: example
 *       regexPatternStrings:
 *         - one
 *         - two
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import WAF Regional Regex Pattern Set using the id. For example:
 * ```sh
 * $ pulumi import aws:wafregional/regexPatternSet:RegexPatternSet example a1b2c3d4-d5f6-7777-8888-9999aaaabbbbcccc
 * ```
 * @property name The name or description of the Regex Pattern Set.
 * @property regexPatternStrings A list of regular expression (regex) patterns that you want AWS WAF to search for, such as `B[a@]dB[o0]t`.
 */
public data class RegexPatternSetArgs(
    public val name: Output<String>? = null,
    public val regexPatternStrings: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafregional.RegexPatternSetArgs> {
    override fun toJava(): com.pulumi.aws.wafregional.RegexPatternSetArgs =
        com.pulumi.aws.wafregional.RegexPatternSetArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .regexPatternStrings(
                regexPatternStrings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [RegexPatternSetArgs].
 */
@PulumiTagMarker
public class RegexPatternSetArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var regexPatternStrings: Output<List<String>>? = null

    /**
     * @param value The name or description of the Regex Pattern Set.
     */
    @JvmName("okqyjeudhvsbaytu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A list of regular expression (regex) patterns that you want AWS WAF to search for, such as `B[a@]dB[o0]t`.
     */
    @JvmName("vclsbjioaviprlwt")
    public suspend fun regexPatternStrings(`value`: Output<List<String>>) {
        this.regexPatternStrings = value
    }

    @JvmName("ujmlntslflqvfcum")
    public suspend fun regexPatternStrings(vararg values: Output<String>) {
        this.regexPatternStrings = Output.all(values.asList())
    }

    /**
     * @param values A list of regular expression (regex) patterns that you want AWS WAF to search for, such as `B[a@]dB[o0]t`.
     */
    @JvmName("gmvvrktogsikskqj")
    public suspend fun regexPatternStrings(values: List<Output<String>>) {
        this.regexPatternStrings = Output.all(values)
    }

    /**
     * @param value The name or description of the Regex Pattern Set.
     */
    @JvmName("shdlvfjcxjurlymp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A list of regular expression (regex) patterns that you want AWS WAF to search for, such as `B[a@]dB[o0]t`.
     */
    @JvmName("tfaquthjncdhktjq")
    public suspend fun regexPatternStrings(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regexPatternStrings = mapped
    }

    /**
     * @param values A list of regular expression (regex) patterns that you want AWS WAF to search for, such as `B[a@]dB[o0]t`.
     */
    @JvmName("oomtcrudluewsowe")
    public suspend fun regexPatternStrings(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regexPatternStrings = mapped
    }

    internal fun build(): RegexPatternSetArgs = RegexPatternSetArgs(
        name = name,
        regexPatternStrings = regexPatternStrings,
    )
}
