@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafregional.kotlin

import com.pulumi.aws.wafregional.SizeConstraintSetArgs.builder
import com.pulumi.aws.wafregional.kotlin.inputs.SizeConstraintSetSizeConstraintArgs
import com.pulumi.aws.wafregional.kotlin.inputs.SizeConstraintSetSizeConstraintArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a WAF Regional Size Constraint Set Resource for use with Application Load Balancer.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const sizeConstraintSet = new aws.wafregional.SizeConstraintSet("size_constraint_set", {
 *     name: "tfsize_constraints",
 *     sizeConstraints: [{
 *         textTransformation: "NONE",
 *         comparisonOperator: "EQ",
 *         size: 4096,
 *         fieldToMatch: {
 *             type: "BODY",
 *         },
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * size_constraint_set = aws.wafregional.SizeConstraintSet("size_constraint_set",
 *     name="tfsize_constraints",
 *     size_constraints=[{
 *         "text_transformation": "NONE",
 *         "comparison_operator": "EQ",
 *         "size": 4096,
 *         "field_to_match": {
 *             "type": "BODY",
 *         },
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sizeConstraintSet = new Aws.WafRegional.SizeConstraintSet("size_constraint_set", new()
 *     {
 *         Name = "tfsize_constraints",
 *         SizeConstraints = new[]
 *         {
 *             new Aws.WafRegional.Inputs.SizeConstraintSetSizeConstraintArgs
 *             {
 *                 TextTransformation = "NONE",
 *                 ComparisonOperator = "EQ",
 *                 Size = 4096,
 *                 FieldToMatch = new Aws.WafRegional.Inputs.SizeConstraintSetSizeConstraintFieldToMatchArgs
 *                 {
 *                     Type = "BODY",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/wafregional"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := wafregional.NewSizeConstraintSet(ctx, "size_constraint_set", &wafregional.SizeConstraintSetArgs{
 * 			Name: pulumi.String("tfsize_constraints"),
 * 			SizeConstraints: wafregional.SizeConstraintSetSizeConstraintArray{
 * 				&wafregional.SizeConstraintSetSizeConstraintArgs{
 * 					TextTransformation: pulumi.String("NONE"),
 * 					ComparisonOperator: pulumi.String("EQ"),
 * 					Size:               pulumi.Int(4096),
 * 					FieldToMatch: &wafregional.SizeConstraintSetSizeConstraintFieldToMatchArgs{
 * 						Type: pulumi.String("BODY"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.wafregional.SizeConstraintSet;
 * import com.pulumi.aws.wafregional.SizeConstraintSetArgs;
 * import com.pulumi.aws.wafregional.inputs.SizeConstraintSetSizeConstraintArgs;
 * import com.pulumi.aws.wafregional.inputs.SizeConstraintSetSizeConstraintFieldToMatchArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sizeConstraintSet = new SizeConstraintSet("sizeConstraintSet", SizeConstraintSetArgs.builder()
 *             .name("tfsize_constraints")
 *             .sizeConstraints(SizeConstraintSetSizeConstraintArgs.builder()
 *                 .textTransformation("NONE")
 *                 .comparisonOperator("EQ")
 *                 .size("4096")
 *                 .fieldToMatch(SizeConstraintSetSizeConstraintFieldToMatchArgs.builder()
 *                     .type("BODY")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   sizeConstraintSet:
 *     type: aws:wafregional:SizeConstraintSet
 *     name: size_constraint_set
 *     properties:
 *       name: tfsize_constraints
 *       sizeConstraints:
 *         - textTransformation: NONE
 *           comparisonOperator: EQ
 *           size: '4096'
 *           fieldToMatch:
 *             type: BODY
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import WAF Size Constraint Set using the id. For example:
 * ```sh
 * $ pulumi import aws:wafregional/sizeConstraintSet:SizeConstraintSet size_constraint_set a1b2c3d4-d5f6-7777-8888-9999aaaabbbbcccc
 * ```
 * @property name The name or description of the Size Constraint Set.
 * @property sizeConstraints Specifies the parts of web requests that you want to inspect the size of.
 */
public data class SizeConstraintSetArgs(
    public val name: Output<String>? = null,
    public val sizeConstraints: Output<List<SizeConstraintSetSizeConstraintArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafregional.SizeConstraintSetArgs> {
    override fun toJava(): com.pulumi.aws.wafregional.SizeConstraintSetArgs =
        com.pulumi.aws.wafregional.SizeConstraintSetArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .sizeConstraints(
                sizeConstraints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SizeConstraintSetArgs].
 */
@PulumiTagMarker
public class SizeConstraintSetArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var sizeConstraints: Output<List<SizeConstraintSetSizeConstraintArgs>>? = null

    /**
     * @param value The name or description of the Size Constraint Set.
     */
    @JvmName("tttjklkysmmrloux")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies the parts of web requests that you want to inspect the size of.
     */
    @JvmName("nwsoiojyuqbupism")
    public suspend fun sizeConstraints(`value`: Output<List<SizeConstraintSetSizeConstraintArgs>>) {
        this.sizeConstraints = value
    }

    @JvmName("uilxqnrdevburjby")
    public suspend fun sizeConstraints(vararg values: Output<SizeConstraintSetSizeConstraintArgs>) {
        this.sizeConstraints = Output.all(values.asList())
    }

    /**
     * @param values Specifies the parts of web requests that you want to inspect the size of.
     */
    @JvmName("xlipxgcbeatssapf")
    public suspend fun sizeConstraints(values: List<Output<SizeConstraintSetSizeConstraintArgs>>) {
        this.sizeConstraints = Output.all(values)
    }

    /**
     * @param value The name or description of the Size Constraint Set.
     */
    @JvmName("wfxycxipeaqsmfld")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies the parts of web requests that you want to inspect the size of.
     */
    @JvmName("sgtdcowdescelbcs")
    public suspend fun sizeConstraints(`value`: List<SizeConstraintSetSizeConstraintArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sizeConstraints = mapped
    }

    /**
     * @param argument Specifies the parts of web requests that you want to inspect the size of.
     */
    @JvmName("xfqklvnsvjpqtaoh")
    public suspend fun sizeConstraints(argument: List<suspend SizeConstraintSetSizeConstraintArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SizeConstraintSetSizeConstraintArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sizeConstraints = mapped
    }

    /**
     * @param argument Specifies the parts of web requests that you want to inspect the size of.
     */
    @JvmName("slkxfcojuvpgguuk")
    public suspend fun sizeConstraints(vararg argument: suspend SizeConstraintSetSizeConstraintArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SizeConstraintSetSizeConstraintArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sizeConstraints = mapped
    }

    /**
     * @param argument Specifies the parts of web requests that you want to inspect the size of.
     */
    @JvmName("wgeunfrtnaorrpcl")
    public suspend fun sizeConstraints(argument: suspend SizeConstraintSetSizeConstraintArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            SizeConstraintSetSizeConstraintArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.sizeConstraints = mapped
    }

    /**
     * @param values Specifies the parts of web requests that you want to inspect the size of.
     */
    @JvmName("cojhkurqsyucuxad")
    public suspend fun sizeConstraints(vararg values: SizeConstraintSetSizeConstraintArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sizeConstraints = mapped
    }

    internal fun build(): SizeConstraintSetArgs = SizeConstraintSetArgs(
        name = name,
        sizeConstraints = sizeConstraints,
    )
}
