@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafregional.kotlin

import com.pulumi.aws.wafregional.WafregionalFunctions.getIpsetPlain
import com.pulumi.aws.wafregional.WafregionalFunctions.getRateBasedModPlain
import com.pulumi.aws.wafregional.WafregionalFunctions.getRulePlain
import com.pulumi.aws.wafregional.WafregionalFunctions.getSubscribedRuleGroupPlain
import com.pulumi.aws.wafregional.WafregionalFunctions.getWebAclPlain
import com.pulumi.aws.wafregional.kotlin.inputs.GetIpsetPlainArgs
import com.pulumi.aws.wafregional.kotlin.inputs.GetIpsetPlainArgsBuilder
import com.pulumi.aws.wafregional.kotlin.inputs.GetRateBasedModPlainArgs
import com.pulumi.aws.wafregional.kotlin.inputs.GetRateBasedModPlainArgsBuilder
import com.pulumi.aws.wafregional.kotlin.inputs.GetRulePlainArgs
import com.pulumi.aws.wafregional.kotlin.inputs.GetRulePlainArgsBuilder
import com.pulumi.aws.wafregional.kotlin.inputs.GetSubscribedRuleGroupPlainArgs
import com.pulumi.aws.wafregional.kotlin.inputs.GetSubscribedRuleGroupPlainArgsBuilder
import com.pulumi.aws.wafregional.kotlin.inputs.GetWebAclPlainArgs
import com.pulumi.aws.wafregional.kotlin.inputs.GetWebAclPlainArgsBuilder
import com.pulumi.aws.wafregional.kotlin.outputs.GetIpsetResult
import com.pulumi.aws.wafregional.kotlin.outputs.GetRateBasedModResult
import com.pulumi.aws.wafregional.kotlin.outputs.GetRuleResult
import com.pulumi.aws.wafregional.kotlin.outputs.GetSubscribedRuleGroupResult
import com.pulumi.aws.wafregional.kotlin.outputs.GetWebAclResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.wafregional.kotlin.outputs.GetIpsetResult.Companion.toKotlin as getIpsetResultToKotlin
import com.pulumi.aws.wafregional.kotlin.outputs.GetRateBasedModResult.Companion.toKotlin as getRateBasedModResultToKotlin
import com.pulumi.aws.wafregional.kotlin.outputs.GetRuleResult.Companion.toKotlin as getRuleResultToKotlin
import com.pulumi.aws.wafregional.kotlin.outputs.GetSubscribedRuleGroupResult.Companion.toKotlin as getSubscribedRuleGroupResultToKotlin
import com.pulumi.aws.wafregional.kotlin.outputs.GetWebAclResult.Companion.toKotlin as getWebAclResultToKotlin

public object WafregionalFunctions {
    /**
     * `aws.wafregional.IpSet` Retrieves a WAF Regional IP Set Resource Id.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.wafregional.getIpset({
     *     name: "tfWAFRegionalIPSet",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.wafregional.get_ipset(name="tfWAFRegionalIPSet")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.WafRegional.GetIpset.Invoke(new()
     *     {
     *         Name = "tfWAFRegionalIPSet",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/wafregional"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := wafregional.GetIpset(ctx, &wafregional.GetIpsetArgs{
     * 			Name: "tfWAFRegionalIPSet",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.wafregional.WafregionalFunctions;
     * import com.pulumi.aws.wafregional.inputs.GetIpsetArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = WafregionalFunctions.getIpset(GetIpsetArgs.builder()
     *             .name("tfWAFRegionalIPSet")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:wafregional:getIpset
     *       Arguments:
     *         name: tfWAFRegionalIPSet
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getIpset.
     * @return A collection of values returned by getIpset.
     */
    public suspend fun getIpset(argument: GetIpsetPlainArgs): GetIpsetResult =
        getIpsetResultToKotlin(getIpsetPlain(argument.toJava()).await())

    /**
     * @see [getIpset].
     * @param name Name of the WAF Regional IP set.
     * @return A collection of values returned by getIpset.
     */
    public suspend fun getIpset(name: String): GetIpsetResult {
        val argument = GetIpsetPlainArgs(
            name = name,
        )
        return getIpsetResultToKotlin(getIpsetPlain(argument.toJava()).await())
    }

    /**
     * @see [getIpset].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;wafregional&#46;kotlin&#46;inputs&#46;GetIpsetPlainArgs].
     * @return A collection of values returned by getIpset.
     */
    public suspend fun getIpset(argument: suspend GetIpsetPlainArgsBuilder.() -> Unit): GetIpsetResult {
        val builder = GetIpsetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIpsetResultToKotlin(getIpsetPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.wafregional.RateBasedRule` Retrieves a WAF Regional Rate Based Rule Resource Id.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.wafregional.getRateBasedMod({
     *     name: "tfWAFRegionalRateBasedRule",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.wafregional.get_rate_based_mod(name="tfWAFRegionalRateBasedRule")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.WafRegional.GetRateBasedMod.Invoke(new()
     *     {
     *         Name = "tfWAFRegionalRateBasedRule",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/wafregional"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := wafregional.GetRateBasedMod(ctx, &wafregional.GetRateBasedModArgs{
     * 			Name: "tfWAFRegionalRateBasedRule",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.wafregional.WafregionalFunctions;
     * import com.pulumi.aws.wafregional.inputs.GetRateBasedModArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = WafregionalFunctions.getRateBasedMod(GetRateBasedModArgs.builder()
     *             .name("tfWAFRegionalRateBasedRule")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:wafregional:getRateBasedMod
     *       Arguments:
     *         name: tfWAFRegionalRateBasedRule
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRateBasedMod.
     * @return A collection of values returned by getRateBasedMod.
     */
    public suspend fun getRateBasedMod(argument: GetRateBasedModPlainArgs): GetRateBasedModResult =
        getRateBasedModResultToKotlin(getRateBasedModPlain(argument.toJava()).await())

    /**
     * @see [getRateBasedMod].
     * @param name Name of the WAF Regional rate based rule.
     * @return A collection of values returned by getRateBasedMod.
     */
    public suspend fun getRateBasedMod(name: String): GetRateBasedModResult {
        val argument = GetRateBasedModPlainArgs(
            name = name,
        )
        return getRateBasedModResultToKotlin(getRateBasedModPlain(argument.toJava()).await())
    }

    /**
     * @see [getRateBasedMod].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;wafregional&#46;kotlin&#46;inputs&#46;GetRateBasedModPlainArgs].
     * @return A collection of values returned by getRateBasedMod.
     */
    public suspend fun getRateBasedMod(argument: suspend GetRateBasedModPlainArgsBuilder.() -> Unit): GetRateBasedModResult {
        val builder = GetRateBasedModPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRateBasedModResultToKotlin(getRateBasedModPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.wafregional.Rule` Retrieves a WAF Regional Rule Resource Id.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.wafregional.getRule({
     *     name: "tfWAFRegionalRule",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.wafregional.get_rule(name="tfWAFRegionalRule")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.WafRegional.GetRule.Invoke(new()
     *     {
     *         Name = "tfWAFRegionalRule",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/wafregional"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := wafregional.LookupRule(ctx, &wafregional.LookupRuleArgs{
     * 			Name: "tfWAFRegionalRule",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.wafregional.WafregionalFunctions;
     * import com.pulumi.aws.wafregional.inputs.GetRuleArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = WafregionalFunctions.getRule(GetRuleArgs.builder()
     *             .name("tfWAFRegionalRule")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:wafregional:getRule
     *       Arguments:
     *         name: tfWAFRegionalRule
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRule.
     * @return A collection of values returned by getRule.
     */
    public suspend fun getRule(argument: GetRulePlainArgs): GetRuleResult =
        getRuleResultToKotlin(getRulePlain(argument.toJava()).await())

    /**
     * @see [getRule].
     * @param name Name of the WAF Regional rule.
     * @return A collection of values returned by getRule.
     */
    public suspend fun getRule(name: String): GetRuleResult {
        val argument = GetRulePlainArgs(
            name = name,
        )
        return getRuleResultToKotlin(getRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getRule].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;wafregional&#46;kotlin&#46;inputs&#46;GetRulePlainArgs].
     * @return A collection of values returned by getRule.
     */
    public suspend fun getRule(argument: suspend GetRulePlainArgsBuilder.() -> Unit): GetRuleResult {
        val builder = GetRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRuleResultToKotlin(getRulePlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.wafregional.getSubscribedRuleGroup` retrieves information about a Managed WAF Rule Group from AWS Marketplace for use in WAF Regional (needs to be subscribed to first).
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const byName = aws.wafregional.getSubscribedRuleGroup({
     *     name: "F5 Bot Detection Signatures For AWS WAF",
     * });
     * const byMetricName = aws.wafregional.getSubscribedRuleGroup({
     *     metricName: "F5BotDetectionSignatures",
     * });
     * const acl = new aws.wafregional.WebAcl("acl", {rules: [
     *     {
     *         priority: 1,
     *         ruleId: byName.then(byName => byName.id),
     *         type: "GROUP",
     *     },
     *     {
     *         priority: 2,
     *         ruleId: byMetricName.then(byMetricName => byMetricName.id),
     *         type: "GROUP",
     *     },
     * ]});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * by_name = aws.wafregional.get_subscribed_rule_group(name="F5 Bot Detection Signatures For AWS WAF")
     * by_metric_name = aws.wafregional.get_subscribed_rule_group(metric_name="F5BotDetectionSignatures")
     * acl = aws.wafregional.WebAcl("acl", rules=[
     *     {
     *         "priority": 1,
     *         "rule_id": by_name.id,
     *         "type": "GROUP",
     *     },
     *     {
     *         "priority": 2,
     *         "rule_id": by_metric_name.id,
     *         "type": "GROUP",
     *     },
     * ])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var byName = Aws.WafRegional.GetSubscribedRuleGroup.Invoke(new()
     *     {
     *         Name = "F5 Bot Detection Signatures For AWS WAF",
     *     });
     *     var byMetricName = Aws.WafRegional.GetSubscribedRuleGroup.Invoke(new()
     *     {
     *         MetricName = "F5BotDetectionSignatures",
     *     });
     *     var acl = new Aws.WafRegional.WebAcl("acl", new()
     *     {
     *         Rules = new[]
     *         {
     *             new Aws.WafRegional.Inputs.WebAclRuleArgs
     *             {
     *                 Priority = 1,
     *                 RuleId = byName.Apply(getSubscribedRuleGroupResult => getSubscribedRuleGroupResult.Id),
     *                 Type = "GROUP",
     *             },
     *             new Aws.WafRegional.Inputs.WebAclRuleArgs
     *             {
     *                 Priority = 2,
     *                 RuleId = byMetricName.Apply(getSubscribedRuleGroupResult => getSubscribedRuleGroupResult.Id),
     *                 Type = "GROUP",
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/wafregional"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		byName, err := wafregional.GetSubscribedRuleGroup(ctx, &wafregional.GetSubscribedRuleGroupArgs{
     * 			Name: pulumi.StringRef("F5 Bot Detection Signatures For AWS WAF"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		byMetricName, err := wafregional.GetSubscribedRuleGroup(ctx, &wafregional.GetSubscribedRuleGroupArgs{
     * 			MetricName: pulumi.StringRef("F5BotDetectionSignatures"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = wafregional.NewWebAcl(ctx, "acl", &wafregional.WebAclArgs{
     * 			Rules: wafregional.WebAclRuleArray{
     * 				&wafregional.WebAclRuleArgs{
     * 					Priority: pulumi.Int(1),
     * 					RuleId:   pulumi.String(byName.Id),
     * 					Type:     pulumi.String("GROUP"),
     * 				},
     * 				&wafregional.WebAclRuleArgs{
     * 					Priority: pulumi.Int(2),
     * 					RuleId:   pulumi.String(byMetricName.Id),
     * 					Type:     pulumi.String("GROUP"),
     * 				},
     * 			},
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.wafregional.WafregionalFunctions;
     * import com.pulumi.aws.wafregional.inputs.GetSubscribedRuleGroupArgs;
     * import com.pulumi.aws.wafregional.WebAcl;
     * import com.pulumi.aws.wafregional.WebAclArgs;
     * import com.pulumi.aws.wafregional.inputs.WebAclRuleArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var byName = WafregionalFunctions.getSubscribedRuleGroup(GetSubscribedRuleGroupArgs.builder()
     *             .name("F5 Bot Detection Signatures For AWS WAF")
     *             .build());
     *         final var byMetricName = WafregionalFunctions.getSubscribedRuleGroup(GetSubscribedRuleGroupArgs.builder()
     *             .metricName("F5BotDetectionSignatures")
     *             .build());
     *         var acl = new WebAcl("acl", WebAclArgs.builder()
     *             .rules(
     *                 WebAclRuleArgs.builder()
     *                     .priority(1)
     *                     .ruleId(byName.applyValue(getSubscribedRuleGroupResult -> getSubscribedRuleGroupResult.id()))
     *                     .type("GROUP")
     *                     .build(),
     *                 WebAclRuleArgs.builder()
     *                     .priority(2)
     *                     .ruleId(byMetricName.applyValue(getSubscribedRuleGroupResult -> getSubscribedRuleGroupResult.id()))
     *                     .type("GROUP")
     *                     .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   acl:
     *     type: aws:wafregional:WebAcl
     *     properties:
     *       rules:
     *         - priority: 1
     *           ruleId: ${byName.id}
     *           type: GROUP
     *         - priority: 2
     *           ruleId: ${byMetricName.id}
     *           type: GROUP
     * variables:
     *   byName:
     *     fn::invoke:
     *       Function: aws:wafregional:getSubscribedRuleGroup
     *       Arguments:
     *         name: F5 Bot Detection Signatures For AWS WAF
     *   byMetricName:
     *     fn::invoke:
     *       Function: aws:wafregional:getSubscribedRuleGroup
     *       Arguments:
     *         metricName: F5BotDetectionSignatures
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSubscribedRuleGroup.
     * @return A collection of values returned by getSubscribedRuleGroup.
     */
    public suspend fun getSubscribedRuleGroup(argument: GetSubscribedRuleGroupPlainArgs): GetSubscribedRuleGroupResult =
        getSubscribedRuleGroupResultToKotlin(getSubscribedRuleGroupPlain(argument.toJava()).await())

    /**
     * @see [getSubscribedRuleGroup].
     * @param metricName Name of the WAF rule group.
     * @param name Name of the WAF rule group.
     * @return A collection of values returned by getSubscribedRuleGroup.
     */
    public suspend fun getSubscribedRuleGroup(metricName: String? = null, name: String? = null): GetSubscribedRuleGroupResult {
        val argument = GetSubscribedRuleGroupPlainArgs(
            metricName = metricName,
            name = name,
        )
        return getSubscribedRuleGroupResultToKotlin(getSubscribedRuleGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getSubscribedRuleGroup].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;wafregional&#46;kotlin&#46;inputs&#46;GetSubscribedRuleGroupPlainArgs].
     * @return A collection of values returned by getSubscribedRuleGroup.
     */
    public suspend fun getSubscribedRuleGroup(argument: suspend GetSubscribedRuleGroupPlainArgsBuilder.() -> Unit): GetSubscribedRuleGroupResult {
        val builder = GetSubscribedRuleGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSubscribedRuleGroupResultToKotlin(getSubscribedRuleGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * `aws.wafregional.WebAcl` Retrieves a WAF Regional Web ACL Resource Id.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.wafregional.getWebAcl({
     *     name: "tfWAFRegionalWebACL",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.wafregional.get_web_acl(name="tfWAFRegionalWebACL")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.WafRegional.GetWebAcl.Invoke(new()
     *     {
     *         Name = "tfWAFRegionalWebACL",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/wafregional"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := wafregional.LookupWebAcl(ctx, &wafregional.LookupWebAclArgs{
     * 			Name: "tfWAFRegionalWebACL",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.wafregional.WafregionalFunctions;
     * import com.pulumi.aws.wafregional.inputs.GetWebAclArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = WafregionalFunctions.getWebAcl(GetWebAclArgs.builder()
     *             .name("tfWAFRegionalWebACL")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:wafregional:getWebAcl
     *       Arguments:
     *         name: tfWAFRegionalWebACL
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getWebAcl.
     * @return A collection of values returned by getWebAcl.
     */
    public suspend fun getWebAcl(argument: GetWebAclPlainArgs): GetWebAclResult =
        getWebAclResultToKotlin(getWebAclPlain(argument.toJava()).await())

    /**
     * @see [getWebAcl].
     * @param name Name of the WAF Regional Web ACL.
     * @return A collection of values returned by getWebAcl.
     */
    public suspend fun getWebAcl(name: String): GetWebAclResult {
        val argument = GetWebAclPlainArgs(
            name = name,
        )
        return getWebAclResultToKotlin(getWebAclPlain(argument.toJava()).await())
    }

    /**
     * @see [getWebAcl].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;wafregional&#46;kotlin&#46;inputs&#46;GetWebAclPlainArgs].
     * @return A collection of values returned by getWebAcl.
     */
    public suspend fun getWebAcl(argument: suspend GetWebAclPlainArgsBuilder.() -> Unit): GetWebAclResult {
        val builder = GetWebAclPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWebAclResultToKotlin(getWebAclPlain(builtArgument.toJava()).await())
    }
}
