@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafregional.kotlin

import com.pulumi.aws.wafregional.WebAclArgs.builder
import com.pulumi.aws.wafregional.kotlin.inputs.WebAclDefaultActionArgs
import com.pulumi.aws.wafregional.kotlin.inputs.WebAclDefaultActionArgsBuilder
import com.pulumi.aws.wafregional.kotlin.inputs.WebAclLoggingConfigurationArgs
import com.pulumi.aws.wafregional.kotlin.inputs.WebAclLoggingConfigurationArgsBuilder
import com.pulumi.aws.wafregional.kotlin.inputs.WebAclRuleArgs
import com.pulumi.aws.wafregional.kotlin.inputs.WebAclRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a WAF Regional Web ACL Resource for use with Application Load Balancer.
 * ## Example Usage
 * ### Regular Rule
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const ipset = new aws.wafregional.IpSet("ipset", {
 *     name: "tfIPSet",
 *     ipSetDescriptors: [{
 *         type: "IPV4",
 *         value: "192.0.7.0/24",
 *     }],
 * });
 * const wafrule = new aws.wafregional.Rule("wafrule", {
 *     name: "tfWAFRule",
 *     metricName: "tfWAFRule",
 *     predicates: [{
 *         dataId: ipset.id,
 *         negated: false,
 *         type: "IPMatch",
 *     }],
 * });
 * const wafacl = new aws.wafregional.WebAcl("wafacl", {
 *     name: "tfWebACL",
 *     metricName: "tfWebACL",
 *     defaultAction: {
 *         type: "ALLOW",
 *     },
 *     rules: [{
 *         action: {
 *             type: "BLOCK",
 *         },
 *         priority: 1,
 *         ruleId: wafrule.id,
 *         type: "REGULAR",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * ipset = aws.wafregional.IpSet("ipset",
 *     name="tfIPSet",
 *     ip_set_descriptors=[{
 *         "type": "IPV4",
 *         "value": "192.0.7.0/24",
 *     }])
 * wafrule = aws.wafregional.Rule("wafrule",
 *     name="tfWAFRule",
 *     metric_name="tfWAFRule",
 *     predicates=[{
 *         "data_id": ipset.id,
 *         "negated": False,
 *         "type": "IPMatch",
 *     }])
 * wafacl = aws.wafregional.WebAcl("wafacl",
 *     name="tfWebACL",
 *     metric_name="tfWebACL",
 *     default_action={
 *         "type": "ALLOW",
 *     },
 *     rules=[{
 *         "action": {
 *             "type": "BLOCK",
 *         },
 *         "priority": 1,
 *         "rule_id": wafrule.id,
 *         "type": "REGULAR",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ipset = new Aws.WafRegional.IpSet("ipset", new()
 *     {
 *         Name = "tfIPSet",
 *         IpSetDescriptors = new[]
 *         {
 *             new Aws.WafRegional.Inputs.IpSetIpSetDescriptorArgs
 *             {
 *                 Type = "IPV4",
 *                 Value = "192.0.7.0/24",
 *             },
 *         },
 *     });
 *     var wafrule = new Aws.WafRegional.Rule("wafrule", new()
 *     {
 *         Name = "tfWAFRule",
 *         MetricName = "tfWAFRule",
 *         Predicates = new[]
 *         {
 *             new Aws.WafRegional.Inputs.RulePredicateArgs
 *             {
 *                 DataId = ipset.Id,
 *                 Negated = false,
 *                 Type = "IPMatch",
 *             },
 *         },
 *     });
 *     var wafacl = new Aws.WafRegional.WebAcl("wafacl", new()
 *     {
 *         Name = "tfWebACL",
 *         MetricName = "tfWebACL",
 *         DefaultAction = new Aws.WafRegional.Inputs.WebAclDefaultActionArgs
 *         {
 *             Type = "ALLOW",
 *         },
 *         Rules = new[]
 *         {
 *             new Aws.WafRegional.Inputs.WebAclRuleArgs
 *             {
 *                 Action = new Aws.WafRegional.Inputs.WebAclRuleActionArgs
 *                 {
 *                     Type = "BLOCK",
 *                 },
 *                 Priority = 1,
 *                 RuleId = wafrule.Id,
 *                 Type = "REGULAR",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/wafregional"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		ipset, err := wafregional.NewIpSet(ctx, "ipset", &wafregional.IpSetArgs{
 * 			Name: pulumi.String("tfIPSet"),
 * 			IpSetDescriptors: wafregional.IpSetIpSetDescriptorArray{
 * 				&wafregional.IpSetIpSetDescriptorArgs{
 * 					Type:  pulumi.String("IPV4"),
 * 					Value: pulumi.String("192.0.7.0/24"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		wafrule, err := wafregional.NewRule(ctx, "wafrule", &wafregional.RuleArgs{
 * 			Name:       pulumi.String("tfWAFRule"),
 * 			MetricName: pulumi.String("tfWAFRule"),
 * 			Predicates: wafregional.RulePredicateArray{
 * 				&wafregional.RulePredicateArgs{
 * 					DataId:  ipset.ID(),
 * 					Negated: pulumi.Bool(false),
 * 					Type:    pulumi.String("IPMatch"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = wafregional.NewWebAcl(ctx, "wafacl", &wafregional.WebAclArgs{
 * 			Name:       pulumi.String("tfWebACL"),
 * 			MetricName: pulumi.String("tfWebACL"),
 * 			DefaultAction: &wafregional.WebAclDefaultActionArgs{
 * 				Type: pulumi.String("ALLOW"),
 * 			},
 * 			Rules: wafregional.WebAclRuleArray{
 * 				&wafregional.WebAclRuleArgs{
 * 					Action: &wafregional.WebAclRuleActionArgs{
 * 						Type: pulumi.String("BLOCK"),
 * 					},
 * 					Priority: pulumi.Int(1),
 * 					RuleId:   wafrule.ID(),
 * 					Type:     pulumi.String("REGULAR"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.wafregional.IpSet;
 * import com.pulumi.aws.wafregional.IpSetArgs;
 * import com.pulumi.aws.wafregional.inputs.IpSetIpSetDescriptorArgs;
 * import com.pulumi.aws.wafregional.Rule;
 * import com.pulumi.aws.wafregional.RuleArgs;
 * import com.pulumi.aws.wafregional.inputs.RulePredicateArgs;
 * import com.pulumi.aws.wafregional.WebAcl;
 * import com.pulumi.aws.wafregional.WebAclArgs;
 * import com.pulumi.aws.wafregional.inputs.WebAclDefaultActionArgs;
 * import com.pulumi.aws.wafregional.inputs.WebAclRuleArgs;
 * import com.pulumi.aws.wafregional.inputs.WebAclRuleActionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ipset = new IpSet("ipset", IpSetArgs.builder()
 *             .name("tfIPSet")
 *             .ipSetDescriptors(IpSetIpSetDescriptorArgs.builder()
 *                 .type("IPV4")
 *                 .value("192.0.7.0/24")
 *                 .build())
 *             .build());
 *         var wafrule = new Rule("wafrule", RuleArgs.builder()
 *             .name("tfWAFRule")
 *             .metricName("tfWAFRule")
 *             .predicates(RulePredicateArgs.builder()
 *                 .dataId(ipset.id())
 *                 .negated(false)
 *                 .type("IPMatch")
 *                 .build())
 *             .build());
 *         var wafacl = new WebAcl("wafacl", WebAclArgs.builder()
 *             .name("tfWebACL")
 *             .metricName("tfWebACL")
 *             .defaultAction(WebAclDefaultActionArgs.builder()
 *                 .type("ALLOW")
 *                 .build())
 *             .rules(WebAclRuleArgs.builder()
 *                 .action(WebAclRuleActionArgs.builder()
 *                     .type("BLOCK")
 *                     .build())
 *                 .priority(1)
 *                 .ruleId(wafrule.id())
 *                 .type("REGULAR")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   ipset:
 *     type: aws:wafregional:IpSet
 *     properties:
 *       name: tfIPSet
 *       ipSetDescriptors:
 *         - type: IPV4
 *           value: 192.0.7.0/24
 *   wafrule:
 *     type: aws:wafregional:Rule
 *     properties:
 *       name: tfWAFRule
 *       metricName: tfWAFRule
 *       predicates:
 *         - dataId: ${ipset.id}
 *           negated: false
 *           type: IPMatch
 *   wafacl:
 *     type: aws:wafregional:WebAcl
 *     properties:
 *       name: tfWebACL
 *       metricName: tfWebACL
 *       defaultAction:
 *         type: ALLOW
 *       rules:
 *         - action:
 *             type: BLOCK
 *           priority: 1
 *           ruleId: ${wafrule.id}
 *           type: REGULAR
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Group Rule
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.wafregional.WebAcl("example", {
 *     name: "example",
 *     metricName: "example",
 *     defaultAction: {
 *         type: "ALLOW",
 *     },
 *     rules: [{
 *         priority: 1,
 *         ruleId: exampleAwsWafregionalRuleGroup.id,
 *         type: "GROUP",
 *         overrideAction: {
 *             type: "NONE",
 *         },
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.wafregional.WebAcl("example",
 *     name="example",
 *     metric_name="example",
 *     default_action={
 *         "type": "ALLOW",
 *     },
 *     rules=[{
 *         "priority": 1,
 *         "rule_id": example_aws_wafregional_rule_group["id"],
 *         "type": "GROUP",
 *         "override_action": {
 *             "type": "NONE",
 *         },
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.WafRegional.WebAcl("example", new()
 *     {
 *         Name = "example",
 *         MetricName = "example",
 *         DefaultAction = new Aws.WafRegional.Inputs.WebAclDefaultActionArgs
 *         {
 *             Type = "ALLOW",
 *         },
 *         Rules = new[]
 *         {
 *             new Aws.WafRegional.Inputs.WebAclRuleArgs
 *             {
 *                 Priority = 1,
 *                 RuleId = exampleAwsWafregionalRuleGroup.Id,
 *                 Type = "GROUP",
 *                 OverrideAction = new Aws.WafRegional.Inputs.WebAclRuleOverrideActionArgs
 *                 {
 *                     Type = "NONE",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/wafregional"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := wafregional.NewWebAcl(ctx, "example", &wafregional.WebAclArgs{
 * 			Name:       pulumi.String("example"),
 * 			MetricName: pulumi.String("example"),
 * 			DefaultAction: &wafregional.WebAclDefaultActionArgs{
 * 				Type: pulumi.String("ALLOW"),
 * 			},
 * 			Rules: wafregional.WebAclRuleArray{
 * 				&wafregional.WebAclRuleArgs{
 * 					Priority: pulumi.Int(1),
 * 					RuleId:   pulumi.Any(exampleAwsWafregionalRuleGroup.Id),
 * 					Type:     pulumi.String("GROUP"),
 * 					OverrideAction: &wafregional.WebAclRuleOverrideActionArgs{
 * 						Type: pulumi.String("NONE"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.wafregional.WebAcl;
 * import com.pulumi.aws.wafregional.WebAclArgs;
 * import com.pulumi.aws.wafregional.inputs.WebAclDefaultActionArgs;
 * import com.pulumi.aws.wafregional.inputs.WebAclRuleArgs;
 * import com.pulumi.aws.wafregional.inputs.WebAclRuleOverrideActionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new WebAcl("example", WebAclArgs.builder()
 *             .name("example")
 *             .metricName("example")
 *             .defaultAction(WebAclDefaultActionArgs.builder()
 *                 .type("ALLOW")
 *                 .build())
 *             .rules(WebAclRuleArgs.builder()
 *                 .priority(1)
 *                 .ruleId(exampleAwsWafregionalRuleGroup.id())
 *                 .type("GROUP")
 *                 .overrideAction(WebAclRuleOverrideActionArgs.builder()
 *                     .type("NONE")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:wafregional:WebAcl
 *     properties:
 *       name: example
 *       metricName: example
 *       defaultAction:
 *         type: ALLOW
 *       rules:
 *         - priority: 1
 *           ruleId: ${exampleAwsWafregionalRuleGroup.id}
 *           type: GROUP
 *           overrideAction:
 *             type: NONE
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Logging
 * > *NOTE:* The Kinesis Firehose Delivery Stream name must begin with `aws-waf-logs-`. See the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/logging.html) for more information about enabling WAF logging.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.wafregional.WebAcl("example", {loggingConfiguration: {
 *     logDestination: exampleAwsKinesisFirehoseDeliveryStream.arn,
 *     redactedFields: {
 *         fieldToMatches: [
 *             {
 *                 type: "URI",
 *             },
 *             {
 *                 data: "referer",
 *                 type: "HEADER",
 *             },
 *         ],
 *     },
 * }});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.wafregional.WebAcl("example", logging_configuration={
 *     "log_destination": example_aws_kinesis_firehose_delivery_stream["arn"],
 *     "redacted_fields": {
 *         "field_to_matches": [
 *             {
 *                 "type": "URI",
 *             },
 *             {
 *                 "data": "referer",
 *                 "type": "HEADER",
 *             },
 *         ],
 *     },
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.WafRegional.WebAcl("example", new()
 *     {
 *         LoggingConfiguration = new Aws.WafRegional.Inputs.WebAclLoggingConfigurationArgs
 *         {
 *             LogDestination = exampleAwsKinesisFirehoseDeliveryStream.Arn,
 *             RedactedFields = new Aws.WafRegional.Inputs.WebAclLoggingConfigurationRedactedFieldsArgs
 *             {
 *                 FieldToMatches = new[]
 *                 {
 *                     new Aws.WafRegional.Inputs.WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgs
 *                     {
 *                         Type = "URI",
 *                     },
 *                     new Aws.WafRegional.Inputs.WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgs
 *                     {
 *                         Data = "referer",
 *                         Type = "HEADER",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/wafregional"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := wafregional.NewWebAcl(ctx, "example", &wafregional.WebAclArgs{
 * 			LoggingConfiguration: &wafregional.WebAclLoggingConfigurationArgs{
 * 				LogDestination: pulumi.Any(exampleAwsKinesisFirehoseDeliveryStream.Arn),
 * 				RedactedFields: &wafregional.WebAclLoggingConfigurationRedactedFieldsArgs{
 * 					FieldToMatches: wafregional.WebAclLoggingConfigurationRedactedFieldsFieldToMatchArray{
 * 						&wafregional.WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgs{
 * 							Type: pulumi.String("URI"),
 * 						},
 * 						&wafregional.WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgs{
 * 							Data: pulumi.String("referer"),
 * 							Type: pulumi.String("HEADER"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.wafregional.WebAcl;
 * import com.pulumi.aws.wafregional.WebAclArgs;
 * import com.pulumi.aws.wafregional.inputs.WebAclLoggingConfigurationArgs;
 * import com.pulumi.aws.wafregional.inputs.WebAclLoggingConfigurationRedactedFieldsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new WebAcl("example", WebAclArgs.builder()
 *             .loggingConfiguration(WebAclLoggingConfigurationArgs.builder()
 *                 .logDestination(exampleAwsKinesisFirehoseDeliveryStream.arn())
 *                 .redactedFields(WebAclLoggingConfigurationRedactedFieldsArgs.builder()
 *                     .fieldToMatches(
 *                         WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgs.builder()
 *                             .type("URI")
 *                             .build(),
 *                         WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgs.builder()
 *                             .data("referer")
 *                             .type("HEADER")
 *                             .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:wafregional:WebAcl
 *     properties:
 *       loggingConfiguration:
 *         logDestination: ${exampleAwsKinesisFirehoseDeliveryStream.arn}
 *         redactedFields:
 *           fieldToMatches:
 *             - type: URI
 *             - data: referer
 *               type: HEADER
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import WAF Regional Web ACL using the id. For example:
 * ```sh
 * $ pulumi import aws:wafregional/webAcl:WebAcl wafacl a1b2c3d4-d5f6-7777-8888-9999aaaabbbbcccc
 * ```
 * @property defaultAction The action that you want AWS WAF Regional to take when a request doesn't match the criteria in any of the rules that are associated with the web ACL.
 * @property loggingConfiguration Configuration block to enable WAF logging. Detailed below.
 * @property metricName The name or description for the Amazon CloudWatch metric of this web ACL.
 * @property name The name or description of the web ACL.
 * @property rules Set of configuration blocks containing rules for the web ACL. Detailed below.
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class WebAclArgs(
    public val defaultAction: Output<WebAclDefaultActionArgs>? = null,
    public val loggingConfiguration: Output<WebAclLoggingConfigurationArgs>? = null,
    public val metricName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val rules: Output<List<WebAclRuleArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafregional.WebAclArgs> {
    override fun toJava(): com.pulumi.aws.wafregional.WebAclArgs =
        com.pulumi.aws.wafregional.WebAclArgs.builder()
            .defaultAction(defaultAction?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .loggingConfiguration(
                loggingConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .metricName(metricName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .rules(rules?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [WebAclArgs].
 */
@PulumiTagMarker
public class WebAclArgsBuilder internal constructor() {
    private var defaultAction: Output<WebAclDefaultActionArgs>? = null

    private var loggingConfiguration: Output<WebAclLoggingConfigurationArgs>? = null

    private var metricName: Output<String>? = null

    private var name: Output<String>? = null

    private var rules: Output<List<WebAclRuleArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The action that you want AWS WAF Regional to take when a request doesn't match the criteria in any of the rules that are associated with the web ACL.
     */
    @JvmName("prpsedknjpammyfx")
    public suspend fun defaultAction(`value`: Output<WebAclDefaultActionArgs>) {
        this.defaultAction = value
    }

    /**
     * @param value Configuration block to enable WAF logging. Detailed below.
     */
    @JvmName("djipphqjdcnumcnj")
    public suspend fun loggingConfiguration(`value`: Output<WebAclLoggingConfigurationArgs>) {
        this.loggingConfiguration = value
    }

    /**
     * @param value The name or description for the Amazon CloudWatch metric of this web ACL.
     */
    @JvmName("tfbcmcsjncvhxuec")
    public suspend fun metricName(`value`: Output<String>) {
        this.metricName = value
    }

    /**
     * @param value The name or description of the web ACL.
     */
    @JvmName("nkjiqqlvobobnwbc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Set of configuration blocks containing rules for the web ACL. Detailed below.
     */
    @JvmName("mcjghwkkskwvujxe")
    public suspend fun rules(`value`: Output<List<WebAclRuleArgs>>) {
        this.rules = value
    }

    @JvmName("brskgakvcfvdptvq")
    public suspend fun rules(vararg values: Output<WebAclRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values Set of configuration blocks containing rules for the web ACL. Detailed below.
     */
    @JvmName("fuytcnumlnvljakb")
    public suspend fun rules(values: List<Output<WebAclRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jqiyygtnpyhdkguy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The action that you want AWS WAF Regional to take when a request doesn't match the criteria in any of the rules that are associated with the web ACL.
     */
    @JvmName("hkmssnkscancnhgu")
    public suspend fun defaultAction(`value`: WebAclDefaultActionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultAction = mapped
    }

    /**
     * @param argument The action that you want AWS WAF Regional to take when a request doesn't match the criteria in any of the rules that are associated with the web ACL.
     */
    @JvmName("jnoearrvfiyhrrtv")
    public suspend fun defaultAction(argument: suspend WebAclDefaultActionArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclDefaultActionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.defaultAction = mapped
    }

    /**
     * @param value Configuration block to enable WAF logging. Detailed below.
     */
    @JvmName("uuekgcambibieuhq")
    public suspend fun loggingConfiguration(`value`: WebAclLoggingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loggingConfiguration = mapped
    }

    /**
     * @param argument Configuration block to enable WAF logging. Detailed below.
     */
    @JvmName("soklbyanjvfffjjn")
    public suspend fun loggingConfiguration(argument: suspend WebAclLoggingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclLoggingConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.loggingConfiguration = mapped
    }

    /**
     * @param value The name or description for the Amazon CloudWatch metric of this web ACL.
     */
    @JvmName("fceruosddueyjrin")
    public suspend fun metricName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricName = mapped
    }

    /**
     * @param value The name or description of the web ACL.
     */
    @JvmName("xfbuprocugaovbny")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Set of configuration blocks containing rules for the web ACL. Detailed below.
     */
    @JvmName("meamernntqsyvwou")
    public suspend fun rules(`value`: List<WebAclRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument Set of configuration blocks containing rules for the web ACL. Detailed below.
     */
    @JvmName("emttigewabtdjrdm")
    public suspend fun rules(argument: List<suspend WebAclRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { WebAclRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument Set of configuration blocks containing rules for the web ACL. Detailed below.
     */
    @JvmName("hooqtgmujfxiwtve")
    public suspend fun rules(vararg argument: suspend WebAclRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { WebAclRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument Set of configuration blocks containing rules for the web ACL. Detailed below.
     */
    @JvmName("kfkqjnpiriqxphfo")
    public suspend fun rules(argument: suspend WebAclRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(WebAclRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values Set of configuration blocks containing rules for the web ACL. Detailed below.
     */
    @JvmName("fodjouabvnrqdcve")
    public suspend fun rules(vararg values: WebAclRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cvqsjamsyyxghbjo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mocubhagjwvqxpjb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): WebAclArgs = WebAclArgs(
        defaultAction = defaultAction,
        loggingConfiguration = loggingConfiguration,
        metricName = metricName,
        name = name,
        rules = rules,
        tags = tags,
    )
}
