@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafregional.kotlin

import com.pulumi.aws.wafregional.kotlin.outputs.XssMatchSetXssMatchTuple
import com.pulumi.aws.wafregional.kotlin.outputs.XssMatchSetXssMatchTuple.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [XssMatchSet].
 */
@PulumiTagMarker
public class XssMatchSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: XssMatchSetArgs = XssMatchSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend XssMatchSetArgsBuilder.() -> Unit) {
        val builder = XssMatchSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): XssMatchSet {
        val builtJavaResource = com.pulumi.aws.wafregional.XssMatchSet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return XssMatchSet(builtJavaResource)
    }
}

/**
 * Provides a WAF Regional XSS Match Set Resource for use with Application Load Balancer.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const xssMatchSet = new aws.wafregional.XssMatchSet("xss_match_set", {
 *     name: "xss_match_set",
 *     xssMatchTuples: [
 *         {
 *             textTransformation: "NONE",
 *             fieldToMatch: {
 *                 type: "URI",
 *             },
 *         },
 *         {
 *             textTransformation: "NONE",
 *             fieldToMatch: {
 *                 type: "QUERY_STRING",
 *             },
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * xss_match_set = aws.wafregional.XssMatchSet("xss_match_set",
 *     name="xss_match_set",
 *     xss_match_tuples=[
 *         {
 *             "text_transformation": "NONE",
 *             "field_to_match": {
 *                 "type": "URI",
 *             },
 *         },
 *         {
 *             "text_transformation": "NONE",
 *             "field_to_match": {
 *                 "type": "QUERY_STRING",
 *             },
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var xssMatchSet = new Aws.WafRegional.XssMatchSet("xss_match_set", new()
 *     {
 *         Name = "xss_match_set",
 *         XssMatchTuples = new[]
 *         {
 *             new Aws.WafRegional.Inputs.XssMatchSetXssMatchTupleArgs
 *             {
 *                 TextTransformation = "NONE",
 *                 FieldToMatch = new Aws.WafRegional.Inputs.XssMatchSetXssMatchTupleFieldToMatchArgs
 *                 {
 *                     Type = "URI",
 *                 },
 *             },
 *             new Aws.WafRegional.Inputs.XssMatchSetXssMatchTupleArgs
 *             {
 *                 TextTransformation = "NONE",
 *                 FieldToMatch = new Aws.WafRegional.Inputs.XssMatchSetXssMatchTupleFieldToMatchArgs
 *                 {
 *                     Type = "QUERY_STRING",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/wafregional"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := wafregional.NewXssMatchSet(ctx, "xss_match_set", &wafregional.XssMatchSetArgs{
 * 			Name: pulumi.String("xss_match_set"),
 * 			XssMatchTuples: wafregional.XssMatchSetXssMatchTupleArray{
 * 				&wafregional.XssMatchSetXssMatchTupleArgs{
 * 					TextTransformation: pulumi.String("NONE"),
 * 					FieldToMatch: &wafregional.XssMatchSetXssMatchTupleFieldToMatchArgs{
 * 						Type: pulumi.String("URI"),
 * 					},
 * 				},
 * 				&wafregional.XssMatchSetXssMatchTupleArgs{
 * 					TextTransformation: pulumi.String("NONE"),
 * 					FieldToMatch: &wafregional.XssMatchSetXssMatchTupleFieldToMatchArgs{
 * 						Type: pulumi.String("QUERY_STRING"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.wafregional.XssMatchSet;
 * import com.pulumi.aws.wafregional.XssMatchSetArgs;
 * import com.pulumi.aws.wafregional.inputs.XssMatchSetXssMatchTupleArgs;
 * import com.pulumi.aws.wafregional.inputs.XssMatchSetXssMatchTupleFieldToMatchArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var xssMatchSet = new XssMatchSet("xssMatchSet", XssMatchSetArgs.builder()
 *             .name("xss_match_set")
 *             .xssMatchTuples(
 *                 XssMatchSetXssMatchTupleArgs.builder()
 *                     .textTransformation("NONE")
 *                     .fieldToMatch(XssMatchSetXssMatchTupleFieldToMatchArgs.builder()
 *                         .type("URI")
 *                         .build())
 *                     .build(),
 *                 XssMatchSetXssMatchTupleArgs.builder()
 *                     .textTransformation("NONE")
 *                     .fieldToMatch(XssMatchSetXssMatchTupleFieldToMatchArgs.builder()
 *                         .type("QUERY_STRING")
 *                         .build())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   xssMatchSet:
 *     type: aws:wafregional:XssMatchSet
 *     name: xss_match_set
 *     properties:
 *       name: xss_match_set
 *       xssMatchTuples:
 *         - textTransformation: NONE
 *           fieldToMatch:
 *             type: URI
 *         - textTransformation: NONE
 *           fieldToMatch:
 *             type: QUERY_STRING
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AWS WAF Regional XSS Match using the `id`. For example:
 * ```sh
 * $ pulumi import aws:wafregional/xssMatchSet:XssMatchSet example 12345abcde
 * ```
 */
public class XssMatchSet internal constructor(
    override val javaResource: com.pulumi.aws.wafregional.XssMatchSet,
) : KotlinCustomResource(javaResource, XssMatchSetMapper) {
    /**
     * The name of the set
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The parts of web requests that you want to inspect for cross-site scripting attacks.
     */
    public val xssMatchTuples: Output<List<XssMatchSetXssMatchTuple>>?
        get() = javaResource.xssMatchTuples().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })
}

public object XssMatchSetMapper : ResourceMapper<XssMatchSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.wafregional.XssMatchSet::class == javaResource::class

    override fun map(javaResource: Resource): XssMatchSet = XssMatchSet(
        javaResource as
            com.pulumi.aws.wafregional.XssMatchSet,
    )
}

/**
 * @see [XssMatchSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [XssMatchSet].
 */
public suspend fun xssMatchSet(name: String, block: suspend XssMatchSetResourceBuilder.() -> Unit): XssMatchSet {
    val builder = XssMatchSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [XssMatchSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun xssMatchSet(name: String): XssMatchSet {
    val builder = XssMatchSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
