@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafregional.kotlin.inputs

import com.pulumi.aws.wafregional.inputs.ByteMatchSetByteMatchTupleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property fieldToMatch Settings for the ByteMatchTuple. FieldToMatch documented below.
 * @property positionalConstraint Within the portion of a web request that you want to search.
 * @property targetString The value that you want AWS WAF to search for. The maximum length of the value is 50 bytes.
 * @property textTransformation The formatting way for web request.
 * FieldToMatch(field_to_match) support following:
 */
public data class ByteMatchSetByteMatchTupleArgs(
    public val fieldToMatch: Output<ByteMatchSetByteMatchTupleFieldToMatchArgs>,
    public val positionalConstraint: Output<String>,
    public val targetString: Output<String>? = null,
    public val textTransformation: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.wafregional.inputs.ByteMatchSetByteMatchTupleArgs> {
    override fun toJava(): com.pulumi.aws.wafregional.inputs.ByteMatchSetByteMatchTupleArgs =
        com.pulumi.aws.wafregional.inputs.ByteMatchSetByteMatchTupleArgs.builder()
            .fieldToMatch(fieldToMatch.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .positionalConstraint(positionalConstraint.applyValue({ args0 -> args0 }))
            .targetString(targetString?.applyValue({ args0 -> args0 }))
            .textTransformation(textTransformation.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ByteMatchSetByteMatchTupleArgs].
 */
@PulumiTagMarker
public class ByteMatchSetByteMatchTupleArgsBuilder internal constructor() {
    private var fieldToMatch: Output<ByteMatchSetByteMatchTupleFieldToMatchArgs>? = null

    private var positionalConstraint: Output<String>? = null

    private var targetString: Output<String>? = null

    private var textTransformation: Output<String>? = null

    /**
     * @param value Settings for the ByteMatchTuple. FieldToMatch documented below.
     */
    @JvmName("ltfaqoeeqlxmjole")
    public suspend fun fieldToMatch(`value`: Output<ByteMatchSetByteMatchTupleFieldToMatchArgs>) {
        this.fieldToMatch = value
    }

    /**
     * @param value Within the portion of a web request that you want to search.
     */
    @JvmName("mcmgnotrmjgoqhpa")
    public suspend fun positionalConstraint(`value`: Output<String>) {
        this.positionalConstraint = value
    }

    /**
     * @param value The value that you want AWS WAF to search for. The maximum length of the value is 50 bytes.
     */
    @JvmName("sxkoodoaveaeckbl")
    public suspend fun targetString(`value`: Output<String>) {
        this.targetString = value
    }

    /**
     * @param value The formatting way for web request.
     * FieldToMatch(field_to_match) support following:
     */
    @JvmName("rrxpvxjigvtsiojd")
    public suspend fun textTransformation(`value`: Output<String>) {
        this.textTransformation = value
    }

    /**
     * @param value Settings for the ByteMatchTuple. FieldToMatch documented below.
     */
    @JvmName("dnrlarvjmayapdfe")
    public suspend fun fieldToMatch(`value`: ByteMatchSetByteMatchTupleFieldToMatchArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fieldToMatch = mapped
    }

    /**
     * @param argument Settings for the ByteMatchTuple. FieldToMatch documented below.
     */
    @JvmName("miupxxwdofojttyx")
    public suspend fun fieldToMatch(argument: suspend ByteMatchSetByteMatchTupleFieldToMatchArgsBuilder.() -> Unit) {
        val toBeMapped = ByteMatchSetByteMatchTupleFieldToMatchArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.fieldToMatch = mapped
    }

    /**
     * @param value Within the portion of a web request that you want to search.
     */
    @JvmName("mglfqbyokeewosmq")
    public suspend fun positionalConstraint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.positionalConstraint = mapped
    }

    /**
     * @param value The value that you want AWS WAF to search for. The maximum length of the value is 50 bytes.
     */
    @JvmName("jwiuwojndvymwjam")
    public suspend fun targetString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetString = mapped
    }

    /**
     * @param value The formatting way for web request.
     * FieldToMatch(field_to_match) support following:
     */
    @JvmName("qkgsgvhlhqbxtudt")
    public suspend fun textTransformation(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformation = mapped
    }

    internal fun build(): ByteMatchSetByteMatchTupleArgs = ByteMatchSetByteMatchTupleArgs(
        fieldToMatch = fieldToMatch ?: throw PulumiNullFieldException("fieldToMatch"),
        positionalConstraint = positionalConstraint ?: throw
            PulumiNullFieldException("positionalConstraint"),
        targetString = targetString,
        textTransformation = textTransformation ?: throw PulumiNullFieldException("textTransformation"),
    )
}
