@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafregional.kotlin.inputs

import com.pulumi.aws.wafregional.inputs.GetRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRule.
 * @property name Name of the WAF Regional rule.
 */
public data class GetRulePlainArgs(
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.wafregional.inputs.GetRulePlainArgs> {
    override fun toJava(): com.pulumi.aws.wafregional.inputs.GetRulePlainArgs =
        com.pulumi.aws.wafregional.inputs.GetRulePlainArgs.builder()
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRulePlainArgs].
 */
@PulumiTagMarker
public class GetRulePlainArgsBuilder internal constructor() {
    private var name: String? = null

    /**
     * @param value Name of the WAF Regional rule.
     */
    @JvmName("duxssynbpuqekyne")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetRulePlainArgs = GetRulePlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
