@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafregional.kotlin.inputs

import com.pulumi.aws.wafregional.inputs.RulePredicateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dataId
 * @property negated
 * @property type
 */
public data class RulePredicateArgs(
    public val dataId: Output<String>,
    public val negated: Output<Boolean>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.wafregional.inputs.RulePredicateArgs> {
    override fun toJava(): com.pulumi.aws.wafregional.inputs.RulePredicateArgs =
        com.pulumi.aws.wafregional.inputs.RulePredicateArgs.builder()
            .dataId(dataId.applyValue({ args0 -> args0 }))
            .negated(negated.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RulePredicateArgs].
 */
@PulumiTagMarker
public class RulePredicateArgsBuilder internal constructor() {
    private var dataId: Output<String>? = null

    private var negated: Output<Boolean>? = null

    private var type: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("siashelpdfonmdoj")
    public suspend fun dataId(`value`: Output<String>) {
        this.dataId = value
    }

    /**
     * @param value
     */
    @JvmName("pdxpwweqowwpibhq")
    public suspend fun negated(`value`: Output<Boolean>) {
        this.negated = value
    }

    /**
     * @param value
     */
    @JvmName("bagglmyrwuqvymik")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value
     */
    @JvmName("yvnqikqkcgyvhpea")
    public suspend fun dataId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataId = mapped
    }

    /**
     * @param value
     */
    @JvmName("kymkoidgoawnhtwo")
    public suspend fun negated(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.negated = mapped
    }

    /**
     * @param value
     */
    @JvmName("okpomdvhjptqbxmn")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): RulePredicateArgs = RulePredicateArgs(
        dataId = dataId ?: throw PulumiNullFieldException("dataId"),
        negated = negated ?: throw PulumiNullFieldException("negated"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
