@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafregional.kotlin.inputs

import com.pulumi.aws.wafregional.inputs.SizeConstraintSetSizeConstraintArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property comparisonOperator The type of comparison you want to perform.
 * e.g., `EQ`, `NE`, `LT`, `GT`.
 * See [docs](https://docs.aws.amazon.com/waf/latest/APIReference/API_wafRegional_SizeConstraint.html) for all supported values.
 * @property fieldToMatch Specifies where in a web request to look for the size constraint.
 * @property size The size in bytes that you want to compare against the size of the specified `field_to_match`.
 * Valid values are between 0 - 21474836480 bytes (0 - 20 GB).
 * @property textTransformation Text transformations used to eliminate unusual formatting that attackers use in web requests in an effort to bypass AWS WAF.
 * If you specify a transformation, AWS WAF performs the transformation on `field_to_match` before inspecting a request for a match.
 * e.g., `CMD_LINE`, `HTML_ENTITY_DECODE` or `NONE`.
 * See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_SizeConstraint.html#WAF-Type-SizeConstraint-TextTransformation)
 * for all supported values.
 * **Note:** if you choose `BODY` as `type`, you must choose `NONE` because CloudFront forwards only the first 8192 bytes for inspection.
 */
public data class SizeConstraintSetSizeConstraintArgs(
    public val comparisonOperator: Output<String>,
    public val fieldToMatch: Output<SizeConstraintSetSizeConstraintFieldToMatchArgs>,
    public val size: Output<Int>,
    public val textTransformation: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.wafregional.inputs.SizeConstraintSetSizeConstraintArgs> {
    override fun toJava(): com.pulumi.aws.wafregional.inputs.SizeConstraintSetSizeConstraintArgs =
        com.pulumi.aws.wafregional.inputs.SizeConstraintSetSizeConstraintArgs.builder()
            .comparisonOperator(comparisonOperator.applyValue({ args0 -> args0 }))
            .fieldToMatch(fieldToMatch.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .size(size.applyValue({ args0 -> args0 }))
            .textTransformation(textTransformation.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SizeConstraintSetSizeConstraintArgs].
 */
@PulumiTagMarker
public class SizeConstraintSetSizeConstraintArgsBuilder internal constructor() {
    private var comparisonOperator: Output<String>? = null

    private var fieldToMatch: Output<SizeConstraintSetSizeConstraintFieldToMatchArgs>? = null

    private var size: Output<Int>? = null

    private var textTransformation: Output<String>? = null

    /**
     * @param value The type of comparison you want to perform.
     * e.g., `EQ`, `NE`, `LT`, `GT`.
     * See [docs](https://docs.aws.amazon.com/waf/latest/APIReference/API_wafRegional_SizeConstraint.html) for all supported values.
     */
    @JvmName("etakmbohkmiqamha")
    public suspend fun comparisonOperator(`value`: Output<String>) {
        this.comparisonOperator = value
    }

    /**
     * @param value Specifies where in a web request to look for the size constraint.
     */
    @JvmName("cdaoccbttucyhpgq")
    public suspend fun fieldToMatch(`value`: Output<SizeConstraintSetSizeConstraintFieldToMatchArgs>) {
        this.fieldToMatch = value
    }

    /**
     * @param value The size in bytes that you want to compare against the size of the specified `field_to_match`.
     * Valid values are between 0 - 21474836480 bytes (0 - 20 GB).
     */
    @JvmName("kbsgfqciomhxcxko")
    public suspend fun size(`value`: Output<Int>) {
        this.size = value
    }

    /**
     * @param value Text transformations used to eliminate unusual formatting that attackers use in web requests in an effort to bypass AWS WAF.
     * If you specify a transformation, AWS WAF performs the transformation on `field_to_match` before inspecting a request for a match.
     * e.g., `CMD_LINE`, `HTML_ENTITY_DECODE` or `NONE`.
     * See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_SizeConstraint.html#WAF-Type-SizeConstraint-TextTransformation)
     * for all supported values.
     * **Note:** if you choose `BODY` as `type`, you must choose `NONE` because CloudFront forwards only the first 8192 bytes for inspection.
     */
    @JvmName("mnimujbannpcchbu")
    public suspend fun textTransformation(`value`: Output<String>) {
        this.textTransformation = value
    }

    /**
     * @param value The type of comparison you want to perform.
     * e.g., `EQ`, `NE`, `LT`, `GT`.
     * See [docs](https://docs.aws.amazon.com/waf/latest/APIReference/API_wafRegional_SizeConstraint.html) for all supported values.
     */
    @JvmName("dufpgvuhmxidyijo")
    public suspend fun comparisonOperator(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.comparisonOperator = mapped
    }

    /**
     * @param value Specifies where in a web request to look for the size constraint.
     */
    @JvmName("mbyhtwsnglafwdhr")
    public suspend fun fieldToMatch(`value`: SizeConstraintSetSizeConstraintFieldToMatchArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fieldToMatch = mapped
    }

    /**
     * @param argument Specifies where in a web request to look for the size constraint.
     */
    @JvmName("noynpfaxcbcvoaor")
    public suspend fun fieldToMatch(argument: suspend SizeConstraintSetSizeConstraintFieldToMatchArgsBuilder.() -> Unit) {
        val toBeMapped = SizeConstraintSetSizeConstraintFieldToMatchArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.fieldToMatch = mapped
    }

    /**
     * @param value The size in bytes that you want to compare against the size of the specified `field_to_match`.
     * Valid values are between 0 - 21474836480 bytes (0 - 20 GB).
     */
    @JvmName("qhjrxyjsshdptwfx")
    public suspend fun size(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value Text transformations used to eliminate unusual formatting that attackers use in web requests in an effort to bypass AWS WAF.
     * If you specify a transformation, AWS WAF performs the transformation on `field_to_match` before inspecting a request for a match.
     * e.g., `CMD_LINE`, `HTML_ENTITY_DECODE` or `NONE`.
     * See [docs](http://docs.aws.amazon.com/waf/latest/APIReference/API_SizeConstraint.html#WAF-Type-SizeConstraint-TextTransformation)
     * for all supported values.
     * **Note:** if you choose `BODY` as `type`, you must choose `NONE` because CloudFront forwards only the first 8192 bytes for inspection.
     */
    @JvmName("gbxidjbxjbqxhork")
    public suspend fun textTransformation(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformation = mapped
    }

    internal fun build(): SizeConstraintSetSizeConstraintArgs = SizeConstraintSetSizeConstraintArgs(
        comparisonOperator = comparisonOperator ?: throw PulumiNullFieldException("comparisonOperator"),
        fieldToMatch = fieldToMatch ?: throw PulumiNullFieldException("fieldToMatch"),
        size = size ?: throw PulumiNullFieldException("size"),
        textTransformation = textTransformation ?: throw PulumiNullFieldException("textTransformation"),
    )
}
