@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafregional.kotlin.inputs

import com.pulumi.aws.wafregional.inputs.WebAclLoggingConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property logDestination Amazon Resource Name (ARN) of Kinesis Firehose Delivery Stream
 * @property redactedFields Configuration block containing parts of the request that you want redacted from the logs. Detailed below.
 */
public data class WebAclLoggingConfigurationArgs(
    public val logDestination: Output<String>,
    public val redactedFields: Output<WebAclLoggingConfigurationRedactedFieldsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafregional.inputs.WebAclLoggingConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.wafregional.inputs.WebAclLoggingConfigurationArgs =
        com.pulumi.aws.wafregional.inputs.WebAclLoggingConfigurationArgs.builder()
            .logDestination(logDestination.applyValue({ args0 -> args0 }))
            .redactedFields(
                redactedFields?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclLoggingConfigurationArgs].
 */
@PulumiTagMarker
public class WebAclLoggingConfigurationArgsBuilder internal constructor() {
    private var logDestination: Output<String>? = null

    private var redactedFields: Output<WebAclLoggingConfigurationRedactedFieldsArgs>? = null

    /**
     * @param value Amazon Resource Name (ARN) of Kinesis Firehose Delivery Stream
     */
    @JvmName("yikbjeyfdmadsbxr")
    public suspend fun logDestination(`value`: Output<String>) {
        this.logDestination = value
    }

    /**
     * @param value Configuration block containing parts of the request that you want redacted from the logs. Detailed below.
     */
    @JvmName("qspmfplmtorevbdn")
    public suspend fun redactedFields(`value`: Output<WebAclLoggingConfigurationRedactedFieldsArgs>) {
        this.redactedFields = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of Kinesis Firehose Delivery Stream
     */
    @JvmName("pvdrxmrbgftxoddv")
    public suspend fun logDestination(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logDestination = mapped
    }

    /**
     * @param value Configuration block containing parts of the request that you want redacted from the logs. Detailed below.
     */
    @JvmName("glkowbiudtbxuwhp")
    public suspend fun redactedFields(`value`: WebAclLoggingConfigurationRedactedFieldsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redactedFields = mapped
    }

    /**
     * @param argument Configuration block containing parts of the request that you want redacted from the logs. Detailed below.
     */
    @JvmName("grmdjhrodcxtetjm")
    public suspend fun redactedFields(argument: suspend WebAclLoggingConfigurationRedactedFieldsArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclLoggingConfigurationRedactedFieldsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.redactedFields = mapped
    }

    internal fun build(): WebAclLoggingConfigurationArgs = WebAclLoggingConfigurationArgs(
        logDestination = logDestination ?: throw PulumiNullFieldException("logDestination"),
        redactedFields = redactedFields,
    )
}
