@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafregional.kotlin.inputs

import com.pulumi.aws.wafregional.inputs.WebAclLoggingConfigurationRedactedFieldsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property fieldToMatches Set of configuration blocks for fields to redact. Detailed below.
 */
public data class WebAclLoggingConfigurationRedactedFieldsArgs(
    public val fieldToMatches: Output<List<WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgs>>,
) :
    ConvertibleToJava<com.pulumi.aws.wafregional.inputs.WebAclLoggingConfigurationRedactedFieldsArgs> {
    override fun toJava(): com.pulumi.aws.wafregional.inputs.WebAclLoggingConfigurationRedactedFieldsArgs =
        com.pulumi.aws.wafregional.inputs.WebAclLoggingConfigurationRedactedFieldsArgs.builder()
            .fieldToMatches(
                fieldToMatches.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclLoggingConfigurationRedactedFieldsArgs].
 */
@PulumiTagMarker
public class WebAclLoggingConfigurationRedactedFieldsArgsBuilder internal constructor() {
    private var fieldToMatches:
        Output<List<WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgs>>? = null

    /**
     * @param value Set of configuration blocks for fields to redact. Detailed below.
     */
    @JvmName("egeodbocekenqwyk")
    public suspend fun fieldToMatches(`value`: Output<List<WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgs>>) {
        this.fieldToMatches = value
    }

    @JvmName("eluhthybdcpndsxe")
    public suspend fun fieldToMatches(vararg values: Output<WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgs>) {
        this.fieldToMatches = Output.all(values.asList())
    }

    /**
     * @param values Set of configuration blocks for fields to redact. Detailed below.
     */
    @JvmName("lqayjdbgeklbfwvi")
    public suspend fun fieldToMatches(values: List<Output<WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgs>>) {
        this.fieldToMatches = Output.all(values)
    }

    /**
     * @param value Set of configuration blocks for fields to redact. Detailed below.
     */
    @JvmName("pvifkysujfxmyvno")
    public suspend fun fieldToMatches(`value`: List<WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fieldToMatches = mapped
    }

    /**
     * @param argument Set of configuration blocks for fields to redact. Detailed below.
     */
    @JvmName("tvfxffqtbwkblvdn")
    public suspend fun fieldToMatches(argument: List<suspend WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.fieldToMatches = mapped
    }

    /**
     * @param argument Set of configuration blocks for fields to redact. Detailed below.
     */
    @JvmName("fevraudsuiafdowu")
    public suspend fun fieldToMatches(vararg argument: suspend WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.fieldToMatches = mapped
    }

    /**
     * @param argument Set of configuration blocks for fields to redact. Detailed below.
     */
    @JvmName("xcsrrnknowisuimm")
    public suspend fun fieldToMatches(argument: suspend WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.fieldToMatches = mapped
    }

    /**
     * @param values Set of configuration blocks for fields to redact. Detailed below.
     */
    @JvmName("yijojiwmxpxscrkt")
    public suspend fun fieldToMatches(vararg values: WebAclLoggingConfigurationRedactedFieldsFieldToMatchArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fieldToMatches = mapped
    }

    internal fun build(): WebAclLoggingConfigurationRedactedFieldsArgs =
        WebAclLoggingConfigurationRedactedFieldsArgs(
            fieldToMatches = fieldToMatches ?: throw PulumiNullFieldException("fieldToMatches"),
        )
}
