@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafregional.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property fieldToMatch Specifies where in a web request to look for cross-site scripting attacks.
 * @property textTransformation Which text transformation, if any, to perform on the web request before inspecting the request for cross-site scripting attacks.
 */
public data class XssMatchSetXssMatchTuple(
    public val fieldToMatch: XssMatchSetXssMatchTupleFieldToMatch,
    public val textTransformation: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.wafregional.outputs.XssMatchSetXssMatchTuple): XssMatchSetXssMatchTuple = XssMatchSetXssMatchTuple(
            fieldToMatch = javaType.fieldToMatch().let({ args0 ->
                com.pulumi.aws.wafregional.kotlin.outputs.XssMatchSetXssMatchTupleFieldToMatch.Companion.toKotlin(args0)
            }),
            textTransformation = javaType.textTransformation(),
        )
    }
}
