@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [IpSet].
 */
@PulumiTagMarker
public class IpSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IpSetArgs = IpSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IpSetArgsBuilder.() -> Unit) {
        val builder = IpSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IpSet {
        val builtJavaResource = com.pulumi.aws.wafv2.IpSet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return IpSet(builtJavaResource)
    }
}

/**
 * Provides a WAFv2 IP Set Resource
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.wafv2.IpSet("example", {
 *     name: "example",
 *     description: "Example IP set",
 *     scope: "REGIONAL",
 *     ipAddressVersion: "IPV4",
 *     addresses: [
 *         "1.2.3.4/32",
 *         "5.6.7.8/32",
 *     ],
 *     tags: {
 *         Tag1: "Value1",
 *         Tag2: "Value2",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.wafv2.IpSet("example",
 *     name="example",
 *     description="Example IP set",
 *     scope="REGIONAL",
 *     ip_address_version="IPV4",
 *     addresses=[
 *         "1.2.3.4/32",
 *         "5.6.7.8/32",
 *     ],
 *     tags={
 *         "Tag1": "Value1",
 *         "Tag2": "Value2",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.WafV2.IpSet("example", new()
 *     {
 *         Name = "example",
 *         Description = "Example IP set",
 *         Scope = "REGIONAL",
 *         IpAddressVersion = "IPV4",
 *         Addresses = new[]
 *         {
 *             "1.2.3.4/32",
 *             "5.6.7.8/32",
 *         },
 *         Tags =
 *         {
 *             { "Tag1", "Value1" },
 *             { "Tag2", "Value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/wafv2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := wafv2.NewIpSet(ctx, "example", &wafv2.IpSetArgs{
 * 			Name:             pulumi.String("example"),
 * 			Description:      pulumi.String("Example IP set"),
 * 			Scope:            pulumi.String("REGIONAL"),
 * 			IpAddressVersion: pulumi.String("IPV4"),
 * 			Addresses: pulumi.StringArray{
 * 				pulumi.String("1.2.3.4/32"),
 * 				pulumi.String("5.6.7.8/32"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Tag1": pulumi.String("Value1"),
 * 				"Tag2": pulumi.String("Value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.wafv2.IpSet;
 * import com.pulumi.aws.wafv2.IpSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new IpSet("example", IpSetArgs.builder()
 *             .name("example")
 *             .description("Example IP set")
 *             .scope("REGIONAL")
 *             .ipAddressVersion("IPV4")
 *             .addresses(
 *                 "1.2.3.4/32",
 *                 "5.6.7.8/32")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Tag1", "Value1"),
 *                 Map.entry("Tag2", "Value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:wafv2:IpSet
 *     properties:
 *       name: example
 *       description: Example IP set
 *       scope: REGIONAL
 *       ipAddressVersion: IPV4
 *       addresses:
 *         - 1.2.3.4/32
 *         - 5.6.7.8/32
 *       tags:
 *         Tag1: Value1
 *         Tag2: Value2
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import WAFv2 IP Sets using `ID/name/scope`. For example:
 * ```sh
 * $ pulumi import aws:wafv2/ipSet:IpSet example a1b2c3d4-d5f6-7777-8888-9999aaaabbbbcccc/example/REGIONAL
 * ```
 */
public class IpSet internal constructor(
    override val javaResource: com.pulumi.aws.wafv2.IpSet,
) : KotlinCustomResource(javaResource, IpSetMapper) {
    /**
     * Contains an array of strings that specifies zero or more IP addresses or blocks of IP addresses. All addresses must be specified using Classless Inter-Domain Routing (CIDR) notation. WAF supports all IPv4 and IPv6 CIDR ranges except for `/0`.
     */
    public val addresses: Output<List<String>>?
        get() = javaResource.addresses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The Amazon Resource Name (ARN) of the IP set.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A friendly description of the IP set.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specify IPV4 or IPV6. Valid values are `IPV4` or `IPV6`.
     */
    public val ipAddressVersion: Output<String>
        get() = javaResource.ipAddressVersion().applyValue({ args0 -> args0 })

    public val lockToken: Output<String>
        get() = javaResource.lockToken().applyValue({ args0 -> args0 })

    /**
     * A friendly name of the IP set.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Specifies whether this is for an AWS CloudFront distribution or for a regional application. Valid values are `CLOUDFRONT` or `REGIONAL`. To work with CloudFront, you must also specify the Region US East (N. Virginia).
     */
    public val scope: Output<String>
        get() = javaResource.scope().applyValue({ args0 -> args0 })

    /**
     * An array of key:value pairs to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object IpSetMapper : ResourceMapper<IpSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.wafv2.IpSet::class == javaResource::class

    override fun map(javaResource: Resource): IpSet = IpSet(
        javaResource as
            com.pulumi.aws.wafv2.IpSet,
    )
}

/**
 * @see [IpSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IpSet].
 */
public suspend fun ipSet(name: String, block: suspend IpSetResourceBuilder.() -> Unit): IpSet {
    val builder = IpSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IpSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ipSet(name: String): IpSet {
    val builder = IpSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
