@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin

import com.pulumi.aws.wafv2.IpSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a WAFv2 IP Set Resource
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.wafv2.IpSet("example", {
 *     name: "example",
 *     description: "Example IP set",
 *     scope: "REGIONAL",
 *     ipAddressVersion: "IPV4",
 *     addresses: [
 *         "1.2.3.4/32",
 *         "5.6.7.8/32",
 *     ],
 *     tags: {
 *         Tag1: "Value1",
 *         Tag2: "Value2",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.wafv2.IpSet("example",
 *     name="example",
 *     description="Example IP set",
 *     scope="REGIONAL",
 *     ip_address_version="IPV4",
 *     addresses=[
 *         "1.2.3.4/32",
 *         "5.6.7.8/32",
 *     ],
 *     tags={
 *         "Tag1": "Value1",
 *         "Tag2": "Value2",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.WafV2.IpSet("example", new()
 *     {
 *         Name = "example",
 *         Description = "Example IP set",
 *         Scope = "REGIONAL",
 *         IpAddressVersion = "IPV4",
 *         Addresses = new[]
 *         {
 *             "1.2.3.4/32",
 *             "5.6.7.8/32",
 *         },
 *         Tags =
 *         {
 *             { "Tag1", "Value1" },
 *             { "Tag2", "Value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/wafv2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := wafv2.NewIpSet(ctx, "example", &wafv2.IpSetArgs{
 * 			Name:             pulumi.String("example"),
 * 			Description:      pulumi.String("Example IP set"),
 * 			Scope:            pulumi.String("REGIONAL"),
 * 			IpAddressVersion: pulumi.String("IPV4"),
 * 			Addresses: pulumi.StringArray{
 * 				pulumi.String("1.2.3.4/32"),
 * 				pulumi.String("5.6.7.8/32"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Tag1": pulumi.String("Value1"),
 * 				"Tag2": pulumi.String("Value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.wafv2.IpSet;
 * import com.pulumi.aws.wafv2.IpSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new IpSet("example", IpSetArgs.builder()
 *             .name("example")
 *             .description("Example IP set")
 *             .scope("REGIONAL")
 *             .ipAddressVersion("IPV4")
 *             .addresses(
 *                 "1.2.3.4/32",
 *                 "5.6.7.8/32")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Tag1", "Value1"),
 *                 Map.entry("Tag2", "Value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:wafv2:IpSet
 *     properties:
 *       name: example
 *       description: Example IP set
 *       scope: REGIONAL
 *       ipAddressVersion: IPV4
 *       addresses:
 *         - 1.2.3.4/32
 *         - 5.6.7.8/32
 *       tags:
 *         Tag1: Value1
 *         Tag2: Value2
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import WAFv2 IP Sets using `ID/name/scope`. For example:
 * ```sh
 * $ pulumi import aws:wafv2/ipSet:IpSet example a1b2c3d4-d5f6-7777-8888-9999aaaabbbbcccc/example/REGIONAL
 * ```
 * @property addresses Contains an array of strings that specifies zero or more IP addresses or blocks of IP addresses. All addresses must be specified using Classless Inter-Domain Routing (CIDR) notation. WAF supports all IPv4 and IPv6 CIDR ranges except for `/0`.
 * @property description A friendly description of the IP set.
 * @property ipAddressVersion Specify IPV4 or IPV6. Valid values are `IPV4` or `IPV6`.
 * @property name A friendly name of the IP set.
 * @property scope Specifies whether this is for an AWS CloudFront distribution or for a regional application. Valid values are `CLOUDFRONT` or `REGIONAL`. To work with CloudFront, you must also specify the Region US East (N. Virginia).
 * @property tags An array of key:value pairs to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class IpSetArgs(
    public val addresses: Output<List<String>>? = null,
    public val description: Output<String>? = null,
    public val ipAddressVersion: Output<String>? = null,
    public val name: Output<String>? = null,
    public val scope: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.IpSetArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.IpSetArgs = com.pulumi.aws.wafv2.IpSetArgs.builder()
        .addresses(addresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .description(description?.applyValue({ args0 -> args0 }))
        .ipAddressVersion(ipAddressVersion?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .scope(scope?.applyValue({ args0 -> args0 }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [IpSetArgs].
 */
@PulumiTagMarker
public class IpSetArgsBuilder internal constructor() {
    private var addresses: Output<List<String>>? = null

    private var description: Output<String>? = null

    private var ipAddressVersion: Output<String>? = null

    private var name: Output<String>? = null

    private var scope: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Contains an array of strings that specifies zero or more IP addresses or blocks of IP addresses. All addresses must be specified using Classless Inter-Domain Routing (CIDR) notation. WAF supports all IPv4 and IPv6 CIDR ranges except for `/0`.
     */
    @JvmName("aocfipvgqarfhmkq")
    public suspend fun addresses(`value`: Output<List<String>>) {
        this.addresses = value
    }

    @JvmName("qtwbbxgtawlhhhwh")
    public suspend fun addresses(vararg values: Output<String>) {
        this.addresses = Output.all(values.asList())
    }

    /**
     * @param values Contains an array of strings that specifies zero or more IP addresses or blocks of IP addresses. All addresses must be specified using Classless Inter-Domain Routing (CIDR) notation. WAF supports all IPv4 and IPv6 CIDR ranges except for `/0`.
     */
    @JvmName("fawljgvhekwtfejx")
    public suspend fun addresses(values: List<Output<String>>) {
        this.addresses = Output.all(values)
    }

    /**
     * @param value A friendly description of the IP set.
     */
    @JvmName("bnvpuubqclcekdqi")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specify IPV4 or IPV6. Valid values are `IPV4` or `IPV6`.
     */
    @JvmName("xjfrwpytoifvsoas")
    public suspend fun ipAddressVersion(`value`: Output<String>) {
        this.ipAddressVersion = value
    }

    /**
     * @param value A friendly name of the IP set.
     */
    @JvmName("tpfjmtdgngjtgvlh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies whether this is for an AWS CloudFront distribution or for a regional application. Valid values are `CLOUDFRONT` or `REGIONAL`. To work with CloudFront, you must also specify the Region US East (N. Virginia).
     */
    @JvmName("sdsyfvaexgynavrk")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value An array of key:value pairs to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vdodmjwwfmhomilv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Contains an array of strings that specifies zero or more IP addresses or blocks of IP addresses. All addresses must be specified using Classless Inter-Domain Routing (CIDR) notation. WAF supports all IPv4 and IPv6 CIDR ranges except for `/0`.
     */
    @JvmName("xilygamyyymbgasu")
    public suspend fun addresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addresses = mapped
    }

    /**
     * @param values Contains an array of strings that specifies zero or more IP addresses or blocks of IP addresses. All addresses must be specified using Classless Inter-Domain Routing (CIDR) notation. WAF supports all IPv4 and IPv6 CIDR ranges except for `/0`.
     */
    @JvmName("gymqpsakbkncseny")
    public suspend fun addresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addresses = mapped
    }

    /**
     * @param value A friendly description of the IP set.
     */
    @JvmName("mmilstrncdondlxk")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specify IPV4 or IPV6. Valid values are `IPV4` or `IPV6`.
     */
    @JvmName("jnlhslpxrcuxajqk")
    public suspend fun ipAddressVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAddressVersion = mapped
    }

    /**
     * @param value A friendly name of the IP set.
     */
    @JvmName("nbwwhhnrbmlxurwd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies whether this is for an AWS CloudFront distribution or for a regional application. Valid values are `CLOUDFRONT` or `REGIONAL`. To work with CloudFront, you must also specify the Region US East (N. Virginia).
     */
    @JvmName("wqpginknjindsdqo")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value An array of key:value pairs to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ihdatrbxuiwyqkhe")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values An array of key:value pairs to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qbkftrxmregbschh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): IpSetArgs = IpSetArgs(
        addresses = addresses,
        description = description,
        ipAddressVersion = ipAddressVersion,
        name = name,
        scope = scope,
        tags = tags,
    )
}
