@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin

import com.pulumi.aws.wafv2.kotlin.outputs.RegexPatternSetRegularExpression
import com.pulumi.aws.wafv2.kotlin.outputs.RegexPatternSetRegularExpression.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [RegexPatternSet].
 */
@PulumiTagMarker
public class RegexPatternSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RegexPatternSetArgs = RegexPatternSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RegexPatternSetArgsBuilder.() -> Unit) {
        val builder = RegexPatternSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RegexPatternSet {
        val builtJavaResource = com.pulumi.aws.wafv2.RegexPatternSet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RegexPatternSet(builtJavaResource)
    }
}

/**
 * Provides an AWS WAFv2 Regex Pattern Set Resource
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.wafv2.RegexPatternSet("example", {
 *     name: "example",
 *     description: "Example regex pattern set",
 *     scope: "REGIONAL",
 *     regularExpressions: [
 *         {
 *             regexString: "one",
 *         },
 *         {
 *             regexString: "two",
 *         },
 *     ],
 *     tags: {
 *         Tag1: "Value1",
 *         Tag2: "Value2",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.wafv2.RegexPatternSet("example",
 *     name="example",
 *     description="Example regex pattern set",
 *     scope="REGIONAL",
 *     regular_expressions=[
 *         {
 *             "regex_string": "one",
 *         },
 *         {
 *             "regex_string": "two",
 *         },
 *     ],
 *     tags={
 *         "Tag1": "Value1",
 *         "Tag2": "Value2",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.WafV2.RegexPatternSet("example", new()
 *     {
 *         Name = "example",
 *         Description = "Example regex pattern set",
 *         Scope = "REGIONAL",
 *         RegularExpressions = new[]
 *         {
 *             new Aws.WafV2.Inputs.RegexPatternSetRegularExpressionArgs
 *             {
 *                 RegexString = "one",
 *             },
 *             new Aws.WafV2.Inputs.RegexPatternSetRegularExpressionArgs
 *             {
 *                 RegexString = "two",
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Tag1", "Value1" },
 *             { "Tag2", "Value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/wafv2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := wafv2.NewRegexPatternSet(ctx, "example", &wafv2.RegexPatternSetArgs{
 * 			Name:        pulumi.String("example"),
 * 			Description: pulumi.String("Example regex pattern set"),
 * 			Scope:       pulumi.String("REGIONAL"),
 * 			RegularExpressions: wafv2.RegexPatternSetRegularExpressionArray{
 * 				&wafv2.RegexPatternSetRegularExpressionArgs{
 * 					RegexString: pulumi.String("one"),
 * 				},
 * 				&wafv2.RegexPatternSetRegularExpressionArgs{
 * 					RegexString: pulumi.String("two"),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Tag1": pulumi.String("Value1"),
 * 				"Tag2": pulumi.String("Value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.wafv2.RegexPatternSet;
 * import com.pulumi.aws.wafv2.RegexPatternSetArgs;
 * import com.pulumi.aws.wafv2.inputs.RegexPatternSetRegularExpressionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RegexPatternSet("example", RegexPatternSetArgs.builder()
 *             .name("example")
 *             .description("Example regex pattern set")
 *             .scope("REGIONAL")
 *             .regularExpressions(
 *                 RegexPatternSetRegularExpressionArgs.builder()
 *                     .regexString("one")
 *                     .build(),
 *                 RegexPatternSetRegularExpressionArgs.builder()
 *                     .regexString("two")
 *                     .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Tag1", "Value1"),
 *                 Map.entry("Tag2", "Value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:wafv2:RegexPatternSet
 *     properties:
 *       name: example
 *       description: Example regex pattern set
 *       scope: REGIONAL
 *       regularExpressions:
 *         - regexString: one
 *         - regexString: two
 *       tags:
 *         Tag1: Value1
 *         Tag2: Value2
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import WAFv2 Regex Pattern Sets using `ID/name/scope`. For example:
 * ```sh
 * $ pulumi import aws:wafv2/regexPatternSet:RegexPatternSet example a1b2c3d4-d5f6-7777-8888-9999aaaabbbbcccc/example/REGIONAL
 * ```
 */
public class RegexPatternSet internal constructor(
    override val javaResource: com.pulumi.aws.wafv2.RegexPatternSet,
) : KotlinCustomResource(javaResource, RegexPatternSetMapper) {
    /**
     * The Amazon Resource Name (ARN) that identifies the cluster.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A friendly description of the regular expression pattern set.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val lockToken: Output<String>
        get() = javaResource.lockToken().applyValue({ args0 -> args0 })

    /**
     * A friendly name of the regular expression pattern set.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * One or more blocks of regular expression patterns that you want AWS WAF to search for, such as `B[a@]dB[o0]t`. See Regular Expression below for details. A maximum of 10 `regular_expression` blocks may be specified.
     */
    public val regularExpressions: Output<List<RegexPatternSetRegularExpression>>?
        get() = javaResource.regularExpressions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
            }).orElse(null)
        })

    /**
     * Specifies whether this is for an AWS CloudFront distribution or for a regional application. Valid values are `CLOUDFRONT` or `REGIONAL`. To work with CloudFront, you must also specify the region `us-east-1` (N. Virginia) on the AWS provider.
     */
    public val scope: Output<String>
        get() = javaResource.scope().applyValue({ args0 -> args0 })

    /**
     * An array of key:value pairs to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object RegexPatternSetMapper : ResourceMapper<RegexPatternSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.wafv2.RegexPatternSet::class == javaResource::class

    override fun map(javaResource: Resource): RegexPatternSet = RegexPatternSet(
        javaResource as
            com.pulumi.aws.wafv2.RegexPatternSet,
    )
}

/**
 * @see [RegexPatternSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RegexPatternSet].
 */
public suspend fun regexPatternSet(
    name: String,
    block: suspend RegexPatternSetResourceBuilder.() -> Unit,
): RegexPatternSet {
    val builder = RegexPatternSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RegexPatternSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun regexPatternSet(name: String): RegexPatternSet {
    val builder = RegexPatternSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
