@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin

import com.pulumi.aws.wafv2.RegexPatternSetArgs.builder
import com.pulumi.aws.wafv2.kotlin.inputs.RegexPatternSetRegularExpressionArgs
import com.pulumi.aws.wafv2.kotlin.inputs.RegexPatternSetRegularExpressionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AWS WAFv2 Regex Pattern Set Resource
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.wafv2.RegexPatternSet("example", {
 *     name: "example",
 *     description: "Example regex pattern set",
 *     scope: "REGIONAL",
 *     regularExpressions: [
 *         {
 *             regexString: "one",
 *         },
 *         {
 *             regexString: "two",
 *         },
 *     ],
 *     tags: {
 *         Tag1: "Value1",
 *         Tag2: "Value2",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.wafv2.RegexPatternSet("example",
 *     name="example",
 *     description="Example regex pattern set",
 *     scope="REGIONAL",
 *     regular_expressions=[
 *         {
 *             "regex_string": "one",
 *         },
 *         {
 *             "regex_string": "two",
 *         },
 *     ],
 *     tags={
 *         "Tag1": "Value1",
 *         "Tag2": "Value2",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.WafV2.RegexPatternSet("example", new()
 *     {
 *         Name = "example",
 *         Description = "Example regex pattern set",
 *         Scope = "REGIONAL",
 *         RegularExpressions = new[]
 *         {
 *             new Aws.WafV2.Inputs.RegexPatternSetRegularExpressionArgs
 *             {
 *                 RegexString = "one",
 *             },
 *             new Aws.WafV2.Inputs.RegexPatternSetRegularExpressionArgs
 *             {
 *                 RegexString = "two",
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Tag1", "Value1" },
 *             { "Tag2", "Value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/wafv2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := wafv2.NewRegexPatternSet(ctx, "example", &wafv2.RegexPatternSetArgs{
 * 			Name:        pulumi.String("example"),
 * 			Description: pulumi.String("Example regex pattern set"),
 * 			Scope:       pulumi.String("REGIONAL"),
 * 			RegularExpressions: wafv2.RegexPatternSetRegularExpressionArray{
 * 				&wafv2.RegexPatternSetRegularExpressionArgs{
 * 					RegexString: pulumi.String("one"),
 * 				},
 * 				&wafv2.RegexPatternSetRegularExpressionArgs{
 * 					RegexString: pulumi.String("two"),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Tag1": pulumi.String("Value1"),
 * 				"Tag2": pulumi.String("Value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.wafv2.RegexPatternSet;
 * import com.pulumi.aws.wafv2.RegexPatternSetArgs;
 * import com.pulumi.aws.wafv2.inputs.RegexPatternSetRegularExpressionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RegexPatternSet("example", RegexPatternSetArgs.builder()
 *             .name("example")
 *             .description("Example regex pattern set")
 *             .scope("REGIONAL")
 *             .regularExpressions(
 *                 RegexPatternSetRegularExpressionArgs.builder()
 *                     .regexString("one")
 *                     .build(),
 *                 RegexPatternSetRegularExpressionArgs.builder()
 *                     .regexString("two")
 *                     .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Tag1", "Value1"),
 *                 Map.entry("Tag2", "Value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:wafv2:RegexPatternSet
 *     properties:
 *       name: example
 *       description: Example regex pattern set
 *       scope: REGIONAL
 *       regularExpressions:
 *         - regexString: one
 *         - regexString: two
 *       tags:
 *         Tag1: Value1
 *         Tag2: Value2
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import WAFv2 Regex Pattern Sets using `ID/name/scope`. For example:
 * ```sh
 * $ pulumi import aws:wafv2/regexPatternSet:RegexPatternSet example a1b2c3d4-d5f6-7777-8888-9999aaaabbbbcccc/example/REGIONAL
 * ```
 * @property description A friendly description of the regular expression pattern set.
 * @property name A friendly name of the regular expression pattern set.
 * @property regularExpressions One or more blocks of regular expression patterns that you want AWS WAF to search for, such as `B[a@]dB[o0]t`. See Regular Expression below for details. A maximum of 10 `regular_expression` blocks may be specified.
 * @property scope Specifies whether this is for an AWS CloudFront distribution or for a regional application. Valid values are `CLOUDFRONT` or `REGIONAL`. To work with CloudFront, you must also specify the region `us-east-1` (N. Virginia) on the AWS provider.
 * @property tags An array of key:value pairs to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class RegexPatternSetArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val regularExpressions: Output<List<RegexPatternSetRegularExpressionArgs>>? = null,
    public val scope: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.RegexPatternSetArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.RegexPatternSetArgs =
        com.pulumi.aws.wafv2.RegexPatternSetArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .regularExpressions(
                regularExpressions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .scope(scope?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [RegexPatternSetArgs].
 */
@PulumiTagMarker
public class RegexPatternSetArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var regularExpressions: Output<List<RegexPatternSetRegularExpressionArgs>>? = null

    private var scope: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A friendly description of the regular expression pattern set.
     */
    @JvmName("qvcyxdslpovrosdt")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value A friendly name of the regular expression pattern set.
     */
    @JvmName("topigprdbsohvfbd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value One or more blocks of regular expression patterns that you want AWS WAF to search for, such as `B[a@]dB[o0]t`. See Regular Expression below for details. A maximum of 10 `regular_expression` blocks may be specified.
     */
    @JvmName("tmbosqblgatiimkn")
    public suspend fun regularExpressions(`value`: Output<List<RegexPatternSetRegularExpressionArgs>>) {
        this.regularExpressions = value
    }

    @JvmName("hnimwsmjtigklowl")
    public suspend fun regularExpressions(vararg values: Output<RegexPatternSetRegularExpressionArgs>) {
        this.regularExpressions = Output.all(values.asList())
    }

    /**
     * @param values One or more blocks of regular expression patterns that you want AWS WAF to search for, such as `B[a@]dB[o0]t`. See Regular Expression below for details. A maximum of 10 `regular_expression` blocks may be specified.
     */
    @JvmName("kdfbvmhgqdktnlyv")
    public suspend fun regularExpressions(values: List<Output<RegexPatternSetRegularExpressionArgs>>) {
        this.regularExpressions = Output.all(values)
    }

    /**
     * @param value Specifies whether this is for an AWS CloudFront distribution or for a regional application. Valid values are `CLOUDFRONT` or `REGIONAL`. To work with CloudFront, you must also specify the region `us-east-1` (N. Virginia) on the AWS provider.
     */
    @JvmName("picqwrhohdsjttkj")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value An array of key:value pairs to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pbvxtodxowhoedai")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A friendly description of the regular expression pattern set.
     */
    @JvmName("hjqrlahyhkdtgbqw")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value A friendly name of the regular expression pattern set.
     */
    @JvmName("tfpjugqnxtbdmyvw")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value One or more blocks of regular expression patterns that you want AWS WAF to search for, such as `B[a@]dB[o0]t`. See Regular Expression below for details. A maximum of 10 `regular_expression` blocks may be specified.
     */
    @JvmName("mefblgqrxrcmrscv")
    public suspend fun regularExpressions(`value`: List<RegexPatternSetRegularExpressionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regularExpressions = mapped
    }

    /**
     * @param argument One or more blocks of regular expression patterns that you want AWS WAF to search for, such as `B[a@]dB[o0]t`. See Regular Expression below for details. A maximum of 10 `regular_expression` blocks may be specified.
     */
    @JvmName("vewpiltuwpmcplav")
    public suspend fun regularExpressions(argument: List<suspend RegexPatternSetRegularExpressionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RegexPatternSetRegularExpressionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.regularExpressions = mapped
    }

    /**
     * @param argument One or more blocks of regular expression patterns that you want AWS WAF to search for, such as `B[a@]dB[o0]t`. See Regular Expression below for details. A maximum of 10 `regular_expression` blocks may be specified.
     */
    @JvmName("niitvmvdpfuqeapp")
    public suspend fun regularExpressions(vararg argument: suspend RegexPatternSetRegularExpressionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RegexPatternSetRegularExpressionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.regularExpressions = mapped
    }

    /**
     * @param argument One or more blocks of regular expression patterns that you want AWS WAF to search for, such as `B[a@]dB[o0]t`. See Regular Expression below for details. A maximum of 10 `regular_expression` blocks may be specified.
     */
    @JvmName("slcgyouiufyxicks")
    public suspend fun regularExpressions(argument: suspend RegexPatternSetRegularExpressionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            RegexPatternSetRegularExpressionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.regularExpressions = mapped
    }

    /**
     * @param values One or more blocks of regular expression patterns that you want AWS WAF to search for, such as `B[a@]dB[o0]t`. See Regular Expression below for details. A maximum of 10 `regular_expression` blocks may be specified.
     */
    @JvmName("dmkdsnlusedyvcrg")
    public suspend fun regularExpressions(vararg values: RegexPatternSetRegularExpressionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regularExpressions = mapped
    }

    /**
     * @param value Specifies whether this is for an AWS CloudFront distribution or for a regional application. Valid values are `CLOUDFRONT` or `REGIONAL`. To work with CloudFront, you must also specify the region `us-east-1` (N. Virginia) on the AWS provider.
     */
    @JvmName("xjqfvxvhjvvpdklh")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value An array of key:value pairs to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("navsdbwogmyfwryt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values An array of key:value pairs to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gscvexfuqmrltswu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): RegexPatternSetArgs = RegexPatternSetArgs(
        description = description,
        name = name,
        regularExpressions = regularExpressions,
        scope = scope,
        tags = tags,
    )
}
