@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin

import com.pulumi.aws.wafv2.kotlin.outputs.WebAclAssociationConfig
import com.pulumi.aws.wafv2.kotlin.outputs.WebAclCaptchaConfig
import com.pulumi.aws.wafv2.kotlin.outputs.WebAclChallengeConfig
import com.pulumi.aws.wafv2.kotlin.outputs.WebAclCustomResponseBody
import com.pulumi.aws.wafv2.kotlin.outputs.WebAclDefaultAction
import com.pulumi.aws.wafv2.kotlin.outputs.WebAclRule
import com.pulumi.aws.wafv2.kotlin.outputs.WebAclVisibilityConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.wafv2.kotlin.outputs.WebAclAssociationConfig.Companion.toKotlin as webAclAssociationConfigToKotlin
import com.pulumi.aws.wafv2.kotlin.outputs.WebAclCaptchaConfig.Companion.toKotlin as webAclCaptchaConfigToKotlin
import com.pulumi.aws.wafv2.kotlin.outputs.WebAclChallengeConfig.Companion.toKotlin as webAclChallengeConfigToKotlin
import com.pulumi.aws.wafv2.kotlin.outputs.WebAclCustomResponseBody.Companion.toKotlin as webAclCustomResponseBodyToKotlin
import com.pulumi.aws.wafv2.kotlin.outputs.WebAclDefaultAction.Companion.toKotlin as webAclDefaultActionToKotlin
import com.pulumi.aws.wafv2.kotlin.outputs.WebAclRule.Companion.toKotlin as webAclRuleToKotlin
import com.pulumi.aws.wafv2.kotlin.outputs.WebAclVisibilityConfig.Companion.toKotlin as webAclVisibilityConfigToKotlin

/**
 * Builder for [WebAcl].
 */
@PulumiTagMarker
public class WebAclResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebAclArgs = WebAclArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebAclArgsBuilder.() -> Unit) {
        val builder = WebAclArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WebAcl {
        val builtJavaResource = com.pulumi.aws.wafv2.WebAcl(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return WebAcl(builtJavaResource)
    }
}

public class WebAcl internal constructor(
    override val javaResource: com.pulumi.aws.wafv2.WebAcl,
) : KotlinCustomResource(javaResource, WebAclMapper) {
    /**
     * The URL to use in SDK integrations with managed rule groups.
     */
    public val applicationIntegrationUrl: Output<String>
        get() = javaResource.applicationIntegrationUrl().applyValue({ args0 -> args0 })

    /**
     * The ARN of the WAF WebACL.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Specifies custom configurations for the associations between the web ACL and protected resources. See `association_config` below for details.
     */
    public val associationConfig: Output<WebAclAssociationConfig>?
        get() = javaResource.associationConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> webAclAssociationConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Web ACL capacity units (WCUs) currently being used by this web ACL.
     */
    public val capacity: Output<Int>
        get() = javaResource.capacity().applyValue({ args0 -> args0 })

    /**
     * Specifies how AWS WAF should handle CAPTCHA evaluations on the ACL level (used by [AWS Bot Control](https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html)). See `captcha_config` below for details.
     */
    public val captchaConfig: Output<WebAclCaptchaConfig>?
        get() = javaResource.captchaConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> webAclCaptchaConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Specifies how AWS WAF should handle Challenge evaluations on the ACL level (used by [AWS Bot Control](https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html)). See `challenge_config` below for details.
     */
    public val challengeConfig: Output<WebAclChallengeConfig>?
        get() = javaResource.challengeConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> webAclChallengeConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Defines custom response bodies that can be referenced by `custom_response` actions. See `custom_response_body` below for details.
     */
    public val customResponseBodies: Output<List<WebAclCustomResponseBody>>?
        get() = javaResource.customResponseBodies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        webAclCustomResponseBodyToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Action to perform if none of the `rules` contained in the WebACL match. See `default_action` below for details.
     */
    public val defaultAction: Output<WebAclDefaultAction>
        get() = javaResource.defaultAction().applyValue({ args0 ->
            args0.let({ args0 ->
                webAclDefaultActionToKotlin(args0)
            })
        })

    /**
     * Friendly description of the WebACL.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val lockToken: Output<String>
        get() = javaResource.lockToken().applyValue({ args0 -> args0 })

    /**
     * Friendly name of the WebACL.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Raw JSON string to allow more than three nested statements. Conflicts with `rule` attribute. This is for advanced use cases where more than 3 levels of nested statements are required. **There is no drift detection at this time**. If you use this attribute instead of `rule`, you will be foregoing drift detection. See the AWS [documentation](https://docs.aws.amazon.com/waf/latest/APIReference/API_CreateWebACL.html) for the JSON structure.
     */
    public val ruleJson: Output<String>?
        get() = javaResource.ruleJson().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Rule blocks used to identify the web requests that you want to `allow`, `block`, or `count`. See `rule` below for details.
     */
    public val rules: Output<List<WebAclRule>>?
        get() = javaResource.rules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> webAclRuleToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Specifies whether this is for an AWS CloudFront distribution or for a regional application. Valid values are `CLOUDFRONT` or `REGIONAL`. To work with CloudFront, you must also specify the region `us-east-1` (N. Virginia) on the AWS provider.
     */
    public val scope: Output<String>
        get() = javaResource.scope().applyValue({ args0 -> args0 })

    /**
     * Map of key-value pairs to associate with the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Specifies the domains that AWS WAF should accept in a web request token. This enables the use of tokens across multiple protected websites. When AWS WAF provides a token, it uses the domain of the AWS resource that the web ACL is protecting. If you don't specify a list of token domains, AWS WAF accepts tokens only for the domain of the protected resource. With a token domain list, AWS WAF accepts the resource's host domain plus all domains in the token domain list, including their prefixed subdomains.
     */
    public val tokenDomains: Output<List<String>>?
        get() = javaResource.tokenDomains().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Defines and enables Amazon CloudWatch metrics and web request sample collection. See `visibility_config` below for details.
     */
    public val visibilityConfig: Output<WebAclVisibilityConfig>
        get() = javaResource.visibilityConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                webAclVisibilityConfigToKotlin(args0)
            })
        })
}

public object WebAclMapper : ResourceMapper<WebAcl> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.wafv2.WebAcl::class == javaResource::class

    override fun map(javaResource: Resource): WebAcl = WebAcl(
        javaResource as
            com.pulumi.aws.wafv2.WebAcl,
    )
}

/**
 * @see [WebAcl].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebAcl].
 */
public suspend fun webAcl(name: String, block: suspend WebAclResourceBuilder.() -> Unit): WebAcl {
    val builder = WebAclResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebAcl].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webAcl(name: String): WebAcl {
    val builder = WebAclResourceBuilder()
    builder.name(name)
    return builder.build()
}
