@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin

import com.pulumi.aws.wafv2.WebAclAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Creates a WAFv2 Web ACL Association.
 * > **NOTE on associating a WAFv2 Web ACL with a Cloudfront distribution:** Do not use this resource to associate a WAFv2 Web ACL with a Cloudfront Distribution. The [AWS API call backing this resource](https://docs.aws.amazon.com/waf/latest/APIReference/API_AssociateWebACL.html) notes that you should use the `web_acl_id` property on the `cloudfront_distribution` instead.
 * [1]: https://docs.aws.amazon.com/waf/latest/APIReference/API_AssociateWebACL.html
 * ## Import
 * Using `pulumi import`, import WAFv2 Web ACL Association using `WEB_ACL_ARN,RESOURCE_ARN`. For example:
 * ```sh
 * $ pulumi import aws:wafv2/webAclAssociation:WebAclAssociation example arn:aws:wafv2:...7ce849ea,arn:aws:apigateway:...ages/name
 * ```
 * @property resourceArn The Amazon Resource Name (ARN) of the resource to associate with the web ACL. This must be an ARN of an Application Load Balancer, an Amazon API Gateway stage (REST only, HTTP is unsupported), an Amazon Cognito User Pool, an Amazon AppSync GraphQL API, an Amazon App Runner service, or an Amazon Verified Access instance.
 * @property webAclArn The Amazon Resource Name (ARN) of the Web ACL that you want to associate with the resource.
 */
public data class WebAclAssociationArgs(
    public val resourceArn: Output<String>? = null,
    public val webAclArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.wafv2.WebAclAssociationArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.WebAclAssociationArgs =
        com.pulumi.aws.wafv2.WebAclAssociationArgs.builder()
            .resourceArn(resourceArn?.applyValue({ args0 -> args0 }))
            .webAclArn(webAclArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAclAssociationArgs].
 */
@PulumiTagMarker
public class WebAclAssociationArgsBuilder internal constructor() {
    private var resourceArn: Output<String>? = null

    private var webAclArn: Output<String>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the resource to associate with the web ACL. This must be an ARN of an Application Load Balancer, an Amazon API Gateway stage (REST only, HTTP is unsupported), an Amazon Cognito User Pool, an Amazon AppSync GraphQL API, an Amazon App Runner service, or an Amazon Verified Access instance.
     */
    @JvmName("qlplynjstqbendjq")
    public suspend fun resourceArn(`value`: Output<String>) {
        this.resourceArn = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Web ACL that you want to associate with the resource.
     */
    @JvmName("odbujmxhvhkatclb")
    public suspend fun webAclArn(`value`: Output<String>) {
        this.webAclArn = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the resource to associate with the web ACL. This must be an ARN of an Application Load Balancer, an Amazon API Gateway stage (REST only, HTTP is unsupported), an Amazon Cognito User Pool, an Amazon AppSync GraphQL API, an Amazon App Runner service, or an Amazon Verified Access instance.
     */
    @JvmName("rwusrqfvstchjysx")
    public suspend fun resourceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceArn = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Web ACL that you want to associate with the resource.
     */
    @JvmName("bgadscsbjkurjcdd")
    public suspend fun webAclArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webAclArn = mapped
    }

    internal fun build(): WebAclAssociationArgs = WebAclAssociationArgs(
        resourceArn = resourceArn,
        webAclArn = webAclArn,
    )
}
