@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.GetRegexPatternSetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRegexPatternSet.
 * @property name Name of the WAFv2 Regex Pattern Set.
 * @property scope Specifies whether this is for an AWS CloudFront distribution or for a regional application. Valid values are `CLOUDFRONT` or `REGIONAL`. To work with CloudFront, you must also specify the region `us-east-1` (N. Virginia) on the AWS provider.
 */
public data class GetRegexPatternSetPlainArgs(
    public val name: String,
    public val scope: String,
) : ConvertibleToJava<com.pulumi.aws.wafv2.inputs.GetRegexPatternSetPlainArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.GetRegexPatternSetPlainArgs =
        com.pulumi.aws.wafv2.inputs.GetRegexPatternSetPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .scope(scope.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRegexPatternSetPlainArgs].
 */
@PulumiTagMarker
public class GetRegexPatternSetPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var scope: String? = null

    /**
     * @param value Name of the WAFv2 Regex Pattern Set.
     */
    @JvmName("ubrcnwktelcnhuwh")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Specifies whether this is for an AWS CloudFront distribution or for a regional application. Valid values are `CLOUDFRONT` or `REGIONAL`. To work with CloudFront, you must also specify the region `us-east-1` (N. Virginia) on the AWS provider.
     */
    @JvmName("uwrdvodomgtedbgl")
    public suspend fun scope(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scope = mapped
    }

    internal fun build(): GetRegexPatternSetPlainArgs = GetRegexPatternSetPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        scope = scope ?: throw PulumiNullFieldException("scope"),
    )
}
